/*
 * Decompiled with CFR 0.152.
 */
package me.coley.cafedude.classfile.attribute;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import me.coley.cafedude.classfile.attribute.Attribute;
import me.coley.cafedude.classfile.behavior.CpAccessor;

public class ModuleAttribute
extends Attribute {
    private int moduleIndex;
    private int flags;
    private int versionIndex;
    private List<Requires> requires;
    private List<Exports> exports;
    private List<Opens> opens;
    private List<Integer> uses;
    private List<Provides> provides;

    public ModuleAttribute(int attrNameIndex, int moduleIndex, int flags, int versionIndex, List<Requires> requires, List<Exports> exports, List<Opens> opens, List<Integer> uses, List<Provides> provides) {
        super(attrNameIndex);
        this.moduleIndex = moduleIndex;
        this.flags = flags;
        this.versionIndex = versionIndex;
        this.requires = requires;
        this.exports = exports;
        this.opens = opens;
        this.uses = uses;
        this.provides = provides;
    }

    public int getModuleIndex() {
        return this.moduleIndex;
    }

    public void setModuleIndex(int moduleIndex) {
        this.moduleIndex = moduleIndex;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public int getVersionIndex() {
        return this.versionIndex;
    }

    public void setVersionIndex(int versionIndex) {
        this.versionIndex = versionIndex;
    }

    public List<Requires> getRequires() {
        return this.requires;
    }

    public void setRequires(List<Requires> requires) {
        this.requires = requires;
    }

    public List<Exports> getExports() {
        return this.exports;
    }

    public void setExports(List<Exports> exports) {
        this.exports = exports;
    }

    public List<Opens> getOpens() {
        return this.opens;
    }

    public void setOpens(List<Opens> opens) {
        this.opens = opens;
    }

    public List<Integer> getUses() {
        return this.uses;
    }

    public void setUses(List<Integer> uses) {
        this.uses = uses;
    }

    public List<Provides> getProvides() {
        return this.provides;
    }

    public void setProvides(List<Provides> provides) {
        this.provides = provides;
    }

    @Override
    public Set<Integer> cpAccesses() {
        Set<Integer> set = super.cpAccesses();
        set.add(this.getModuleIndex());
        set.add(this.getVersionIndex());
        set.addAll(this.getUses());
        for (Requires requires : this.getRequires()) {
            set.addAll(requires.cpAccesses());
        }
        for (Exports exports : this.getExports()) {
            set.addAll(exports.cpAccesses());
        }
        for (Opens opens : this.getOpens()) {
            set.addAll(opens.cpAccesses());
        }
        for (Provides provides : this.getProvides()) {
            set.addAll(provides.cpAccesses());
        }
        return set;
    }

    @Override
    public int computeInternalLength() {
        int len = 6;
        len += 2 + this.requires.size() * 6;
        len += 2 + this.exports.stream().mapToInt(Exports::length).sum();
        len += 2 + this.opens.stream().mapToInt(Opens::length).sum();
        len += 2 + this.uses.size() * 2;
        return len += 2 + this.provides.stream().mapToInt(Provides::length).sum();
    }

    public static class Provides
    implements CpAccessor {
        private int index;
        private List<Integer> withIndex;

        public Provides(int index, List<Integer> withIndex) {
            this.index = index;
            this.withIndex = withIndex;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public List<Integer> getWithIndices() {
            return this.withIndex;
        }

        public void setWithIndex(List<Integer> withIndex) {
            this.withIndex = withIndex;
        }

        public int length() {
            return 4 + 2 * this.withIndex.size();
        }

        @Override
        public Set<Integer> cpAccesses() {
            TreeSet<Integer> set = new TreeSet<Integer>();
            set.add(this.getIndex());
            set.addAll(this.getWithIndices());
            return set;
        }
    }

    public static class Opens
    implements CpAccessor {
        private int index;
        private int flags;
        private List<Integer> toIndices;

        public Opens(int index, int flags, List<Integer> toIndices) {
            this.index = index;
            this.flags = flags;
            this.toIndices = toIndices;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public int getFlags() {
            return this.flags;
        }

        public void setFlags(int flags) {
            this.flags = flags;
        }

        public List<Integer> getToIndices() {
            return this.toIndices;
        }

        public void setToIndices(List<Integer> toIndex) {
            this.toIndices = toIndex;
        }

        public int length() {
            return 6 + 2 * this.toIndices.size();
        }

        @Override
        public Set<Integer> cpAccesses() {
            TreeSet<Integer> set = new TreeSet<Integer>();
            set.add(this.getIndex());
            set.addAll(this.getToIndices());
            return set;
        }
    }

    public static class Exports
    implements CpAccessor {
        private int index;
        private int flags;
        private List<Integer> toIndices;

        public Exports(int index, int flags, List<Integer> toIndices) {
            this.index = index;
            this.flags = flags;
            this.toIndices = toIndices;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public int getFlags() {
            return this.flags;
        }

        public void setFlags(int flags) {
            this.flags = flags;
        }

        public List<Integer> getToIndices() {
            return this.toIndices;
        }

        public void setToIndices(List<Integer> toIndex) {
            this.toIndices = toIndex;
        }

        public int length() {
            return 6 + 2 * this.toIndices.size();
        }

        @Override
        public Set<Integer> cpAccesses() {
            TreeSet<Integer> set = new TreeSet<Integer>();
            set.add(this.getIndex());
            set.addAll(this.getToIndices());
            return set;
        }
    }

    public static class Requires
    implements CpAccessor {
        private int index;
        private int flags;
        private int versionIndex;

        public Requires(int index, int flags, int versionIndex) {
            this.index = index;
            this.flags = flags;
            this.versionIndex = versionIndex;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public int getFlags() {
            return this.flags;
        }

        public void setFlags(int flags) {
            this.flags = flags;
        }

        public int getVersionIndex() {
            return this.versionIndex;
        }

        public void setVersionIndex(int versionIndex) {
            this.versionIndex = versionIndex;
        }

        @Override
        public Set<Integer> cpAccesses() {
            TreeSet<Integer> set = new TreeSet<Integer>();
            set.add(this.getVersionIndex());
            set.add(this.getIndex());
            return set;
        }
    }
}

