/*
 * Decompiled with CFR 0.152.
 */
package me.coley.cafedude.classfile.annotation;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import me.coley.cafedude.classfile.annotation.ElementValue;

public class ArrayElementValue
extends ElementValue {
    private List<ElementValue> array;

    public ArrayElementValue(char tag, List<ElementValue> array) {
        super(tag);
        if (tag != '[') {
            throw new IllegalArgumentException("Array element value must have '[' tag");
        }
        this.array = array;
    }

    public List<ElementValue> getArray() {
        return this.array;
    }

    public void setArray(List<ElementValue> array) {
        this.array = array;
    }

    @Override
    public char getTag() {
        return super.getTag();
    }

    @Override
    public Set<Integer> cpAccesses() {
        TreeSet<Integer> set = new TreeSet<Integer>();
        for (ElementValue value : this.getArray()) {
            set.addAll(value.cpAccesses());
        }
        return set;
    }

    @Override
    public int computeLength() {
        return 3 + this.array.stream().mapToInt(ElementValue::computeLength).sum();
    }
}

