/*
 * Decompiled with CFR 0.152.
 */
package org.jf.util;

import java.util.LinkedList;
import java.util.List;

public class TrieTree {
    private final TrieNode root = new TrieNode();

    public void add(String word) {
        if (word == null) {
            return;
        }
        TrieNode current = this.root;
        StringBuilder wordBuilder = new StringBuilder();
        for (int index = 0; index < word.length(); ++index) {
            char content = word.charAt(index);
            wordBuilder.append(content);
            TrieNode node = new TrieNode(content, wordBuilder.toString());
            if (current.children.contains(node)) {
                current = current.nextNode(content);
            } else {
                if (index == word.length() - 1) {
                    node.isEnd = true;
                }
                current.children.add(node);
                current = node;
            }
            if (index != word.length() - 1) continue;
            current.isEnd = true;
        }
    }

    public void addAll(List<String> words) {
        for (String word : words) {
            this.add(word);
        }
    }

    public boolean search(String word) {
        if (word == null) {
            return false;
        }
        TrieNode current = this.root;
        for (int index = 0; index < word.length(); ++index) {
            char content = word.charAt(index);
            if (current.isEnd) break;
            TrieNode node = new TrieNode(content, null);
            if (!current.children.contains(node)) {
                return false;
            }
            current = current.nextNode(content);
        }
        return current.isEnd;
    }

    private static class TrieNode {
        char content;
        String word;
        boolean isEnd = false;
        LinkedList<TrieNode> children = new LinkedList();

        public TrieNode() {
        }

        public TrieNode(char content, String word) {
            this.content = content;
            this.word = word;
        }

        public boolean equals(Object object) {
            if (object instanceof TrieNode) {
                return ((TrieNode)object).content == this.content;
            }
            return false;
        }

        public TrieNode nextNode(char content) {
            for (TrieNode childNode : this.children) {
                if (childNode.content != content) continue;
                return childNode;
            }
            return null;
        }
    }
}

