/*
 * Decompiled with CFR 0.152.
 */
package org.jf.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class PathUtil {
    private PathUtil() {
    }

    public static File getRelativeFile(File baseFile, File fileToRelativize) throws IOException {
        if (baseFile.isFile()) {
            baseFile = baseFile.getParentFile();
        }
        return new File(PathUtil.getRelativeFileInternal(baseFile.getCanonicalFile(), fileToRelativize.getCanonicalFile()));
    }

    static String getRelativeFileInternal(File canonicalBaseFile, File canonicalFileToRelativize) {
        int i;
        List<String> basePath = PathUtil.getPathComponents(canonicalBaseFile);
        List<String> pathToRelativize = PathUtil.getPathComponents(canonicalFileToRelativize);
        if (!basePath.get(0).equals(pathToRelativize.get(0))) {
            return canonicalFileToRelativize.getPath();
        }
        StringBuilder sb = new StringBuilder();
        for (int commonDirs = 1; commonDirs < basePath.size() && commonDirs < pathToRelativize.size() && basePath.get(commonDirs).equals(pathToRelativize.get(commonDirs)); ++commonDirs) {
        }
        boolean first = true;
        for (i = commonDirs; i < basePath.size(); ++i) {
            if (!first) {
                sb.append(File.separatorChar);
            } else {
                first = false;
            }
            sb.append("..");
        }
        first = true;
        for (i = commonDirs; i < pathToRelativize.size(); ++i) {
            if (first) {
                if (sb.length() != 0) {
                    sb.append(File.separatorChar);
                }
                first = false;
            } else {
                sb.append(File.separatorChar);
            }
            sb.append(pathToRelativize.get(i));
        }
        if (sb.length() == 0) {
            return ".";
        }
        return sb.toString();
    }

    private static List<String> getPathComponents(File file) {
        ArrayList<String> path = new ArrayList<String>();
        while (file != null) {
            File parentFile = file.getParentFile();
            if (parentFile == null) {
                path.add(file.getPath());
            } else {
                path.add(file.getName());
            }
            file = parentFile;
        }
        return path;
    }
}

