/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.writer.pool;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Ordering;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import org.jf.dexlib2.base.reference.BaseTypeReference;
import org.jf.dexlib2.iface.Annotation;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.Field;
import org.jf.dexlib2.writer.pool.PoolMethod;
import org.jf.dexlib2.writer.pool.TypeListPool;

class PoolClassDef
extends BaseTypeReference
implements ClassDef {
    final ClassDef classDef;
    final TypeListPool.Key<List<String>> interfaces;
    final ImmutableSortedSet<Field> staticFields;
    final ImmutableSortedSet<Field> instanceFields;
    final ImmutableSortedSet<PoolMethod> directMethods;
    final ImmutableSortedSet<PoolMethod> virtualMethods;
    int classDefIndex = -1;
    int encodedArrayOffset = 0;
    int annotationDirectoryOffset = 0;

    PoolClassDef(ClassDef classDef) {
        this.classDef = classDef;
        this.interfaces = new TypeListPool.Key<ImmutableList>(ImmutableList.copyOf(classDef.getInterfaces()));
        this.staticFields = ImmutableSortedSet.copyOf(classDef.getStaticFields());
        this.instanceFields = ImmutableSortedSet.copyOf(classDef.getInstanceFields());
        this.directMethods = ImmutableSortedSet.copyOf((Iterable)Iterables.transform(classDef.getDirectMethods(), PoolMethod.TRANSFORM));
        this.virtualMethods = ImmutableSortedSet.copyOf((Iterable)Iterables.transform(classDef.getVirtualMethods(), PoolMethod.TRANSFORM));
    }

    @Override
    public String getType() {
        return this.classDef.getType();
    }

    @Override
    public int getAccessFlags() {
        return this.classDef.getAccessFlags();
    }

    @Override
    public String getSuperclass() {
        return this.classDef.getSuperclass();
    }

    @Override
    public List<String> getInterfaces() {
        return (List)this.interfaces.types;
    }

    @Override
    public String getSourceFile() {
        return this.classDef.getSourceFile();
    }

    @Override
    public Set<? extends Annotation> getAnnotations() {
        return this.classDef.getAnnotations();
    }

    public SortedSet<Field> getStaticFields() {
        return this.staticFields;
    }

    public SortedSet<Field> getInstanceFields() {
        return this.instanceFields;
    }

    public Collection<Field> getFields() {
        return new AbstractCollection<Field>(){

            @Override
            public Iterator<Field> iterator() {
                return Iterators.mergeSorted((Iterable)ImmutableList.of((Object)PoolClassDef.this.staticFields.iterator(), (Object)PoolClassDef.this.instanceFields.iterator()), (Comparator)Ordering.natural());
            }

            @Override
            public int size() {
                return PoolClassDef.this.staticFields.size() + PoolClassDef.this.instanceFields.size();
            }
        };
    }

    public SortedSet<PoolMethod> getDirectMethods() {
        return this.directMethods;
    }

    public SortedSet<PoolMethod> getVirtualMethods() {
        return this.virtualMethods;
    }

    public Collection<PoolMethod> getMethods() {
        return new AbstractCollection<PoolMethod>(){

            @Override
            public Iterator<PoolMethod> iterator() {
                return Iterators.mergeSorted((Iterable)ImmutableList.of((Object)PoolClassDef.this.directMethods.iterator(), (Object)PoolClassDef.this.virtualMethods.iterator()), (Comparator)Ordering.natural());
            }

            @Override
            public int size() {
                return PoolClassDef.this.directMethods.size() + PoolClassDef.this.virtualMethods.size();
            }
        };
    }
}

