/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.writer.pool;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import org.jf.dexlib2.writer.pool.DexPool;
import org.jf.dexlib2.writer.pool.Markable;

public class BasePool<Key, Value>
implements Markable {
    protected final DexPool dexPool;
    protected final Map<Key, Value> internedItems = Maps.newLinkedHashMap();
    private int markedItemCount = -1;

    public BasePool(DexPool dexPool) {
        this.dexPool = dexPool;
    }

    @Override
    public void mark() {
        this.markedItemCount = this.internedItems.size();
    }

    @Override
    public void reset() {
        if (this.markedItemCount < 0) {
            throw new IllegalStateException("mark() must be called before calling reset()");
        }
        if (this.markedItemCount == this.internedItems.size()) {
            return;
        }
        Iterator<Key> keys = this.internedItems.keySet().iterator();
        for (int i = 0; i < this.markedItemCount; ++i) {
            keys.next();
        }
        while (keys.hasNext()) {
            keys.next();
            keys.remove();
        }
    }

    public int getItemCount() {
        return this.internedItems.size();
    }
}

