/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.writer.builder;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jf.dexlib2.iface.Annotation;
import org.jf.dexlib2.writer.AnnotationSetSection;
import org.jf.dexlib2.writer.builder.BaseBuilderPool;
import org.jf.dexlib2.writer.builder.BuilderAnnotation;
import org.jf.dexlib2.writer.builder.BuilderAnnotationPool;
import org.jf.dexlib2.writer.builder.BuilderAnnotationSet;
import org.jf.dexlib2.writer.builder.BuilderMapEntryCollection;
import org.jf.dexlib2.writer.builder.DexBuilder;

class BuilderAnnotationSetPool
extends BaseBuilderPool
implements AnnotationSetSection<BuilderAnnotation, BuilderAnnotationSet> {
    private final ConcurrentMap<Set<? extends Annotation>, BuilderAnnotationSet> internedItems = Maps.newConcurrentMap();

    public BuilderAnnotationSetPool(DexBuilder dexBuilder) {
        super(dexBuilder);
    }

    public BuilderAnnotationSet internAnnotationSet(Set<? extends Annotation> annotations) {
        if (annotations == null) {
            return BuilderAnnotationSet.EMPTY;
        }
        BuilderAnnotationSet ret = (BuilderAnnotationSet)this.internedItems.get(annotations);
        if (ret != null) {
            return ret;
        }
        BuilderAnnotationSet annotationSet = new BuilderAnnotationSet((Set<BuilderAnnotation>)ImmutableSet.copyOf((Iterator)Iterators.transform(annotations.iterator(), (Function)new Function<Annotation, BuilderAnnotation>(){

            public BuilderAnnotation apply(Annotation input) {
                return ((BuilderAnnotationPool)BuilderAnnotationSetPool.this.dexBuilder.annotationSection).internAnnotation(input);
            }
        })));
        ret = this.internedItems.putIfAbsent(annotationSet, annotationSet);
        return ret == null ? annotationSet : ret;
    }

    @Override
    public Collection<? extends BuilderAnnotation> getAnnotations(BuilderAnnotationSet key) {
        return key.annotations;
    }

    @Override
    public int getNullableItemOffset(BuilderAnnotationSet key) {
        return key == null ? 0 : key.offset;
    }

    @Override
    public int getItemOffset(BuilderAnnotationSet key) {
        return key.offset;
    }

    @Override
    public Collection<? extends Map.Entry<? extends BuilderAnnotationSet, Integer>> getItems() {
        return new BuilderMapEntryCollection<BuilderAnnotationSet>(this.internedItems.values()){

            @Override
            protected int getValue(BuilderAnnotationSet key) {
                return key.offset;
            }

            @Override
            protected int setValue(BuilderAnnotationSet key, int value) {
                int prev = key.offset;
                key.offset = value;
                return prev;
            }
        };
    }
}

