/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked.raw;

import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.raw.MapItem;
import org.jf.dexlib2.dexbacked.raw.SectionAnnotator;
import org.jf.dexlib2.dexbacked.raw.TypeIdItem;
import org.jf.dexlib2.dexbacked.raw.util.DexAnnotator;
import org.jf.dexlib2.util.AnnotatedBytes;

public class TypeListItem {
    public static final int SIZE_OFFSET = 0;
    public static final int LIST_OFFSET = 4;

    public static SectionAnnotator makeAnnotator(DexAnnotator annotator, MapItem mapItem) {
        return new SectionAnnotator(annotator, mapItem){

            @Override
            public String getItemName() {
                return "type_list";
            }

            @Override
            protected void annotateItem(AnnotatedBytes out, int itemIndex, String itemIdentity) {
                int size = this.dexFile.readSmallUint(out.getCursor());
                out.annotate(4, "size: %d", size);
                for (int i = 0; i < size; ++i) {
                    int typeIndex = this.dexFile.readUshort(out.getCursor());
                    out.annotate(2, TypeIdItem.getReferenceAnnotation(this.dexFile, typeIndex), new Object[0]);
                }
            }

            @Override
            public int getItemAlignment() {
                return 4;
            }
        };
    }

    public static String getReferenceAnnotation(DexBackedDexFile dexFile, int typeListOffset) {
        if (typeListOffset == 0) {
            return "type_list_item[NO_OFFSET]";
        }
        try {
            String typeList = TypeListItem.asString(dexFile, typeListOffset);
            return String.format("type_list_item[0x%x]: %s", typeListOffset, typeList);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            return String.format("type_list_item[0x%x]", typeListOffset);
        }
    }

    public static String asString(DexBackedDexFile dexFile, int typeListOffset) {
        if (typeListOffset == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int size = dexFile.readSmallUint(typeListOffset);
        for (int i = 0; i < size; ++i) {
            int typeIndex = dexFile.readUshort(typeListOffset + 4 + i * 2);
            String type = dexFile.getType(typeIndex);
            sb.append(type);
        }
        return sb.toString();
    }
}

