/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked.raw;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.dexbacked.BaseDexBuffer;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.raw.HeaderItem;
import org.jf.dexlib2.dexbacked.raw.MapItem;
import org.jf.dexlib2.dexbacked.util.FixedSizeList;
import org.jf.dexlib2.util.AnnotatedBytes;

public class RawDexFile
extends DexBackedDexFile {
    public final HeaderItem headerItem = new HeaderItem(this);

    public RawDexFile(Opcodes opcodes, BaseDexBuffer buf) {
        super(opcodes, buf);
    }

    public RawDexFile(Opcodes opcodes, byte[] buf) {
        super(opcodes, buf);
    }

    public byte[] readByteRange(int start, int length) {
        return Arrays.copyOfRange(this.getBuf(), this.getBaseOffset() + start, this.getBaseOffset() + start + length);
    }

    public int getMapOffset() {
        return this.headerItem.getMapOffset();
    }

    public MapItem getMapItemForSection(int itemType) {
        for (MapItem mapItem : this.getMapItems()) {
            if (mapItem.getType() != itemType) continue;
            return mapItem;
        }
        return null;
    }

    public List<MapItem> getMapItems() {
        final int mapOffset = this.getMapOffset();
        final int mapSize = this.readSmallUint(mapOffset);
        return new FixedSizeList<MapItem>(){

            @Override
            public MapItem readItem(int index) {
                int mapItemOffset = mapOffset + 4 + index * 12;
                return new MapItem(RawDexFile.this, mapItemOffset);
            }

            @Override
            public int size() {
                return mapSize;
            }
        };
    }

    public void writeAnnotations(Writer out, AnnotatedBytes annotatedBytes) throws IOException {
        annotatedBytes.writeAnnotations(out, this.getBuf());
    }
}

