/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked.instruction;

import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.ReferenceType;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction;
import org.jf.dexlib2.dexbacked.reference.DexBackedReference;
import org.jf.dexlib2.iface.UpdateReference;
import org.jf.dexlib2.iface.instruction.formats.Instruction20bc;
import org.jf.dexlib2.iface.reference.Reference;
import org.jf.dexlib2.writer.builder.DexBuilder;

public class DexBackedInstruction20bc
extends DexBackedInstruction
implements Instruction20bc,
UpdateReference {
    private Reference reference = null;
    private int referenceType = -1;

    public DexBackedInstruction20bc(DexBackedDexFile dexFile, Opcode opcode, int instructionStart) {
        super(dexFile, opcode, instructionStart);
    }

    @Override
    public int getVerificationError() {
        return this.dexFile.readUbyte(this.instructionStart + 1) & 0x3F;
    }

    @Override
    public Reference getReference() {
        if (this.reference != null) {
            return this.reference;
        }
        int referenceType = this.getReferenceType();
        return DexBackedReference.makeReference(this.dexFile, referenceType, this.dexFile.readUshort(this.instructionStart + 2));
    }

    @Override
    public int getReferenceType() {
        int referenceType = this.referenceType;
        if (referenceType != -1) {
            return referenceType;
        }
        referenceType = (this.dexFile.readUbyte(this.instructionStart + 1) >>> 6) + 1;
        ReferenceType.validateReferenceType(referenceType);
        this.referenceType = referenceType;
        return this.referenceType;
    }

    @Override
    public void updateReference(DexBuilder dexBuilder) {
        this.reference = dexBuilder.internReference(this.getReference());
    }
}

