/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.builder.instruction;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import org.jf.dexlib2.Format;
import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.builder.BuilderSwitchPayload;
import org.jf.dexlib2.builder.SwitchLabelElement;
import org.jf.dexlib2.builder.instruction.BuilderSwitchElement;
import org.jf.dexlib2.iface.instruction.formats.SparseSwitchPayload;

public class BuilderSparseSwitchPayload
extends BuilderSwitchPayload
implements SparseSwitchPayload {
    public static final Opcode OPCODE = Opcode.SPARSE_SWITCH_PAYLOAD;
    protected final List<BuilderSwitchElement> switchElements;

    public BuilderSparseSwitchPayload(List<? extends SwitchLabelElement> switchElements) {
        super(OPCODE);
        this.switchElements = switchElements == null ? ImmutableList.of() : Lists.transform(switchElements, (Function)new Function<SwitchLabelElement, BuilderSwitchElement>(){

            public BuilderSwitchElement apply(SwitchLabelElement element) {
                assert (element != null);
                return new BuilderSwitchElement(BuilderSparseSwitchPayload.this, element.key, element.target);
            }
        });
    }

    public List<BuilderSwitchElement> getSwitchElements() {
        return this.switchElements;
    }

    @Override
    public int getCodeUnits() {
        return 2 + this.switchElements.size() * 4;
    }

    @Override
    public Format getFormat() {
        return BuilderSparseSwitchPayload.OPCODE.format;
    }
}

