/*
 * Decompiled with CFR 0.152.
 */
package org.jf;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.jf.CloseUtils;
import org.jf.baksmali.Adaptors.ClassDefinition;
import org.jf.baksmali.BaksmaliOptions;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.dexbacked.DexBackedClassDef;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.writer.builder.DexBuilder;
import org.jf.dexlib2.writer.io.MemoryDataStore;
import org.jf.smali.Smali;
import org.jf.smali.SmaliOptions;
import org.jf.util.IndentingWriter;
import org.jf.util.TrieTree;

public class DexLib2Utils {
    public static boolean saveDex(File in, File out) {
        try {
            DexBackedDexFile dexBackedDexFile = DexLib2Utils.loadBackedDexFile(in.getAbsolutePath());
            DexBuilder dexBuilder = new DexBuilder(Opcodes.getDefault());
            Set<? extends DexBackedClassDef> defs = dexBackedDexFile.getClasses();
            for (DexBackedClassDef dexBackedClassDef : defs) {
                Smali.assembleSmaliFile(DexLib2Utils.classToSmali(dexBackedClassDef), dexBuilder, new SmaliOptions());
            }
            return DexLib2Utils.saveDexFileDexLib2(dexBuilder, out.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static long splitDex(File in, File out, List<String> whiteList, List<String> blackList) {
        if (whiteList.size() == 0) {
            return 0L;
        }
        try {
            String rule;
            int index;
            for (index = 0; index < whiteList.size(); ++index) {
                rule = whiteList.get(index);
                if (rule.startsWith("L") || rule.endsWith(";")) continue;
                whiteList.set(index, "L" + rule.replace(".", "/"));
            }
            for (index = 0; index < blackList.size(); ++index) {
                rule = blackList.get(index);
                if (rule.startsWith("L") || rule.endsWith(";")) continue;
                blackList.set(index, "L" + rule.replace(".", "/"));
            }
            DexBackedDexFile dexBackedDexFile = DexLib2Utils.loadBackedDexFile(in.getAbsolutePath());
            DexBuilder dexBuilder = new DexBuilder(Opcodes.getDefault());
            Set<? extends DexBackedClassDef> defs = dexBackedDexFile.getClasses();
            ArrayList<String> allowList = new ArrayList<String>();
            TrieTree whiteListTree = new TrieTree();
            whiteListTree.addAll(whiteList);
            TrieTree blackListTree = new TrieTree();
            blackListTree.addAll(blackList);
            for (DexBackedClassDef dexBackedClassDef : defs) {
                String className = dexBackedClassDef.getType();
                if (!whiteListTree.search(className) || blackListTree.search(className)) continue;
                allowList.add(className);
                Smali.assembleSmaliFile(DexLib2Utils.classToSmali(dexBackedClassDef), dexBuilder, new SmaliOptions());
            }
            return DexLib2Utils.saveDexFileDexLib2(dexBuilder, out.getAbsolutePath()) ? (long)allowList.size() : 0L;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static boolean mergerAndCoverDexFile(File mainDex, File secondDex, File outDexFile) {
        try {
            DexBackedDexFile mainDexFile = DexLib2Utils.loadBackedDexFile(mainDex.getAbsolutePath());
            DexBackedDexFile secondDexFile = DexLib2Utils.loadBackedDexFile(secondDex.getAbsolutePath());
            DexBuilder dexBuilder = new DexBuilder(Opcodes.getDefault());
            ArrayList<String> inserted = new ArrayList<String>();
            Set<? extends DexBackedClassDef> secondDefs = secondDexFile.getClasses();
            for (DexBackedClassDef dexBackedClassDef : secondDefs) {
                inserted.add(dexBackedClassDef.getType());
                dexBuilder.internClassDef(dexBackedClassDef);
            }
            Set<? extends DexBackedClassDef> mainDefs = mainDexFile.getClasses();
            for (DexBackedClassDef dexBackedClassDef : mainDefs) {
                if (inserted.contains(dexBackedClassDef.getType())) continue;
                dexBuilder.internClassDef(dexBackedClassDef);
            }
            return DexLib2Utils.saveDexFileDexLib2(dexBuilder, outDexFile.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean saveDexFileDexLib2(DexBuilder dexBuilder, String dexpath) {
        boolean bl;
        MemoryDataStore store = null;
        try {
            store = new MemoryDataStore();
            dexBuilder.writeTo(store);
            byte[] dexByte = Arrays.copyOf(store.getBufferData(), store.getSize());
            bl = DexLib2Utils.createFile(dexpath, dexByte);
        }
        catch (Exception e) {
            boolean bl2;
            try {
                e.printStackTrace();
                bl2 = false;
            }
            catch (Throwable throwable) {
                CloseUtils.close(store);
                throw throwable;
            }
            CloseUtils.close(store);
            return bl2;
        }
        CloseUtils.close(store);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean createFile(String path, byte[] content) {
        boolean bl;
        File file;
        FileOutputStream fos;
        block6: {
            boolean del;
            fos = null;
            file = new File(path);
            if (!file.exists() || (del = file.delete())) break block6;
            boolean bl2 = false;
            CloseUtils.close(fos);
            return bl2;
        }
        try {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            fos = new FileOutputStream(path);
            fos.write(content);
            fos.flush();
            bl = file.exists();
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                bl = false;
            }
            catch (Throwable throwable) {
                CloseUtils.close(fos);
                throw throwable;
            }
            CloseUtils.close(fos);
            return bl;
        }
        CloseUtils.close(fos);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String classToSmali(ClassDef def) {
        String string;
        ClassDefinition classDefinition = new ClassDefinition(new BaksmaliOptions(), def);
        StringWriter stringWrapper = new StringWriter();
        IndentingWriter writer = new IndentingWriter(stringWrapper);
        try {
            classDefinition.writeTo(writer);
            string = stringWrapper.toString();
        }
        catch (IOException e) {
            String string2;
            try {
                string2 = null;
            }
            catch (Throwable throwable) {
                CloseUtils.close(stringWrapper, writer);
                throw throwable;
            }
            CloseUtils.close(stringWrapper, writer);
            return string2;
        }
        CloseUtils.close(stringWrapper, writer);
        return string;
    }

    private static DexBackedDexFile loadBackedDexFile(String path) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(path);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        DexBackedDexFile dexBackedDexFile = DexBackedDexFile.fromInputStream(Opcodes.getDefault(), bufferedInputStream);
        fileInputStream.close();
        bufferedInputStream.close();
        return dexBackedDexFile;
    }
}

