/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.reader;

import com.googlecode.d2j.DexException;
import com.googlecode.d2j.DexLabel;
import com.googlecode.d2j.DexType;
import com.googlecode.d2j.Field;
import com.googlecode.d2j.Method;
import com.googlecode.d2j.MethodHandle;
import com.googlecode.d2j.Proto;
import com.googlecode.d2j.Visibility;
import com.googlecode.d2j.node.DexAnnotationNode;
import com.googlecode.d2j.reader.BaseDexFileReader;
import com.googlecode.d2j.reader.InstructionFormat;
import com.googlecode.d2j.reader.InstructionIndexType;
import com.googlecode.d2j.reader.Op;
import com.googlecode.d2j.util.Mutf8;
import com.googlecode.d2j.visitors.DexAnnotationAble;
import com.googlecode.d2j.visitors.DexClassVisitor;
import com.googlecode.d2j.visitors.DexCodeVisitor;
import com.googlecode.d2j.visitors.DexDebugVisitor;
import com.googlecode.d2j.visitors.DexFieldVisitor;
import com.googlecode.d2j.visitors.DexFileVisitor;
import com.googlecode.d2j.visitors.DexMethodVisitor;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;

public class DexFileReader
implements BaseDexFileReader {
    public static final int SKIP_DEBUG = 1;
    public static final int SKIP_CODE = 4;
    public static final int SKIP_ANNOTATION = 8;
    public static final int SKIP_FIELD_CONSTANT = 16;
    public static final int IGNORE_READ_EXCEPTION = 32;
    public static final int KEEP_ALL_METHODS = 64;
    public static final int KEEP_CLINIT = 128;
    public static final int SKIP_EXCEPTION = 256;
    static final int DBG_END_SEQUENCE = 0;
    static final int DBG_ADVANCE_PC = 1;
    static final int DBG_ADVANCE_LINE = 2;
    static final int DBG_START_LOCAL = 3;
    static final int DBG_START_LOCAL_EXTENDED = 4;
    static final int DBG_END_LOCAL = 5;
    static final int DBG_RESTART_LOCAL = 6;
    static final int DBG_SET_PROLOGUE_END = 7;
    static final int DBG_SET_EPILOGUE_BEGIN = 8;
    static final int DBG_SET_FILE = 9;
    static final int DBG_FIRST_SPECIAL = 10;
    static final int DBG_LINE_BASE = -4;
    static final int DBG_LINE_RANGE = 15;
    private static final int ENDIAN_CONSTANT = 305419896;
    private static final int VALUE_BYTE = 0;
    private static final int VALUE_SHORT = 2;
    private static final int VALUE_CHAR = 3;
    private static final int VALUE_INT = 4;
    private static final int VALUE_LONG = 6;
    private static final int VALUE_FLOAT = 16;
    private static final int VALUE_DOUBLE = 17;
    private static final int VALUE_METHOD_TYPE = 21;
    private static final int VALUE_METHOD_HANDLE = 22;
    private static final int VALUE_STRING = 23;
    private static final int VALUE_TYPE = 24;
    private static final int VALUE_FIELD = 25;
    private static final int VALUE_METHOD = 26;
    private static final int VALUE_ENUM = 27;
    private static final int VALUE_ARRAY = 28;
    private static final int VALUE_ANNOTATION = 29;
    private static final int VALUE_NULL = 30;
    private static final int VALUE_BOOLEAN = 31;
    private static final int TYPE_CALL_SITE_ID_ITEM = 7;
    private static final int TYPE_METHOD_HANDLE_ITEM = 8;
    final ByteBuffer annotationSetRefListIn;
    final ByteBuffer annotationsDirectoryItemIn;
    final ByteBuffer annotationSetItemIn;
    final ByteBuffer annotationItemIn;
    final ByteBuffer classDataIn;
    final ByteBuffer codeItemIn;
    final ByteBuffer encodedArrayItemIn;
    final ByteBuffer stringIdIn;
    final ByteBuffer typeIdIn;
    final ByteBuffer protoIdIn;
    final ByteBuffer fieldIdIn;
    final ByteBuffer methoIdIn;
    final ByteBuffer classDefIn;
    final ByteBuffer typeListIn;
    final ByteBuffer stringDataIn;
    final ByteBuffer debugInfoIn;
    final ByteBuffer callSiteIdIn;
    final ByteBuffer methodHandleIdIn;
    final int string_ids_size;
    final int type_ids_size;
    final int proto_ids_size;
    final int field_ids_size;
    final int method_ids_size;
    private final int class_defs_size;
    final int call_site_ids_size;
    final int method_handle_ids_size;
    final int dex_version;

    public DexFileReader(ByteBuffer in) {
        in.position(0);
        in = in.asReadOnlyBuffer().order(ByteOrder.BIG_ENDIAN);
        int magic = in.getInt() & 0xFFFFFF00;
        int MAGIC_DEX = 1684371456;
        int MAGIC_ODEX = 1684371712;
        if (magic != 1684371456) {
            if (magic == 1684371712) {
                throw new DexException("Not support odex");
            }
            throw new DexException("not support magic.");
        }
        int version = in.getInt() >> 8;
        if (version < 0 || version < 0x303335) {
            throw new DexException("not support version.");
        }
        this.dex_version = version;
        in.order(ByteOrder.LITTLE_ENDIAN);
        DexFileReader.skip(in, 32);
        int endian_tag = in.getInt();
        if (endian_tag != 305419896) {
            throw new DexException("not support endian_tag");
        }
        DexFileReader.skip(in, 8);
        int map_off = in.getInt();
        this.string_ids_size = in.getInt();
        int string_ids_off = in.getInt();
        this.type_ids_size = in.getInt();
        int type_ids_off = in.getInt();
        this.proto_ids_size = in.getInt();
        int proto_ids_off = in.getInt();
        this.field_ids_size = in.getInt();
        int field_ids_off = in.getInt();
        this.method_ids_size = in.getInt();
        int method_ids_off = in.getInt();
        this.class_defs_size = in.getInt();
        int class_defs_off = in.getInt();
        int call_site_ids_off = 0;
        int call_site_ids_size = 0;
        int method_handle_ids_off = 0;
        int method_handle_ids_size = 0;
        if (this.dex_version > 0x303337) {
            in.position(map_off);
            int size = in.getInt();
            block4: for (int i = 0; i < size; ++i) {
                int type = in.getShort() & 0xFFFF;
                in.getShort();
                int item_size = in.getInt();
                int item_offset = in.getInt();
                switch (type) {
                    case 7: {
                        call_site_ids_off = item_offset;
                        call_site_ids_size = item_size;
                        continue block4;
                    }
                    case 8: {
                        method_handle_ids_off = item_offset;
                        method_handle_ids_size = item_size;
                        continue block4;
                    }
                }
            }
        }
        this.call_site_ids_size = call_site_ids_size;
        this.method_handle_ids_size = method_handle_ids_size;
        this.stringIdIn = DexFileReader.slice(in, string_ids_off, this.string_ids_size * 4);
        this.typeIdIn = DexFileReader.slice(in, type_ids_off, this.type_ids_size * 4);
        this.protoIdIn = DexFileReader.slice(in, proto_ids_off, this.proto_ids_size * 12);
        this.fieldIdIn = DexFileReader.slice(in, field_ids_off, this.field_ids_size * 8);
        this.methoIdIn = DexFileReader.slice(in, method_ids_off, this.method_ids_size * 8);
        this.classDefIn = DexFileReader.slice(in, class_defs_off, this.class_defs_size * 32);
        this.callSiteIdIn = DexFileReader.slice(in, call_site_ids_off, call_site_ids_size * 4);
        this.methodHandleIdIn = DexFileReader.slice(in, method_handle_ids_off, method_handle_ids_size * 8);
        in.position(0);
        this.annotationsDirectoryItemIn = in.duplicate().order(ByteOrder.LITTLE_ENDIAN);
        this.annotationSetItemIn = in.duplicate().order(ByteOrder.LITTLE_ENDIAN);
        this.annotationItemIn = in.duplicate().order(ByteOrder.LITTLE_ENDIAN);
        this.annotationSetRefListIn = in.duplicate().order(ByteOrder.LITTLE_ENDIAN);
        this.classDataIn = in.duplicate().order(ByteOrder.LITTLE_ENDIAN);
        this.codeItemIn = in.duplicate().order(ByteOrder.LITTLE_ENDIAN);
        this.stringDataIn = in.duplicate().order(ByteOrder.LITTLE_ENDIAN);
        this.encodedArrayItemIn = in.duplicate().order(ByteOrder.LITTLE_ENDIAN);
        this.typeListIn = in.duplicate().order(ByteOrder.LITTLE_ENDIAN);
        this.debugInfoIn = in.duplicate().order(ByteOrder.LITTLE_ENDIAN);
    }

    public DexFileReader(byte[] data) {
        this(ByteBuffer.wrap(data));
    }

    public DexFileReader(File file) throws IOException {
        this(file.toPath());
    }

    public DexFileReader(Path file) throws IOException {
        this(Files.readAllBytes(file));
    }

    public DexFileReader(InputStream is) throws IOException {
        this(DexFileReader.toByteArray(is));
    }

    private static int readStringIndex(ByteBuffer bs) {
        int offsetIndex = DexFileReader.readULeb128i(bs);
        return offsetIndex - 1;
    }

    private static byte[] toByteArray(InputStream is) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buff = new byte[1024];
        int c = is.read(buff);
        while (c > 0) {
            out.write(buff, 0, c);
            c = is.read(buff);
        }
        return out.toByteArray();
    }

    private static ByteBuffer slice(ByteBuffer in, int offset, int length) {
        in.position(offset);
        ByteBuffer b = in.slice();
        b.limit(length);
        b.order(ByteOrder.LITTLE_ENDIAN);
        return b;
    }

    private static void skip(ByteBuffer in, int bytes) {
        in.position(in.position() + bytes);
    }

    public static void niceExceptionMessage(Throwable t, int deep) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < deep + 1; ++i) {
            sb.append(".");
        }
        sb.append(' ');
        if (t instanceof DexException) {
            sb.append(t.getMessage());
            System.err.println(sb.toString());
            if (t.getCause() != null) {
                DexFileReader.niceExceptionMessage(t.getCause(), deep + 1);
            }
        } else if (t != null) {
            System.err.println(sb.append("ROOT cause:").toString());
            t.printStackTrace(System.err);
        }
    }

    private static long readIntBits(ByteBuffer in, int before) {
        int length = (before >> 5 & 7) + 1;
        long value = 0L;
        for (int j = 0; j < length; ++j) {
            value |= (long)(0xFF & in.get()) << j * 8;
        }
        int shift = (8 - length) * 8;
        return value << shift >> shift;
    }

    private static long readUIntBits(ByteBuffer in, int before) {
        int length = (before >> 5 & 7) + 1;
        long value = 0L;
        for (int j = 0; j < length; ++j) {
            value |= (long)(0xFF & in.get()) << j * 8;
        }
        return value;
    }

    private static long readFloatBits(ByteBuffer in, int before) {
        int bytes = (before >> 5 & 7) + 1;
        long result = 0L;
        for (int i = 0; i < bytes; ++i) {
            result |= (long)(0xFF & in.get()) << i * 8;
        }
        return result <<= (8 - bytes) * 8;
    }

    static int sshort(byte[] data, int offset) {
        return data[offset + 1] << 8 | 0xFF & data[offset];
    }

    static int ushort(byte[] data, int offset) {
        return (0xFF & data[offset + 1]) << 8 | 0xFF & data[offset];
    }

    static int sint(byte[] data, int offset) {
        return data[offset + 3] << 24 | (0xFF & data[offset + 2]) << 16 | (0xFF & data[offset + 1]) << 8 | 0xFF & data[offset];
    }

    static int uint(byte[] data, int offset) {
        return DexFileReader.sint(data, offset);
    }

    static void WARN(String fmt, Object ... args) {
        System.err.println(String.format(fmt, args));
    }

    static int ubyte(byte[] insns, int offset) {
        return 0xFF & insns[offset];
    }

    static int sbyte(byte[] insns, int offset) {
        return insns[offset];
    }

    private static void order(Map<Integer, DexLabel> labelsMap, int offset) {
        if (!labelsMap.containsKey(offset)) {
            labelsMap.put(offset, new DexLabel(offset));
        }
    }

    public static int readULeb128i(ByteBuffer in) {
        int value = 0;
        int count = 0;
        byte b = in.get();
        while ((b & 0x80) != 0) {
            value |= (b & 0x7F) << count;
            count += 7;
            b = in.get();
        }
        return value |= (b & 0x7F) << count;
    }

    public static int readLeb128i(ByteBuffer in) {
        byte inp;
        int bitpos = 0;
        int vln = 0;
        do {
            inp = in.get();
            vln |= (inp & 0x7F) << bitpos;
            bitpos += 7;
        } while ((inp & 0x80) != 0);
        if ((1L << bitpos - 1 & (long)vln) != 0L) {
            vln = (int)((long)vln - (1L << bitpos));
        }
        return vln;
    }

    private static void DEBUG_DEBUG(String fmt, Object ... args) {
    }

    private void read_debug_info(int offset, int regSize, boolean isStatic, Method method, Map<Integer, DexLabel> labelMap, DexDebugVisitor dcv) {
        ByteBuffer in = this.debugInfoIn;
        in.position(offset);
        int address = 0;
        int line = DexFileReader.readULeb128i(in);
        int szParams = DexFileReader.readULeb128i(in);
        LocalEntry[] lastEntryForReg = new LocalEntry[regSize];
        int argsSize = 0;
        for (String paramType : method.getParameterTypes()) {
            if (paramType.equals("J") || paramType.equals("D")) {
                argsSize += 2;
                continue;
            }
            ++argsSize;
        }
        int curReg = regSize - argsSize;
        if (!isStatic) {
            LocalEntry thisEntry;
            lastEntryForReg[curReg - 1] = thisEntry = new LocalEntry("this", method.getOwner(), null);
            DexFileReader.DEBUG_DEBUG("v%d :%s, %s", curReg - 1, "this", method.getOwner());
        }
        String[] params = method.getParameterTypes();
        for (int i = 0; i < szParams; ++i) {
            LocalEntry le;
            String paramType;
            paramType = params[i];
            int nameIdx = DexFileReader.readStringIndex(in);
            String name = this.getString(nameIdx);
            lastEntryForReg[curReg] = le = new LocalEntry(name, paramType);
            if (name != null) {
                dcv.visitParameterName(i, name);
            }
            DexFileReader.DEBUG_DEBUG("v%d :%s, %s", curReg, name, paramType);
            ++curReg;
            if (!paramType.equals("J") && !paramType.equals("D")) continue;
            ++curReg;
        }
        block14: while (true) {
            int opcode = in.get() & 0xFF;
            switch (opcode) {
                case 3: {
                    LocalEntry le;
                    int reg = DexFileReader.readULeb128i(in);
                    int nameIdx = DexFileReader.readStringIndex(in);
                    int typeIdx = DexFileReader.readStringIndex(in);
                    String name = this.getString(nameIdx);
                    String type = this.getType(typeIdx);
                    DexFileReader.DEBUG_DEBUG("Start: v%d :%s, %s", reg, name, type);
                    lastEntryForReg[reg] = le = new LocalEntry(name, type);
                    DexFileReader.order(labelMap, address);
                    dcv.visitStartLocal(reg, labelMap.get(address), name, type, null);
                    continue block14;
                }
                case 4: {
                    int reg = DexFileReader.readULeb128i(in);
                    int nameIdx = DexFileReader.readStringIndex(in);
                    int typeIdx = DexFileReader.readStringIndex(in);
                    int sigIdx = DexFileReader.readStringIndex(in);
                    String name = this.getString(nameIdx);
                    String type = this.getType(typeIdx);
                    String signature = this.getString(sigIdx);
                    DexFileReader.DEBUG_DEBUG("Start: v%d :%s, %s // %s", reg, name, type, signature);
                    LocalEntry le = new LocalEntry(name, type, signature);
                    DexFileReader.order(labelMap, address);
                    dcv.visitStartLocal(reg, labelMap.get(address), name, type, signature);
                    lastEntryForReg[reg] = le;
                    continue block14;
                }
                case 6: {
                    int reg = DexFileReader.readULeb128i(in);
                    LocalEntry le = lastEntryForReg[reg];
                    if (le == null) {
                        throw new RuntimeException("Encountered RESTART_LOCAL on new v" + reg);
                    }
                    if (le.signature == null) {
                        DexFileReader.DEBUG_DEBUG("Start: v%d :%s, %s", reg, le.name, le.type);
                    } else {
                        DexFileReader.DEBUG_DEBUG("Start: v%d :%s, %s // %s", reg, le.name, le.type, le.signature);
                    }
                    DexFileReader.order(labelMap, address);
                    dcv.visitRestartLocal(reg, labelMap.get(address));
                    continue block14;
                }
                case 5: {
                    int reg = DexFileReader.readULeb128i(in);
                    LocalEntry le = lastEntryForReg[reg];
                    if (le == null) {
                        throw new RuntimeException("Encountered RESTART_LOCAL on new v" + reg);
                    }
                    if (le.signature == null) {
                        DexFileReader.DEBUG_DEBUG("End: v%d :%s, %s", reg, le.name, le.type);
                    } else {
                        DexFileReader.DEBUG_DEBUG("End: v%d :%s, %s // %s", reg, le.name, le.type, le.signature);
                    }
                    DexFileReader.order(labelMap, address);
                    dcv.visitEndLocal(reg, labelMap.get(address));
                    continue block14;
                }
                case 0: {
                    return;
                }
                case 1: {
                    address += DexFileReader.readULeb128i(in);
                    continue block14;
                }
                case 2: {
                    line += DexFileReader.readLeb128i(in);
                    continue block14;
                }
                case 7: {
                    DexFileReader.order(labelMap, address);
                    dcv.visitPrologue(labelMap.get(address));
                    continue block14;
                }
                case 8: {
                    DexFileReader.order(labelMap, address);
                    dcv.visitEpiogue(labelMap.get(address));
                    continue block14;
                }
                case 9: {
                    continue block14;
                }
            }
            if (opcode < 10) {
                throw new RuntimeException("Invalid extended opcode encountered " + opcode);
            }
            int adjopcode = opcode - 10;
            DexFileReader.order(labelMap, address += adjopcode / 15);
            dcv.visitLineNumber(line += -4 + adjopcode % 15, labelMap.get(address));
        }
    }

    @Override
    public int getDexVersion() {
        return this.dex_version;
    }

    @Override
    public void accept(DexFileVisitor dv) {
        this.accept(dv, 0);
    }

    @Override
    public List<String> getClassNames() {
        ArrayList<String> names = new ArrayList<String>(this.class_defs_size);
        ByteBuffer in = this.classDefIn;
        for (int cid = 0; cid < this.class_defs_size; ++cid) {
            in.position(cid * 32);
            String className = this.getType(in.getInt());
            names.add(className);
        }
        return names;
    }

    @Override
    public void accept(DexFileVisitor dv, int config) {
        dv.visitDexFileVersion(this.dex_version);
        for (int cid = 0; cid < this.class_defs_size; ++cid) {
            this.accept(dv, cid, config);
        }
        dv.visitEnd();
    }

    @Override
    public void accept(DexFileVisitor dv, int classIdx, int config) {
        this.classDefIn.position(classIdx * 32);
        int class_idx = this.classDefIn.getInt();
        int access_flags = this.classDefIn.getInt();
        int superclass_idx = this.classDefIn.getInt();
        int interfaces_off = this.classDefIn.getInt();
        int source_file_idx = this.classDefIn.getInt();
        int annotations_off = this.classDefIn.getInt();
        int class_data_off = this.classDefIn.getInt();
        int static_values_off = this.classDefIn.getInt();
        String className = this.getType(class_idx);
        if (this.ignoreClass(className).booleanValue()) {
            return;
        }
        String superClassName = this.getType(superclass_idx);
        String[] interfaceNames = this.getTypeList(interfaces_off);
        try {
            DexClassVisitor dcv = dv.visit(access_flags, className, superClassName, interfaceNames);
            if (dcv != null) {
                this.acceptClass(dcv, source_file_idx, annotations_off, class_data_off, static_values_off, config);
                dcv.visitEnd();
            }
        }
        catch (Exception ex) {
            DexException dexException = new DexException((Throwable)ex, "Error process class: [%d]%s", new Object[]{class_idx, className});
            if (0 != (config & 0x20)) {
                DexFileReader.niceExceptionMessage((Throwable)dexException, 0);
            }
            throw dexException;
        }
    }

    public Boolean ignoreClass(String className) {
        return false;
    }

    private Object readEncodedValue(ByteBuffer in) {
        int b = 0xFF & in.get();
        int type = b & 0x1F;
        switch (type) {
            case 0: {
                return new Byte((byte)DexFileReader.readIntBits(in, b));
            }
            case 2: {
                return new Short((short)DexFileReader.readIntBits(in, b));
            }
            case 3: {
                return new Character((char)DexFileReader.readUIntBits(in, b));
            }
            case 4: {
                return new Integer((int)DexFileReader.readIntBits(in, b));
            }
            case 6: {
                return new Long(DexFileReader.readIntBits(in, b));
            }
            case 16: {
                return Float.valueOf(Float.intBitsToFloat((int)(DexFileReader.readFloatBits(in, b) >> 32)));
            }
            case 17: {
                return Double.longBitsToDouble(DexFileReader.readFloatBits(in, b));
            }
            case 21: {
                return this.getProto((int)DexFileReader.readUIntBits(in, b));
            }
            case 22: {
                return this.getMethodHandle((int)DexFileReader.readUIntBits(in, b));
            }
            case 23: {
                return this.getString((int)DexFileReader.readUIntBits(in, b));
            }
            case 24: {
                int type_id = (int)DexFileReader.readUIntBits(in, b);
                return new DexType(this.getType(type_id));
            }
            case 25: {
                int field_id = (int)DexFileReader.readUIntBits(in, b);
                return this.getField(field_id);
            }
            case 26: {
                int method_id = (int)DexFileReader.readUIntBits(in, b);
                return this.getMethod(method_id);
            }
            case 27: {
                return this.getField((int)DexFileReader.readUIntBits(in, b));
            }
            case 28: {
                return this.read_encoded_array(in);
            }
            case 29: {
                return this.read_encoded_annotation(in);
            }
            case 30: {
                return null;
            }
            case 31: {
                return new Boolean((b >> 5 & 3) != 0);
            }
        }
        throw new DexException("Not support yet.");
    }

    private MethodHandle getMethodHandle(int i) {
        this.methodHandleIdIn.position(i * 8);
        int method_handle_type = this.methodHandleIdIn.getShort() & 0xFFFF;
        this.methodHandleIdIn.getShort();
        int field_or_method_id = this.methodHandleIdIn.getShort() & 0xFFFF;
        switch (method_handle_type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return new MethodHandle(method_handle_type, this.getField(field_or_method_id));
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return new MethodHandle(method_handle_type, this.getMethod(field_or_method_id));
            }
        }
        throw new RuntimeException();
    }

    private void acceptClass(DexClassVisitor dcv, int source_file_idx, int annotations_off, int class_data_off, int static_values_off, int config) {
        HashMap<Integer, Integer> paramAnnotationPositions;
        HashMap<Integer, Integer> methodAnnotationPositions;
        HashMap<Integer, Integer> fieldAnnotationPositions;
        if ((config & 1) == 0 && source_file_idx != -1) {
            dcv.visitSource(this.getString(source_file_idx));
        }
        if ((config & 8) == 0) {
            fieldAnnotationPositions = new HashMap<Integer, Integer>();
            methodAnnotationPositions = new HashMap<Integer, Integer>();
            paramAnnotationPositions = new HashMap<Integer, Integer>();
            if (annotations_off != 0) {
                int method_idx;
                int i;
                this.annotationsDirectoryItemIn.position(annotations_off);
                int class_annotations_off = this.annotationsDirectoryItemIn.getInt();
                int field_annotation_size = this.annotationsDirectoryItemIn.getInt();
                int method_annotation_size = this.annotationsDirectoryItemIn.getInt();
                int parameter_annotation_size = this.annotationsDirectoryItemIn.getInt();
                for (i = 0; i < field_annotation_size; ++i) {
                    int field_idx = this.annotationsDirectoryItemIn.getInt();
                    int field_annotations_offset = this.annotationsDirectoryItemIn.getInt();
                    fieldAnnotationPositions.put(field_idx, field_annotations_offset);
                }
                for (i = 0; i < method_annotation_size; ++i) {
                    method_idx = this.annotationsDirectoryItemIn.getInt();
                    int method_annotation_offset = this.annotationsDirectoryItemIn.getInt();
                    methodAnnotationPositions.put(method_idx, method_annotation_offset);
                }
                for (i = 0; i < parameter_annotation_size; ++i) {
                    method_idx = this.annotationsDirectoryItemIn.getInt();
                    int parameter_annotation_offset = this.annotationsDirectoryItemIn.getInt();
                    paramAnnotationPositions.put(method_idx, parameter_annotation_offset);
                }
                if (class_annotations_off != 0) {
                    try {
                        this.read_annotation_set_item(class_annotations_off, (DexAnnotationAble)dcv);
                    }
                    catch (Exception e) {
                        throw new DexException("error on reading Annotation of class ", (Throwable)e);
                    }
                }
            }
        } else {
            fieldAnnotationPositions = null;
            methodAnnotationPositions = null;
            paramAnnotationPositions = null;
        }
        if (class_data_off != 0) {
            int i;
            ByteBuffer in = this.classDataIn;
            in.position(class_data_off);
            int static_fields = DexFileReader.readULeb128i(in);
            int instance_fields = DexFileReader.readULeb128i(in);
            int direct_methods = DexFileReader.readULeb128i(in);
            int virtual_methods = DexFileReader.readULeb128i(in);
            int lastIndex = 0;
            Object[] constant = null;
            if ((config & 0x10) == 0 && static_values_off != 0) {
                constant = this.read_encoded_array_item(static_values_off);
            }
            for (i = 0; i < static_fields; ++i) {
                Object value = null;
                if (constant != null && i < constant.length) {
                    value = constant[i];
                }
                lastIndex = this.acceptField(in, lastIndex, dcv, fieldAnnotationPositions, value, config);
            }
            lastIndex = 0;
            for (int i2 = 0; i2 < instance_fields; ++i2) {
                lastIndex = this.acceptField(in, lastIndex, dcv, fieldAnnotationPositions, null, config);
            }
            lastIndex = 0;
            boolean firstMethod = true;
            for (i = 0; i < direct_methods; ++i) {
                lastIndex = this.acceptMethod(in, lastIndex, dcv, methodAnnotationPositions, paramAnnotationPositions, config, firstMethod);
                firstMethod = false;
            }
            lastIndex = 0;
            firstMethod = true;
            for (i = 0; i < virtual_methods; ++i) {
                lastIndex = this.acceptMethod(in, lastIndex, dcv, methodAnnotationPositions, paramAnnotationPositions, config, firstMethod);
                firstMethod = false;
            }
        }
    }

    private Object[] read_encoded_array_item(int static_values_off) {
        this.encodedArrayItemIn.position(static_values_off);
        return this.read_encoded_array(this.encodedArrayItemIn);
    }

    private Object[] read_encoded_array(ByteBuffer in) {
        int size = DexFileReader.readULeb128i(in);
        Object[] constant = new Object[size];
        for (int i = 0; i < size; ++i) {
            constant[i] = this.readEncodedValue(in);
        }
        return constant;
    }

    private void read_annotation_set_item(int offset, DexAnnotationAble daa) {
        ByteBuffer in = this.annotationSetItemIn;
        in.position(offset);
        int size = in.getInt();
        for (int j = 0; j < size; ++j) {
            int annotation_off = in.getInt();
            this.read_annotation_item(annotation_off, daa);
        }
    }

    private void read_annotation_item(int annotation_off, DexAnnotationAble daa) {
        ByteBuffer in = this.annotationItemIn;
        in.position(annotation_off);
        int visibility = 0xFF & in.get();
        DexAnnotationNode annotation = this.read_encoded_annotation(in);
        annotation.visibility = Visibility.values()[visibility];
        annotation.accept(daa);
    }

    private DexAnnotationNode read_encoded_annotation(ByteBuffer in) {
        int type_idx = DexFileReader.readULeb128i(in);
        int size = DexFileReader.readULeb128i(in);
        String _typeString = this.getType(type_idx);
        DexAnnotationNode ann = new DexAnnotationNode(_typeString, Visibility.RUNTIME);
        for (int i = 0; i < size; ++i) {
            int name_idx = DexFileReader.readULeb128i(in);
            String nameString = this.getString(name_idx);
            Object value = this.readEncodedValue(in);
            ann.items.add(new DexAnnotationNode.Item(nameString, value));
        }
        return ann;
    }

    private Field getField(int id) {
        this.fieldIdIn.position(id * 8);
        int owner_idx = 0xFFFF & this.fieldIdIn.getShort();
        int type_idx = 0xFFFF & this.fieldIdIn.getShort();
        int name_idx = this.fieldIdIn.getInt();
        return new Field(this.getType(owner_idx), this.getString(name_idx), this.getType(type_idx));
    }

    private String[] getTypeList(int offset) {
        if (offset == 0) {
            return new String[0];
        }
        this.typeListIn.position(offset);
        int size = this.typeListIn.getInt();
        String[] types = new String[size];
        for (int i = 0; i < size; ++i) {
            types[i] = this.getType(0xFFFF & this.typeListIn.getShort());
        }
        return types;
    }

    private Proto getProto(int proto_idx) {
        this.protoIdIn.position(proto_idx * 12 + 4);
        int return_type_idx = this.protoIdIn.getInt();
        int parameters_off = this.protoIdIn.getInt();
        String returnType = this.getType(return_type_idx);
        String[] parameterTypes = this.getTypeList(parameters_off);
        return new Proto(parameterTypes, returnType);
    }

    private Method getMethod(int id) {
        this.methoIdIn.position(id * 8);
        int owner_idx = 0xFFFF & this.methoIdIn.getShort();
        int proto_idx = 0xFFFF & this.methoIdIn.getShort();
        int name_idx = this.methoIdIn.getInt();
        return new Method(this.getType(owner_idx), this.getString(name_idx), this.getProto(proto_idx));
    }

    private String getString(int id) {
        if (id == -1) {
            return null;
        }
        int offset = this.stringIdIn.getInt(id * 4);
        this.stringDataIn.position(offset);
        int length = DexFileReader.readULeb128i(this.stringDataIn);
        try {
            StringBuilder buff = new StringBuilder((int)((double)length * 1.5));
            return Mutf8.decode(this.stringDataIn, buff);
        }
        catch (UTFDataFormatException e) {
            throw new DexException((Throwable)e, "fail to load string %d@%08x", new Object[]{id, offset});
        }
    }

    private String getType(int id) {
        if (id == -1) {
            return null;
        }
        return this.getString(this.typeIdIn.getInt(id * 4));
    }

    private int acceptField(ByteBuffer in, int lastIndex, DexClassVisitor dcv, Map<Integer, Integer> fieldAnnotationPositions, Object value, int config) {
        int field_id;
        Field field;
        int diff = DexFileReader.readULeb128i(in);
        int field_access_flags = DexFileReader.readULeb128i(in);
        DexFieldVisitor dfv = dcv.visitField(field_access_flags, field = this.getField(field_id = lastIndex + diff), value);
        if (dfv != null) {
            Integer annotation_offset;
            if ((config & 8) == 0 && (annotation_offset = fieldAnnotationPositions.get(field_id)) != null) {
                try {
                    this.read_annotation_set_item(annotation_offset, (DexAnnotationAble)dfv);
                }
                catch (Exception e) {
                    throw new DexException((Throwable)e, "while accept annotation in field:%s.", new Object[]{field.toString()});
                }
            }
            dfv.visitEnd();
        }
        return field_id;
    }

    private int acceptMethod(ByteBuffer in, int lastIndex, DexClassVisitor cv, Map<Integer, Integer> methodAnnos, Map<Integer, Integer> parameterAnnos, int config, boolean firstMethod) {
        int method_id;
        block17: {
            int offset = in.position();
            int diff = DexFileReader.readULeb128i(in);
            int method_access_flags = DexFileReader.readULeb128i(in);
            int code_off = DexFileReader.readULeb128i(in);
            method_id = lastIndex + diff;
            Method method = this.getMethod(method_id);
            if (!firstMethod && diff == 0) {
                DexFileReader.WARN("GLITCH: duplicated method %s @%08x", method.toString(), offset);
                if ((config & 0x40) == 0) {
                    DexFileReader.WARN("WARN: skip method %s @%08x", method.toString(), offset);
                    return method_id;
                }
            }
            if (0 == (method_access_flags & 0x10000) && (method.getName().equals("<init>") || method.getName().equals("<clinit>"))) {
                DexFileReader.WARN("GLITCH: method %s @%08x not marked as ACC_CONSTRUCTOR", method.toString(), offset);
            }
            try {
                DexMethodVisitor dmv = cv.visitMethod(method_access_flags, method);
                if (dmv == null) break block17;
                if ((config & 8) == 0) {
                    Integer parameter_annotation_offset;
                    Integer annotation_offset = methodAnnos.get(method_id);
                    if (annotation_offset != null) {
                        try {
                            this.read_annotation_set_item(annotation_offset, (DexAnnotationAble)dmv);
                        }
                        catch (Exception e) {
                            throw new DexException((Throwable)e, "while accept annotation in method:%s.", new Object[]{method.toString()});
                        }
                    }
                    if ((parameter_annotation_offset = parameterAnnos.get(method_id)) != null) {
                        try {
                            this.read_annotation_set_ref_list(parameter_annotation_offset, dmv);
                        }
                        catch (Exception e) {
                            throw new DexException((Throwable)e, "while accept parameter annotation in method:%s.", new Object[]{method.toString()});
                        }
                    }
                }
                if (code_off != 0) {
                    DexCodeVisitor dcv;
                    boolean keep = true;
                    if (0 != (4 & config)) {
                        boolean bl = keep = 0 != (0x80 & config) && method.getName().equals("<clinit>");
                    }
                    if (keep && (dcv = dmv.visitCode()) != null) {
                        try {
                            this.acceptCode(code_off, dcv, config, (method_access_flags & 8) != 0, method);
                        }
                        catch (Exception e) {
                            throw new DexException((Throwable)e, "while accept code in method:[%s] @%08x", new Object[]{method.toString(), code_off});
                        }
                    }
                }
                dmv.visitEnd();
            }
            catch (Exception e) {
                throw new DexException((Throwable)e, "while accept method:[%s]", new Object[]{method.toString()});
            }
        }
        return method_id;
    }

    private void read_annotation_set_ref_list(int parameter_annotation_offset, DexMethodVisitor dmv) {
        ByteBuffer in = this.annotationSetRefListIn;
        in.position(parameter_annotation_offset);
        int size = in.getInt();
        for (int j = 0; j < size; ++j) {
            int param_annotation_offset = in.getInt();
            if (param_annotation_offset == 0) continue;
            DexAnnotationAble dpav = dmv.visitParameterAnnotation(j);
            try {
                if (dpav == null) continue;
                this.read_annotation_set_item(param_annotation_offset, dpav);
                continue;
            }
            catch (Exception e) {
                throw new DexException((Throwable)e, "While accepting parameter annotation in parameter: [%d]", new Object[]{j});
            }
        }
    }

    public final int getClassSize() {
        return this.class_defs_size;
    }

    private void findLabels(byte[] insns, BitSet nextBit, BitSet badOps, Map<Integer, DexLabel> labelsMap, Set<Integer> handlers, Method method) {
        LinkedList<Integer> q = new LinkedList<Integer>();
        q.add(0);
        q.addAll(handlers);
        handlers.clear();
        while (!q.isEmpty()) {
            int offset = (Integer)q.poll();
            if (nextBit.get(offset)) continue;
            nextBit.set(offset);
            try {
                this.travelInsn(labelsMap, q, insns, offset);
            }
            catch (IndexOutOfBoundsException indexOutOfRange) {
                badOps.set(offset);
                DexFileReader.WARN("GLITCH: %04x %s | not enough space for reading instruction", offset, method.toString());
            }
            catch (BadOpException badOp) {
                badOps.set(offset);
                DexFileReader.WARN("GLITCH: %04x %s | %s", offset, method.toString(), badOp.getMessage());
            }
        }
    }

    private void travelInsn(Map<Integer, DexLabel> labelsMap, Queue<Integer> q, byte[] insns, int offset) {
        int size;
        boolean canContinue;
        Op op;
        int u1offset;
        block46: {
            block47: {
                int target;
                u1offset = offset * 2;
                if (u1offset >= insns.length) {
                    throw new IndexOutOfBoundsException();
                }
                int opcode = 0xFF & insns[u1offset];
                op = null;
                if (opcode < Op.ops.length) {
                    op = Op.ops[opcode];
                }
                if (op == null || op.format == null) {
                    throw new BadOpException("zero-width instruction op=0x%02x", opcode);
                }
                canContinue = true;
                if (op.canBranch()) {
                    switch (op.format) {
                        case kFmt10t: {
                            target = offset + insns[u1offset + 1];
                            if (target < 0 || target * 2 > insns.length) {
                                throw new BadOpException("jump out of insns %s -> %04x", op, target);
                            }
                            q.add(target);
                            DexFileReader.order(labelsMap, target);
                            break;
                        }
                        case kFmt20t: 
                        case kFmt21t: {
                            target = offset + DexFileReader.sshort(insns, u1offset + 2);
                            if (target < 0 || target * 2 > insns.length) {
                                throw new BadOpException("jump out of insns %s -> %04x", op, target);
                            }
                            q.add(target);
                            DexFileReader.order(labelsMap, target);
                            break;
                        }
                        case kFmt22t: {
                            target = offset + DexFileReader.sshort(insns, u1offset + 2);
                            int u = DexFileReader.ubyte(insns, u1offset + 1);
                            boolean cmpSameReg = (u & 0xF) == (u >> 4 & 0xF);
                            boolean skipTarget = false;
                            if (cmpSameReg) {
                                switch (op) {
                                    case IF_EQ: 
                                    case IF_GE: 
                                    case IF_LE: {
                                        canContinue = false;
                                        break;
                                    }
                                    case IF_NE: 
                                    case IF_GT: 
                                    case IF_LT: {
                                        skipTarget = true;
                                        break;
                                    }
                                }
                            }
                            if (skipTarget) break;
                            if (target < 0 || target * 2 > insns.length) {
                                throw new BadOpException("jump out of insns %s -> %04x", op, target);
                            }
                            q.add(target);
                            DexFileReader.order(labelsMap, target);
                            break;
                        }
                        case kFmt30t: 
                        case kFmt31t: {
                            target = offset + DexFileReader.sint(insns, u1offset + 2);
                            if (target < 0 || target * 2 > insns.length) {
                                throw new BadOpException("jump out of insns %s -> %04x", op, target);
                            }
                            q.add(target);
                            DexFileReader.order(labelsMap, target);
                            break;
                        }
                    }
                }
                if (!op.canSwitch()) break block46;
                DexFileReader.order(labelsMap, offset + op.format.size);
                int u1SwitchData = 2 * (offset + DexFileReader.sint(insns, u1offset + 2));
                if (u1SwitchData + 2 >= insns.length) break block47;
                switch (insns[u1SwitchData + 1]) {
                    case 1: {
                        size = DexFileReader.ushort(insns, u1SwitchData + 2);
                        int b = u1SwitchData + 8;
                        for (int i = 0; i < size; ++i) {
                            target = offset + DexFileReader.sint(insns, b + i * 4);
                            if (target < 0 || target * 2 > insns.length) {
                                throw new BadOpException("jump out of insns %s -> %04x", op, target);
                            }
                            q.add(target);
                            DexFileReader.order(labelsMap, target);
                        }
                        break block46;
                    }
                    case 2: {
                        size = DexFileReader.ushort(insns, u1SwitchData + 2);
                        int b = u1SwitchData + 4 + 4 * size;
                        for (int i = 0; i < size; ++i) {
                            target = offset + DexFileReader.sint(insns, b + i * 4);
                            if (target < 0 || target * 2 > insns.length) {
                                throw new BadOpException("jump out of insns %s -> %04x", op, target);
                            }
                            q.add(target);
                            DexFileReader.order(labelsMap, target);
                        }
                        break block46;
                    }
                    default: {
                        throw new BadOpException("bad payload for %s", op);
                    }
                }
            }
            throw new BadOpException("bad payload offset for %s", op);
        }
        if (canContinue) {
            int idx = Integer.MAX_VALUE;
            switch (op.indexType) {
                case kIndexStringRef: {
                    idx = op.format == InstructionFormat.kFmt31c ? DexFileReader.uint(insns, u1offset + 2) : DexFileReader.ushort(insns, u1offset + 2);
                    canContinue = idx >= 0 && idx < this.string_ids_size;
                    break;
                }
                case kIndexTypeRef: {
                    idx = DexFileReader.ushort(insns, u1offset + 2);
                    canContinue = idx < this.type_ids_size;
                    break;
                }
                case kIndexMethodRef: {
                    idx = DexFileReader.ushort(insns, u1offset + 2);
                    canContinue = idx < this.method_ids_size;
                    break;
                }
                case kIndexFieldRef: {
                    idx = DexFileReader.ushort(insns, u1offset + 2);
                    canContinue = idx < this.field_ids_size;
                    break;
                }
                case kIndexCallSiteRef: {
                    idx = DexFileReader.ushort(insns, u1offset + 2);
                    canContinue = idx < this.call_site_ids_size;
                    break;
                }
                case kIndexMethodAndProtoRef: {
                    idx = DexFileReader.ushort(insns, u1offset + 2);
                    int idx2 = DexFileReader.ushort(insns, u1offset + 6);
                    canContinue = idx < this.method_ids_size && idx2 < this.proto_ids_size;
                    break;
                }
            }
            if (!canContinue) {
                throw new BadOpException("index-out-of-range for %s index: %d", op, idx);
            }
        }
        if (canContinue && op.canContinue()) {
            if (op == Op.NOP) {
                switch (insns[u1offset + 1]) {
                    case 0: {
                        q.add(offset + op.format.size);
                        break;
                    }
                    case 1: {
                        int size2 = DexFileReader.ushort(insns, u1offset + 2);
                        q.add(offset + size2 * 2 + 4);
                        break;
                    }
                    case 2: {
                        int size2 = DexFileReader.ushort(insns, u1offset + 2);
                        q.add(offset + size2 * 4 + 2);
                        break;
                    }
                    case 3: {
                        int element_width = DexFileReader.ushort(insns, u1offset + 2);
                        size = DexFileReader.uint(insns, u1offset + 4);
                        q.add(offset + (size * element_width + 1) / 2 + 4);
                        break;
                    }
                }
            } else {
                q.add(offset + op.format.size);
            }
        }
    }

    private void findTryCatch(ByteBuffer in, DexCodeVisitor dcv, int tries_size, int insn_size, Map<Integer, DexLabel> labelsMap, Set<Integer> handlers) {
        int encoded_catch_handler_list = in.position() + tries_size * 8;
        ByteBuffer handlerIn = in.duplicate().order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < tries_size; ++i) {
            int listSize;
            int start_addr = in.getInt();
            int insn_count = 0xFFFF & in.getShort();
            int handler_offset = 0xFFFF & in.getShort();
            if (start_addr > insn_size) continue;
            DexFileReader.order(labelsMap, start_addr);
            int end = start_addr + insn_count;
            DexFileReader.order(labelsMap, end);
            handlerIn.position(encoded_catch_handler_list + handler_offset);
            boolean catchAll = false;
            int handlerCount = listSize = DexFileReader.readLeb128i(handlerIn);
            if (listSize <= 0) {
                listSize = -listSize;
                handlerCount = listSize + 1;
                catchAll = true;
            }
            DexLabel[] labels = new DexLabel[handlerCount];
            String[] types = new String[handlerCount];
            for (int k = 0; k < listSize; ++k) {
                int type_id = DexFileReader.readULeb128i(handlerIn);
                int handler = DexFileReader.readULeb128i(handlerIn);
                DexFileReader.order(labelsMap, handler);
                handlers.add(handler);
                types[k] = this.getType(type_id);
                labels[k] = labelsMap.get(handler);
            }
            if (catchAll) {
                int handler = DexFileReader.readULeb128i(handlerIn);
                DexFileReader.order(labelsMap, handler);
                handlers.add(handler);
                labels[listSize] = labelsMap.get(handler);
            }
            dcv.visitTryCatch(labelsMap.get(start_addr), labelsMap.get(end), labels, types);
        }
    }

    void acceptCode(int code_off, DexCodeVisitor dcv, int config, boolean isStatic, Method method) {
        DexDebugVisitor ddv;
        ByteBuffer in = this.codeItemIn;
        in.position(code_off);
        int registers_size = 0xFFFF & in.getShort();
        in.getShort();
        in.getShort();
        int tries_size = 0xFFFF & in.getShort();
        int debug_info_off = in.getInt();
        int insns = in.getInt();
        byte[] insnsArray = new byte[insns * 2];
        in.get(insnsArray);
        dcv.visitRegister(registers_size);
        BitSet nextInsn = new BitSet();
        TreeMap<Integer, DexLabel> labelsMap = new TreeMap<Integer, DexLabel>();
        HashSet<Integer> handlers = new HashSet<Integer>();
        if (tries_size > 0) {
            if ((insns & 1) != 0) {
                in.getShort();
            }
            if (0 == (config & 0x100)) {
                this.findTryCatch(in, dcv, tries_size, insns, labelsMap, handlers);
            }
        }
        if (debug_info_off != 0 && 0 == (config & 1) && (ddv = dcv.visitDebug()) != null) {
            this.read_debug_info(debug_info_off, registers_size, isStatic, method, labelsMap, ddv);
            ddv.visitEnd();
        }
        BitSet badOps = new BitSet();
        this.findLabels(insnsArray, nextInsn, badOps, labelsMap, handlers, method);
        this.acceptInsn(insnsArray, dcv, nextInsn, badOps, labelsMap);
        dcv.visitEnd();
    }

    private void acceptInsn(byte[] insns, DexCodeVisitor dcv, BitSet nextInsn, BitSet badOps, Map<Integer, DexLabel> labelsMap) {
        Iterator<Integer> labelOffsetIterator = labelsMap.keySet().iterator();
        Integer nextLabelOffset = labelOffsetIterator.hasNext() ? labelOffsetIterator.next() : null;
        Op[] values = Op.ops;
        int offset = nextInsn.nextSetBit(0);
        while (offset >= 0) {
            while (nextLabelOffset != null && nextLabelOffset <= offset) {
                dcv.visitLabel(labelsMap.get(nextLabelOffset));
                nextLabelOffset = labelOffsetIterator.hasNext() ? labelOffsetIterator.next() : null;
            }
            if (badOps.get(offset)) {
                dcv.visitStmt0R(Op.BAD_OP);
            } else {
                int u1offset = offset * 2;
                int opcode = 0xFF & insns[u1offset];
                Op op = values[opcode];
                block0 : switch (op.format) {
                    case kFmt10x: {
                        dcv.visitStmt0R(op);
                        break;
                    }
                    case kFmt11x: {
                        dcv.visitStmt1R(op, 0xFF & insns[u1offset + 1]);
                        break;
                    }
                    case kFmt12x: {
                        int a = DexFileReader.ubyte(insns, u1offset + 1);
                        dcv.visitStmt2R(op, a & 0xF, a >> 4);
                        break;
                    }
                    case kFmt10t: {
                        int target = offset + insns[u1offset + 1];
                        dcv.visitJumpStmt(op, -1, -1, labelsMap.get(target));
                        break;
                    }
                    case kFmt20t: {
                        int target = offset + DexFileReader.sshort(insns, u1offset + 2);
                        dcv.visitJumpStmt(op, -1, -1, labelsMap.get(target));
                        break;
                    }
                    case kFmt21t: {
                        int target = offset + DexFileReader.sshort(insns, u1offset + 2);
                        dcv.visitJumpStmt(op, DexFileReader.ubyte(insns, u1offset + 1), -1, labelsMap.get(target));
                        break;
                    }
                    case kFmt22t: {
                        int target = offset + DexFileReader.sshort(insns, u1offset + 2);
                        int a = DexFileReader.ubyte(insns, u1offset + 1);
                        int b = a & 0xF;
                        int c = a >> 4;
                        boolean ignore = false;
                        if (b == c) {
                            switch (op) {
                                case IF_EQ: 
                                case IF_GE: 
                                case IF_LE: {
                                    dcv.visitJumpStmt(Op.GOTO, 0, 0, labelsMap.get(target));
                                    ignore = true;
                                    break;
                                }
                                case IF_NE: 
                                case IF_GT: 
                                case IF_LT: {
                                    ignore = true;
                                    break;
                                }
                            }
                        }
                        if (ignore) break;
                        dcv.visitJumpStmt(op, b, c, labelsMap.get(target));
                        break;
                    }
                    case kFmt30t: {
                        int target = offset + DexFileReader.sint(insns, u1offset + 2);
                        dcv.visitJumpStmt(op, -1, -1, labelsMap.get(target));
                        break;
                    }
                    case kFmt31t: {
                        int target = offset + DexFileReader.sint(insns, u1offset + 2);
                        int a = DexFileReader.ubyte(insns, u1offset + 1);
                        int u1SwitchData = 2 * target;
                        if (op == Op.FILL_ARRAY_DATA) {
                            int element_width = DexFileReader.ushort(insns, u1SwitchData + 2);
                            int size = DexFileReader.uint(insns, u1SwitchData + 4);
                            switch (element_width) {
                                case 1: {
                                    byte[] data = new byte[size];
                                    System.arraycopy(insns, u1SwitchData + 8, data, 0, size);
                                    dcv.visitFillArrayDataStmt(op, a, (Object)data);
                                    break;
                                }
                                case 2: {
                                    short[] data = new short[size];
                                    for (int i = 0; i < size; ++i) {
                                        data[i] = (short)DexFileReader.sshort(insns, u1SwitchData + 8 + 2 * i);
                                    }
                                    dcv.visitFillArrayDataStmt(op, a, (Object)data);
                                    break;
                                }
                                case 4: {
                                    int[] data = new int[size];
                                    for (int i = 0; i < size; ++i) {
                                        data[i] = DexFileReader.sint(insns, u1SwitchData + 8 + 4 * i);
                                    }
                                    dcv.visitFillArrayDataStmt(op, a, (Object)data);
                                    break;
                                }
                                case 8: {
                                    long[] data = new long[size];
                                    for (int i = 0; i < size; ++i) {
                                        int t = u1SwitchData + 8 + 8 * i;
                                        long z = 0L;
                                        z |= (long)DexFileReader.ushort(insns, t + 0) << 0;
                                        z |= (long)DexFileReader.ushort(insns, t + 2) << 16;
                                        z |= (long)DexFileReader.ushort(insns, t + 4) << 32;
                                        data[i] = z |= (long)DexFileReader.ushort(insns, t + 6) << 48;
                                    }
                                    dcv.visitFillArrayDataStmt(op, a, (Object)data);
                                }
                            }
                            break;
                        }
                        if (op == Op.SPARSE_SWITCH) {
                            int i;
                            int size = DexFileReader.sshort(insns, u1SwitchData + 2);
                            int[] keys = new int[size];
                            DexLabel[] labels = new DexLabel[size];
                            int z = u1SwitchData + 4;
                            for (i = 0; i < size; ++i) {
                                keys[i] = DexFileReader.sint(insns, z + i * 4);
                            }
                            z += size * 4;
                            for (i = 0; i < size; ++i) {
                                labels[i] = labelsMap.get(offset + DexFileReader.sint(insns, z + i * 4));
                            }
                            dcv.visitSparseSwitchStmt(op, a, keys, labels);
                            break;
                        }
                        int size = DexFileReader.sshort(insns, u1SwitchData + 2);
                        int first_key = DexFileReader.sint(insns, u1SwitchData + 4);
                        DexLabel[] labels = new DexLabel[size];
                        int z = u1SwitchData + 8;
                        for (int i = 0; i < size; ++i) {
                            labels[i] = labelsMap.get(offset + DexFileReader.sint(insns, z));
                            z += 4;
                        }
                        dcv.visitPackedSwitchStmt(op, a, first_key, labels);
                        break;
                    }
                    case kFmt21c: {
                        int a = DexFileReader.ubyte(insns, u1offset + 1);
                        int b = DexFileReader.ushort(insns, u1offset + 2);
                        switch (op.indexType) {
                            case kIndexStringRef: {
                                dcv.visitConstStmt(op, a, (Object)this.getString(b));
                                break block0;
                            }
                            case kIndexFieldRef: {
                                dcv.visitFieldStmt(op, a, -1, this.getField(b));
                                break block0;
                            }
                            case kIndexTypeRef: {
                                if (op == Op.CONST_CLASS) {
                                    dcv.visitConstStmt(op, a, (Object)new DexType(this.getType(b)));
                                    break block0;
                                }
                                dcv.visitTypeStmt(op, a, -1, this.getType(b));
                                break block0;
                            }
                        }
                        break;
                    }
                    case kFmt22c: {
                        int a = DexFileReader.ubyte(insns, u1offset + 1);
                        int b = DexFileReader.ushort(insns, u1offset + 2);
                        switch (op.indexType) {
                            case kIndexFieldRef: {
                                dcv.visitFieldStmt(op, a & 0xF, a >> 4, this.getField(b));
                                break block0;
                            }
                            case kIndexTypeRef: {
                                dcv.visitTypeStmt(op, a & 0xF, a >> 4, this.getType(b));
                                break block0;
                            }
                        }
                        break;
                    }
                    case kFmt31c: {
                        if (op.indexType != InstructionIndexType.kIndexStringRef) break;
                        int a = DexFileReader.ubyte(insns, u1offset + 1);
                        int b = DexFileReader.uint(insns, u1offset + 2);
                        dcv.visitConstStmt(op, a, (Object)this.getString(b));
                        break;
                    }
                    case kFmt35c: {
                        int a = DexFileReader.ubyte(insns, u1offset + 1);
                        int b = DexFileReader.ushort(insns, u1offset + 2);
                        int dc = DexFileReader.ubyte(insns, u1offset + 4);
                        int fe = DexFileReader.ubyte(insns, u1offset + 5);
                        int[] regs = new int[a >> 4];
                        switch (a >> 4) {
                            case 5: {
                                regs[4] = a & 0xF;
                            }
                            case 4: {
                                regs[3] = 0xF & fe >> 4;
                            }
                            case 3: {
                                regs[2] = 0xF & fe >> 0;
                            }
                            case 2: {
                                regs[1] = 0xF & dc >> 4;
                            }
                            case 1: {
                                regs[0] = 0xF & dc >> 0;
                            }
                        }
                        if (op.indexType == InstructionIndexType.kIndexTypeRef) {
                            dcv.visitFilledNewArrayStmt(op, regs, this.getType(b));
                            break;
                        }
                        if (op.indexType == InstructionIndexType.kIndexCallSiteRef) {
                            Object[] callsite = this.getCallSite(b);
                            Object[] constArgs = Arrays.copyOfRange(callsite, 3, callsite.length);
                            dcv.visitMethodStmt(op, regs, (String)callsite[1], (Proto)callsite[2], (MethodHandle)callsite[0], constArgs);
                            break;
                        }
                        dcv.visitMethodStmt(op, regs, this.getMethod(b));
                        break;
                    }
                    case kFmt3rc: {
                        int a = DexFileReader.ubyte(insns, u1offset + 1);
                        int b = DexFileReader.ushort(insns, u1offset + 2);
                        int c = DexFileReader.ushort(insns, u1offset + 4);
                        int[] regs = new int[a];
                        for (int i = 0; i < a; ++i) {
                            regs[i] = c + i;
                        }
                        if (op.indexType == InstructionIndexType.kIndexTypeRef) {
                            dcv.visitFilledNewArrayStmt(op, regs, this.getType(b));
                            break;
                        }
                        if (op.indexType == InstructionIndexType.kIndexCallSiteRef) {
                            Object[] callsite = this.getCallSite(b);
                            Object[] constArgs = Arrays.copyOfRange(callsite, 3, callsite.length - 3);
                            dcv.visitMethodStmt(op, regs, (String)callsite[1], (Proto)callsite[2], (MethodHandle)callsite[0], constArgs);
                            break;
                        }
                        dcv.visitMethodStmt(op, regs, this.getMethod(b));
                        break;
                    }
                    case kFmt45cc: {
                        int a = DexFileReader.ubyte(insns, u1offset + 1);
                        int b = DexFileReader.ushort(insns, u1offset + 2);
                        int dc = DexFileReader.ubyte(insns, u1offset + 4);
                        int fe = DexFileReader.ubyte(insns, u1offset + 5);
                        int h = DexFileReader.ushort(insns, u1offset + 6);
                        int[] regs = new int[a >> 4];
                        switch (a >> 4) {
                            case 5: {
                                regs[4] = a & 0xF;
                            }
                            case 4: {
                                regs[3] = 0xF & fe >> 4;
                            }
                            case 3: {
                                regs[2] = 0xF & fe >> 0;
                            }
                            case 2: {
                                regs[1] = 0xF & dc >> 4;
                            }
                            case 1: {
                                regs[0] = 0xF & dc >> 0;
                            }
                        }
                        dcv.visitMethodStmt(op, regs, this.getMethod(b), this.getProto(h));
                        break;
                    }
                    case kFmt4rcc: {
                        int a = DexFileReader.ubyte(insns, u1offset + 1);
                        int b = DexFileReader.ushort(insns, u1offset + 2);
                        int c = DexFileReader.ushort(insns, u1offset + 4);
                        int h = DexFileReader.ushort(insns, u1offset + 6);
                        int[] regs = new int[a];
                        for (int i = 0; i < a; ++i) {
                            regs[i] = c + i;
                        }
                        dcv.visitMethodStmt(op, regs, this.getMethod(b), this.getProto(h));
                        break;
                    }
                    case kFmt22x: {
                        int a = DexFileReader.ubyte(insns, u1offset + 1);
                        int b = DexFileReader.ushort(insns, u1offset + 2);
                        dcv.visitStmt2R(op, a, b);
                        break;
                    }
                    case kFmt23x: {
                        int a = DexFileReader.ubyte(insns, u1offset + 1);
                        int b = DexFileReader.ubyte(insns, u1offset + 2);
                        int c = DexFileReader.ubyte(insns, u1offset + 3);
                        dcv.visitStmt3R(op, a, b, c);
                        break;
                    }
                    case kFmt32x: {
                        int a = DexFileReader.ushort(insns, u1offset + 2);
                        int b = DexFileReader.ushort(insns, u1offset + 4);
                        dcv.visitStmt2R(op, a, b);
                        break;
                    }
                    case kFmt11n: {
                        int a = insns[u1offset + 1];
                        dcv.visitConstStmt(op, a & 0xF, (Object)(a >> 4));
                        break;
                    }
                    case kFmt21h: {
                        int a = DexFileReader.ubyte(insns, u1offset + 1);
                        int b = DexFileReader.sshort(insns, u1offset + 2);
                        if (op == Op.CONST_HIGH16) {
                            dcv.visitConstStmt(op, a, (Object)(b << 16));
                            break;
                        }
                        dcv.visitConstStmt(op, a, (Object)((long)b << 48));
                        break;
                    }
                    case kFmt21s: {
                        int a = DexFileReader.ubyte(insns, u1offset + 1);
                        int b = DexFileReader.sshort(insns, u1offset + 2);
                        if (op == Op.CONST_16) {
                            dcv.visitConstStmt(op, a, (Object)b);
                            break;
                        }
                        dcv.visitConstStmt(op, a, (Object)b);
                        break;
                    }
                    case kFmt22b: {
                        int a = DexFileReader.ubyte(insns, u1offset + 1);
                        int b = DexFileReader.ubyte(insns, u1offset + 2);
                        int c = DexFileReader.sbyte(insns, u1offset + 3);
                        dcv.visitStmt2R1N(op, a, b, c);
                        break;
                    }
                    case kFmt22s: {
                        int a = DexFileReader.ubyte(insns, u1offset + 1);
                        int b = DexFileReader.sshort(insns, u1offset + 2);
                        dcv.visitStmt2R1N(op, a & 0xF, a >> 4, b);
                        break;
                    }
                    case kFmt31i: {
                        int a = DexFileReader.ubyte(insns, u1offset + 1);
                        int b = DexFileReader.sint(insns, u1offset + 2);
                        if (op == Op.CONST) {
                            dcv.visitConstStmt(op, a, (Object)b);
                            break;
                        }
                        dcv.visitConstStmt(op, a, (Object)b);
                        break;
                    }
                    case kFmt51l: {
                        int a = DexFileReader.ubyte(insns, u1offset + 1);
                        long z = 0L;
                        z |= (long)DexFileReader.ushort(insns, u1offset + 2) << 0;
                        z |= (long)DexFileReader.ushort(insns, u1offset + 4) << 16;
                        z |= (long)DexFileReader.ushort(insns, u1offset + 6) << 32;
                        dcv.visitConstStmt(op, a, (Object)(z |= (long)DexFileReader.ushort(insns, u1offset + 8) << 48));
                    }
                }
            }
            offset = nextInsn.nextSetBit(offset + 1);
        }
        while (nextLabelOffset != null) {
            dcv.visitLabel(labelsMap.get(nextLabelOffset));
            if (!labelOffsetIterator.hasNext()) break;
            nextLabelOffset = labelOffsetIterator.next();
        }
    }

    private Object[] getCallSite(int b) {
        this.callSiteIdIn.position(b * 4);
        int call_site_off = this.callSiteIdIn.getInt();
        return this.read_encoded_array_item(call_site_off);
    }

    private static class LocalEntry {
        public String name;
        public String type;
        public String signature;

        private LocalEntry(String name, String type) {
            this.name = name;
            this.type = type;
        }

        private LocalEntry(String name, String type, String signature) {
            this.name = name;
            this.type = type;
            this.signature = signature;
        }
    }

    static class BadOpException
    extends RuntimeException {
        public BadOpException(String fmt, Object ... args) {
            super(String.format(fmt, args));
        }
    }
}

