/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v465.serializer;

import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.BedrockPacketHelper;
import com.nukkitx.protocol.bedrock.BedrockPacketSerializer;
import com.nukkitx.protocol.bedrock.data.BlockChangeEntry;
import com.nukkitx.protocol.bedrock.packet.UpdateSubChunkBlocksPacket;
import io.netty.buffer.ByteBuf;
import java.util.Collection;

public class UpdateSubChunkBlocksSerializer_v465
implements BedrockPacketSerializer<UpdateSubChunkBlocksPacket> {
    public static final UpdateSubChunkBlocksSerializer_v465 INSTANCE = new UpdateSubChunkBlocksSerializer_v465();
    private static final BlockChangeEntry.MessageType[] VALUES = BlockChangeEntry.MessageType.values();

    public void serialize(ByteBuf buffer, BedrockPacketHelper helper, UpdateSubChunkBlocksPacket packet) {
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getChunkX());
        VarInts.writeUnsignedInt((ByteBuf)buffer, (int)packet.getChunkY());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getChunkZ());
        helper.writeArray(buffer, (Collection)packet.getStandardBlocks(), this::writeBlockChangeEntry);
        helper.writeArray(buffer, (Collection)packet.getExtraBlocks(), this::writeBlockChangeEntry);
    }

    public void deserialize(ByteBuf buffer, BedrockPacketHelper helper, UpdateSubChunkBlocksPacket packet) {
        packet.setChunkX(VarInts.readInt((ByteBuf)buffer));
        packet.setChunkY(VarInts.readUnsignedInt((ByteBuf)buffer));
        packet.setChunkZ(VarInts.readInt((ByteBuf)buffer));
        helper.readArray(buffer, (Collection)packet.getStandardBlocks(), this::readBlockChangeEntry);
        helper.readArray(buffer, (Collection)packet.getExtraBlocks(), this::readBlockChangeEntry);
    }

    protected void writeBlockChangeEntry(ByteBuf buffer, BedrockPacketHelper helper, BlockChangeEntry entry) {
        helper.writeBlockPosition(buffer, entry.getPosition());
        VarInts.writeUnsignedInt((ByteBuf)buffer, (int)entry.getRuntimeId());
        VarInts.writeUnsignedInt((ByteBuf)buffer, (int)entry.getUpdateFlags());
        VarInts.writeUnsignedLong((ByteBuf)buffer, (long)entry.getMessageEntityId());
        VarInts.writeUnsignedInt((ByteBuf)buffer, (int)entry.getMessageType().ordinal());
    }

    protected BlockChangeEntry readBlockChangeEntry(ByteBuf buffer, BedrockPacketHelper helper) {
        return new BlockChangeEntry(helper.readBlockPosition(buffer), VarInts.readUnsignedInt((ByteBuf)buffer), VarInts.readUnsignedInt((ByteBuf)buffer), VarInts.readUnsignedLong((ByteBuf)buffer), VALUES[VarInts.readUnsignedInt((ByteBuf)buffer)]);
    }

    protected UpdateSubChunkBlocksSerializer_v465() {
    }
}

