/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v465.serializer;

import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.BedrockPacketHelper;
import com.nukkitx.protocol.bedrock.BedrockSession;
import com.nukkitx.protocol.bedrock.data.inventory.CraftingData;
import com.nukkitx.protocol.bedrock.data.inventory.CraftingDataType;
import com.nukkitx.protocol.bedrock.data.inventory.MaterialReducer;
import com.nukkitx.protocol.bedrock.packet.CraftingDataPacket;
import com.nukkitx.protocol.bedrock.v407.serializer.CraftingDataSerializer_v407;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.Collection;

public class CraftingDataSerializer_v465
extends CraftingDataSerializer_v407 {
    public static final CraftingDataSerializer_v465 INSTANCE = new CraftingDataSerializer_v465();

    public void serialize(ByteBuf buffer, BedrockPacketHelper helper, CraftingDataPacket packet, BedrockSession session) {
        helper.writeArray(buffer, (Collection)packet.getCraftingData(), (buf, craftingData) -> {
            VarInts.writeInt((ByteBuf)buf, (int)craftingData.getType().ordinal());
            switch (craftingData.getType()) {
                case SHAPELESS: 
                case SHAPELESS_CHEMISTRY: 
                case SHULKER_BOX: {
                    this.writeShapelessRecipe((ByteBuf)buf, helper, (CraftingData)craftingData, session);
                    break;
                }
                case SHAPED: 
                case SHAPED_CHEMISTRY: {
                    this.writeShapedRecipe((ByteBuf)buf, helper, (CraftingData)craftingData, session);
                    break;
                }
                case FURNACE: {
                    this.writeFurnaceRecipe((ByteBuf)buf, helper, (CraftingData)craftingData, session);
                    break;
                }
                case FURNACE_DATA: {
                    this.writeFurnaceDataRecipe((ByteBuf)buf, helper, (CraftingData)craftingData, session);
                    break;
                }
                case MULTI: {
                    this.writeMultiRecipe((ByteBuf)buf, helper, (CraftingData)craftingData);
                }
            }
        });
        helper.writeArray(buffer, (Collection)packet.getPotionMixData(), (arg_0, arg_1) -> ((BedrockPacketHelper)helper).writePotionRecipe(arg_0, arg_1));
        helper.writeArray(buffer, (Collection)packet.getContainerMixData(), (arg_0, arg_1) -> ((BedrockPacketHelper)helper).writeContainerChangeRecipe(arg_0, arg_1));
        helper.writeArray(buffer, (Collection)packet.getMaterialReducers(), this::writeMaterialReducer);
        buffer.writeBoolean(packet.isCleanRecipes());
    }

    public void deserialize(ByteBuf buffer, BedrockPacketHelper helper, CraftingDataPacket packet, BedrockSession session) {
        helper.readArray(buffer, (Collection)packet.getCraftingData(), buf -> {
            int typeInt = VarInts.readInt((ByteBuf)buf);
            CraftingDataType type = CraftingDataType.byId((int)typeInt);
            switch (type) {
                case SHAPELESS: 
                case SHAPELESS_CHEMISTRY: 
                case SHULKER_BOX: {
                    return this.readShapelessRecipe((ByteBuf)buf, helper, type, session);
                }
                case SHAPED: 
                case SHAPED_CHEMISTRY: {
                    return this.readShapedRecipe((ByteBuf)buf, helper, type, session);
                }
                case FURNACE: {
                    return this.readFurnaceRecipe((ByteBuf)buf, helper, type, session);
                }
                case FURNACE_DATA: {
                    return this.readFurnaceDataRecipe((ByteBuf)buf, helper, type, session);
                }
                case MULTI: {
                    return this.readMultiRecipe((ByteBuf)buf, helper, type);
                }
            }
            throw new IllegalArgumentException("Unhandled crafting data type: " + type);
        });
        helper.readArray(buffer, (Collection)packet.getPotionMixData(), arg_0 -> ((BedrockPacketHelper)helper).readPotionRecipe(arg_0));
        helper.readArray(buffer, (Collection)packet.getContainerMixData(), arg_0 -> ((BedrockPacketHelper)helper).readContainerChangeRecipe(arg_0));
        helper.readArray(buffer, (Collection)packet.getMaterialReducers(), this::readMaterialReducer);
        packet.setCleanRecipes(buffer.readBoolean());
    }

    protected void writeMaterialReducer(ByteBuf buffer, BedrockPacketHelper helper, MaterialReducer reducer) {
        VarInts.writeInt((ByteBuf)buffer, (int)reducer.getInputId());
        helper.writeArray(buffer, (Collection)reducer.getItemCounts().int2IntEntrySet(), (buf, entry) -> {
            VarInts.writeInt((ByteBuf)buffer, (int)entry.getIntKey());
            VarInts.writeInt((ByteBuf)buffer, (int)entry.getIntValue());
        });
    }

    protected MaterialReducer readMaterialReducer(ByteBuf buffer, BedrockPacketHelper helper) {
        int inputId = VarInts.readInt((ByteBuf)buffer);
        Int2IntOpenHashMap itemCounts = new Int2IntOpenHashMap();
        int length = VarInts.readUnsignedInt((ByteBuf)buffer);
        for (int i = 0; i < length; ++i) {
            itemCounts.put(VarInts.readInt((ByteBuf)buffer), VarInts.readInt((ByteBuf)buffer));
        }
        return new MaterialReducer(inputId, (Int2IntMap)itemCounts);
    }

    protected CraftingDataSerializer_v465() {
    }
}

