/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v407.serializer;

import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.BedrockPacketHelper;
import com.nukkitx.protocol.bedrock.data.GamePublishSetting;
import com.nukkitx.protocol.bedrock.data.GameType;
import com.nukkitx.protocol.bedrock.data.PlayerPermission;
import com.nukkitx.protocol.bedrock.data.SpawnBiomeType;
import com.nukkitx.protocol.bedrock.packet.StartGamePacket;
import com.nukkitx.protocol.bedrock.v388.serializer.StartGameSerializer_v388;
import io.netty.buffer.ByteBuf;
import java.util.Collection;

public class StartGameSerializer_v407
extends StartGameSerializer_v388 {
    public static final StartGameSerializer_v407 INSTANCE = new StartGameSerializer_v407();
    private static final PlayerPermission[] PLAYER_PERMISSIONS = PlayerPermission.values();

    public void serialize(ByteBuf buffer, BedrockPacketHelper helper, StartGamePacket packet) {
        super.serialize(buffer, helper, packet);
        buffer.writeBoolean(packet.isInventoriesServerAuthoritative());
    }

    public void deserialize(ByteBuf buffer, BedrockPacketHelper helper, StartGamePacket packet) {
        super.deserialize(buffer, helper, packet);
        packet.setInventoriesServerAuthoritative(buffer.readBoolean());
    }

    protected void writeLevelSettings(ByteBuf buffer, BedrockPacketHelper helper, StartGamePacket packet) {
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getSeed());
        buffer.writeShortLE(packet.getSpawnBiomeType().ordinal());
        helper.writeString(buffer, packet.getCustomBiomeName());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getDimensionId());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getGeneratorId());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getLevelGameType().ordinal());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getDifficulty());
        helper.writeBlockPosition(buffer, packet.getDefaultSpawn());
        buffer.writeBoolean(packet.isAchievementsDisabled());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getDayCycleStopTime());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getEduEditionOffers());
        buffer.writeBoolean(packet.isEduFeaturesEnabled());
        helper.writeString(buffer, packet.getEducationProductionId());
        buffer.writeFloatLE(packet.getRainLevel());
        buffer.writeFloatLE(packet.getLightningLevel());
        buffer.writeBoolean(packet.isPlatformLockedContentConfirmed());
        buffer.writeBoolean(packet.isMultiplayerGame());
        buffer.writeBoolean(packet.isBroadcastingToLan());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getXblBroadcastMode().ordinal());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getPlatformBroadcastMode().ordinal());
        buffer.writeBoolean(packet.isCommandsEnabled());
        buffer.writeBoolean(packet.isTexturePacksRequired());
        helper.writeArray(buffer, (Collection)packet.getGamerules(), (arg_0, arg_1) -> ((BedrockPacketHelper)helper).writeGameRule(arg_0, arg_1));
        buffer.writeBoolean(packet.isBonusChestEnabled());
        buffer.writeBoolean(packet.isStartingWithMap());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getDefaultPlayerPermission().ordinal());
        buffer.writeIntLE(packet.getServerChunkTickRange());
        buffer.writeBoolean(packet.isBehaviorPackLocked());
        buffer.writeBoolean(packet.isResourcePackLocked());
        buffer.writeBoolean(packet.isFromLockedWorldTemplate());
        buffer.writeBoolean(packet.isUsingMsaGamertagsOnly());
        buffer.writeBoolean(packet.isFromWorldTemplate());
        buffer.writeBoolean(packet.isWorldTemplateOptionLocked());
        buffer.writeBoolean(packet.isOnlySpawningV1Villagers());
        helper.writeString(buffer, packet.getVanillaVersion());
        buffer.writeIntLE(packet.getLimitedWorldWidth());
        buffer.writeIntLE(packet.getLimitedWorldHeight());
        buffer.writeBoolean(packet.isNetherType());
        buffer.writeBoolean(packet.isForceExperimentalGameplay());
    }

    protected void readLevelSettings(ByteBuf buffer, BedrockPacketHelper helper, StartGamePacket packet) {
        packet.setSeed(VarInts.readInt((ByteBuf)buffer));
        packet.setSpawnBiomeType(SpawnBiomeType.byId((int)buffer.readShortLE()));
        packet.setCustomBiomeName(helper.readString(buffer));
        packet.setDimensionId(VarInts.readInt((ByteBuf)buffer));
        packet.setGeneratorId(VarInts.readInt((ByteBuf)buffer));
        packet.setLevelGameType(GameType.from((int)VarInts.readInt((ByteBuf)buffer)));
        packet.setDifficulty(VarInts.readInt((ByteBuf)buffer));
        packet.setDefaultSpawn(helper.readBlockPosition(buffer));
        packet.setAchievementsDisabled(buffer.readBoolean());
        packet.setDayCycleStopTime(VarInts.readInt((ByteBuf)buffer));
        packet.setEduEditionOffers(VarInts.readInt((ByteBuf)buffer));
        packet.setEduFeaturesEnabled(buffer.readBoolean());
        packet.setEducationProductionId(helper.readString(buffer));
        packet.setRainLevel(buffer.readFloatLE());
        packet.setLightningLevel(buffer.readFloatLE());
        packet.setPlatformLockedContentConfirmed(buffer.readBoolean());
        packet.setMultiplayerGame(buffer.readBoolean());
        packet.setBroadcastingToLan(buffer.readBoolean());
        packet.setXblBroadcastMode(GamePublishSetting.byId((int)VarInts.readInt((ByteBuf)buffer)));
        packet.setPlatformBroadcastMode(GamePublishSetting.byId((int)VarInts.readInt((ByteBuf)buffer)));
        packet.setCommandsEnabled(buffer.readBoolean());
        packet.setTexturePacksRequired(buffer.readBoolean());
        helper.readArray(buffer, (Collection)packet.getGamerules(), arg_0 -> ((BedrockPacketHelper)helper).readGameRule(arg_0));
        packet.setBonusChestEnabled(buffer.readBoolean());
        packet.setStartingWithMap(buffer.readBoolean());
        packet.setDefaultPlayerPermission(PLAYER_PERMISSIONS[VarInts.readInt((ByteBuf)buffer)]);
        packet.setServerChunkTickRange(buffer.readIntLE());
        packet.setBehaviorPackLocked(buffer.readBoolean());
        packet.setResourcePackLocked(buffer.readBoolean());
        packet.setFromLockedWorldTemplate(buffer.readBoolean());
        packet.setUsingMsaGamertagsOnly(buffer.readBoolean());
        packet.setFromWorldTemplate(buffer.readBoolean());
        packet.setWorldTemplateOptionLocked(buffer.readBoolean());
        packet.setOnlySpawningV1Villagers(buffer.readBoolean());
        packet.setVanillaVersion(helper.readString(buffer));
        packet.setLimitedWorldWidth(buffer.readIntLE());
        packet.setLimitedWorldHeight(buffer.readIntLE());
        packet.setNetherType(buffer.readBoolean());
        packet.setForceExperimentalGameplay(buffer.readBoolean());
    }

    protected StartGameSerializer_v407() {
    }
}

