/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v361.serializer;

import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.BedrockPacketHelper;
import com.nukkitx.protocol.bedrock.BedrockPacketSerializer;
import com.nukkitx.protocol.bedrock.packet.LevelChunkPacket;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongListIterator;

public class LevelChunkSerializer_v361
implements BedrockPacketSerializer<LevelChunkPacket> {
    public static final LevelChunkSerializer_v361 INSTANCE = new LevelChunkSerializer_v361();

    public void serialize(ByteBuf buffer, BedrockPacketHelper helper, LevelChunkPacket packet) {
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getChunkX());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getChunkZ());
        VarInts.writeUnsignedInt((ByteBuf)buffer, (int)packet.getSubChunksLength());
        buffer.writeBoolean(packet.isCachingEnabled());
        if (packet.isCachingEnabled()) {
            LongList blobIds = packet.getBlobIds();
            VarInts.writeUnsignedInt((ByteBuf)buffer, (int)blobIds.size());
            LongListIterator longListIterator = blobIds.iterator();
            while (longListIterator.hasNext()) {
                long blobId = (Long)longListIterator.next();
                buffer.writeLongLE(blobId);
            }
        }
        helper.writeByteArray(buffer, packet.getData());
    }

    public void deserialize(ByteBuf buffer, BedrockPacketHelper helper, LevelChunkPacket packet) {
        packet.setChunkX(VarInts.readInt((ByteBuf)buffer));
        packet.setChunkZ(VarInts.readInt((ByteBuf)buffer));
        packet.setSubChunksLength(VarInts.readUnsignedInt((ByteBuf)buffer));
        packet.setCachingEnabled(buffer.readBoolean());
        if (packet.isCachingEnabled()) {
            LongList blobIds = packet.getBlobIds();
            int length = VarInts.readUnsignedInt((ByteBuf)buffer);
            for (int i = 0; i < length; ++i) {
                blobIds.add(buffer.readLongLE());
            }
        }
        packet.setData(helper.readByteArray(buffer));
    }

    protected LevelChunkSerializer_v361() {
    }
}

