/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v361.serializer;

import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.BedrockPacketHelper;
import com.nukkitx.protocol.bedrock.BedrockSession;
import com.nukkitx.protocol.bedrock.data.inventory.CraftingData;
import com.nukkitx.protocol.bedrock.data.inventory.CraftingDataType;
import com.nukkitx.protocol.bedrock.data.inventory.ItemData;
import com.nukkitx.protocol.bedrock.v354.serializer.CraftingDataSerializer_v354;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public class CraftingDataSerializer_v361
extends CraftingDataSerializer_v354 {
    public static final CraftingDataSerializer_v361 INSTANCE = new CraftingDataSerializer_v361();

    protected CraftingData readShapelessRecipe(ByteBuf buffer, BedrockPacketHelper helper, CraftingDataType type, BedrockSession session) {
        String recipeId = helper.readString(buffer);
        ObjectArrayList inputs = new ObjectArrayList();
        helper.readArray(buffer, (Collection)inputs, this::readIngredient);
        ObjectArrayList outputs = new ObjectArrayList();
        helper.readArray(buffer, (Collection)outputs, buf -> helper.readItem(buf, session));
        UUID uuid = helper.readUuid(buffer);
        String craftingTag = helper.readString(buffer);
        int priority = VarInts.readInt((ByteBuf)buffer);
        return new CraftingData(type, recipeId, -1, -1, -1, -1, (List)inputs, (List)outputs, uuid, craftingTag, priority);
    }

    protected void writeShapelessRecipe(ByteBuf buffer, BedrockPacketHelper helper, CraftingData data, BedrockSession session) {
        helper.writeString(buffer, data.getRecipeId());
        helper.writeArray(buffer, (Collection)data.getInputs(), this::writeIngredient);
        helper.writeArray(buffer, (Collection)data.getOutputs(), (buf, item) -> helper.writeItem(buf, item, session));
        helper.writeUuid(buffer, data.getUuid());
        helper.writeString(buffer, data.getCraftingTag());
        VarInts.writeInt((ByteBuf)buffer, (int)data.getPriority());
    }

    protected CraftingData readShapedRecipe(ByteBuf buffer, BedrockPacketHelper helper, CraftingDataType type, BedrockSession session) {
        String recipeId = helper.readString(buffer);
        int width = VarInts.readInt((ByteBuf)buffer);
        int height = VarInts.readInt((ByteBuf)buffer);
        int inputCount = width * height;
        ObjectArrayList inputs = new ObjectArrayList(inputCount);
        for (int i = 0; i < inputCount; ++i) {
            inputs.add(this.readIngredient(buffer));
        }
        ObjectArrayList outputs = new ObjectArrayList();
        helper.readArray(buffer, (Collection)outputs, buf -> helper.readItem(buf, session));
        UUID uuid = helper.readUuid(buffer);
        String craftingTag = helper.readString(buffer);
        int priority = VarInts.readInt((ByteBuf)buffer);
        return new CraftingData(type, recipeId, width, height, -1, -1, (List)inputs, (List)outputs, uuid, craftingTag, priority);
    }

    protected void writeShapedRecipe(ByteBuf buffer, BedrockPacketHelper helper, CraftingData data, BedrockSession session) {
        helper.writeString(buffer, data.getRecipeId());
        VarInts.writeInt((ByteBuf)buffer, (int)data.getWidth());
        VarInts.writeInt((ByteBuf)buffer, (int)data.getHeight());
        int count = data.getWidth() * data.getHeight();
        List inputs = data.getInputs();
        for (int i = 0; i < count; ++i) {
            this.writeIngredient(buffer, (ItemData)inputs.get(i));
        }
        helper.writeArray(buffer, (Collection)data.getOutputs(), (buf, item) -> helper.writeItem(buf, item, session));
        helper.writeUuid(buffer, data.getUuid());
        helper.writeString(buffer, data.getCraftingTag());
        VarInts.writeInt((ByteBuf)buffer, (int)data.getPriority());
    }

    protected ItemData readIngredient(ByteBuf buffer) {
        int id = VarInts.readInt((ByteBuf)buffer);
        int auxValue = 0;
        int stackSize = 0;
        if (id != 0) {
            auxValue = VarInts.readInt((ByteBuf)buffer);
            if (auxValue == Short.MAX_VALUE) {
                auxValue = -1;
            }
            stackSize = VarInts.readInt((ByteBuf)buffer);
        }
        return ItemData.builder().id(id).damage(auxValue).count(stackSize).build();
    }

    protected void writeIngredient(ByteBuf buffer, ItemData itemData) {
        Objects.requireNonNull(itemData, "ItemData is null");
        int id = itemData.getId();
        VarInts.writeInt((ByteBuf)buffer, (int)id);
        if (id != 0) {
            int damage = itemData.getDamage();
            if (damage == -1) {
                damage = Short.MAX_VALUE;
            }
            VarInts.writeInt((ByteBuf)buffer, (int)damage);
            VarInts.writeInt((ByteBuf)buffer, (int)itemData.getCount());
        }
    }

    protected CraftingDataSerializer_v361() {
    }
}

