/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v354.serializer;

import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.BedrockPacketHelper;
import com.nukkitx.protocol.bedrock.BedrockSession;
import com.nukkitx.protocol.bedrock.data.inventory.CraftingData;
import com.nukkitx.protocol.bedrock.data.inventory.CraftingDataType;
import com.nukkitx.protocol.bedrock.v291.serializer.CraftingDataSerializer_v291;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public class CraftingDataSerializer_v354
extends CraftingDataSerializer_v291 {
    public static final CraftingDataSerializer_v354 INSTANCE = new CraftingDataSerializer_v354();

    protected CraftingData readShapelessRecipe(ByteBuf buffer, BedrockPacketHelper helper, CraftingDataType type, BedrockSession session) {
        ObjectArrayList inputs = new ObjectArrayList();
        helper.readArray(buffer, (Collection)inputs, buf -> helper.readItem(buf, session));
        ObjectArrayList outputs = new ObjectArrayList();
        helper.readArray(buffer, (Collection)outputs, buf -> helper.readItem(buf, session));
        UUID uuid = helper.readUuid(buffer);
        String craftingTag = helper.readString(buffer);
        return new CraftingData(type, -1, -1, -1, -1, (List)inputs, (List)outputs, uuid, craftingTag);
    }

    protected void writeShapelessRecipe(ByteBuf buffer, BedrockPacketHelper helper, CraftingData data, BedrockSession session) {
        super.writeShapelessRecipe(buffer, helper, data, session);
        helper.writeString(buffer, data.getCraftingTag());
    }

    protected CraftingData readShapedRecipe(ByteBuf buffer, BedrockPacketHelper helper, CraftingDataType type, BedrockSession session) {
        int width = VarInts.readInt((ByteBuf)buffer);
        int height = VarInts.readInt((ByteBuf)buffer);
        int inputCount = width * height;
        ObjectArrayList inputs = new ObjectArrayList(inputCount);
        for (int i = 0; i < inputCount; ++i) {
            inputs.add(helper.readItem(buffer, session));
        }
        ObjectArrayList outputs = new ObjectArrayList();
        helper.readArray(buffer, (Collection)outputs, buf -> helper.readItem(buf, session));
        UUID uuid = helper.readUuid(buffer);
        String craftingTag = helper.readString(buffer);
        return new CraftingData(type, width, height, -1, -1, (List)inputs, (List)outputs, uuid, craftingTag);
    }

    protected void writeShapedRecipe(ByteBuf buffer, BedrockPacketHelper helper, CraftingData data, BedrockSession session) {
        super.writeShapedRecipe(buffer, helper, data, session);
        helper.writeString(buffer, data.getCraftingTag());
    }

    protected CraftingData readFurnaceRecipe(ByteBuf buffer, BedrockPacketHelper helper, CraftingDataType type, BedrockSession session) {
        int inputId = VarInts.readInt((ByteBuf)buffer);
        int inputDamage = type == CraftingDataType.FURNACE_DATA ? VarInts.readInt((ByteBuf)buffer) : -1;
        ObjectArrayList output = new ObjectArrayList(Collections.singleton(helper.readItem(buffer, session)));
        String craftingTag = helper.readString(buffer);
        return new CraftingData(type, -1, -1, inputId, inputDamage, null, (List)output, null, craftingTag);
    }

    protected void writeFurnaceRecipe(ByteBuf buffer, BedrockPacketHelper helper, CraftingData data, BedrockSession session) {
        super.writeFurnaceRecipe(buffer, helper, data, session);
        helper.writeString(buffer, data.getCraftingTag());
    }

    protected CraftingDataSerializer_v354() {
    }
}

