/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v291.serializer;

import com.nukkitx.protocol.bedrock.BedrockPacketHelper;
import com.nukkitx.protocol.bedrock.BedrockPacketSerializer;
import com.nukkitx.protocol.bedrock.packet.TextPacket;
import io.netty.buffer.ByteBuf;
import java.util.Collection;

public class TextSerializer_v291
implements BedrockPacketSerializer<TextPacket> {
    public static final TextSerializer_v291 INSTANCE = new TextSerializer_v291();

    public void serialize(ByteBuf buffer, BedrockPacketHelper helper, TextPacket packet) {
        TextPacket.Type type = packet.getType();
        buffer.writeByte(type.ordinal());
        buffer.writeBoolean(packet.isNeedsTranslation());
        switch (type) {
            case CHAT: 
            case WHISPER: 
            case ANNOUNCEMENT: {
                helper.writeString(buffer, packet.getSourceName());
            }
            case RAW: 
            case TIP: 
            case SYSTEM: {
                helper.writeString(buffer, packet.getMessage());
                break;
            }
            case TRANSLATION: 
            case POPUP: 
            case JUKEBOX_POPUP: {
                helper.writeString(buffer, packet.getMessage());
                helper.writeArray(buffer, (Collection)packet.getParameters(), (arg_0, arg_1) -> ((BedrockPacketHelper)helper).writeString(arg_0, arg_1));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported TextType " + type);
            }
        }
        helper.writeString(buffer, packet.getXuid());
        helper.writeString(buffer, packet.getPlatformChatId());
    }

    public void deserialize(ByteBuf buffer, BedrockPacketHelper helper, TextPacket packet) {
        TextPacket.Type type = TextPacket.Type.values()[buffer.readUnsignedByte()];
        packet.setType(type);
        packet.setNeedsTranslation(buffer.readBoolean());
        switch (type) {
            case CHAT: 
            case WHISPER: 
            case ANNOUNCEMENT: {
                packet.setSourceName(helper.readString(buffer));
            }
            case RAW: 
            case TIP: 
            case SYSTEM: {
                packet.setMessage(helper.readString(buffer));
                break;
            }
            case TRANSLATION: 
            case POPUP: 
            case JUKEBOX_POPUP: {
                packet.setMessage(helper.readString(buffer));
                helper.readArray(buffer, (Collection)packet.getParameters(), arg_0 -> ((BedrockPacketHelper)helper).readString(arg_0));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported TextType " + type);
            }
        }
        packet.setXuid(helper.readString(buffer));
        packet.setPlatformChatId(helper.readString(buffer));
    }

    protected TextSerializer_v291() {
    }
}

