/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v291.serializer;

import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.BedrockPacketHelper;
import com.nukkitx.protocol.bedrock.BedrockPacketSerializer;
import com.nukkitx.protocol.bedrock.data.ScoreInfo;
import com.nukkitx.protocol.bedrock.packet.SetScorePacket;
import io.netty.buffer.ByteBuf;
import java.util.Collection;

public class SetScoreSerializer_v291
implements BedrockPacketSerializer<SetScorePacket> {
    public static final SetScoreSerializer_v291 INSTANCE = new SetScoreSerializer_v291();

    public void serialize(ByteBuf buffer, BedrockPacketHelper helper, SetScorePacket packet) {
        SetScorePacket.Action action = packet.getAction();
        buffer.writeByte(action.ordinal());
        helper.writeArray(buffer, (Collection)packet.getInfos(), (buf, scoreInfo) -> {
            VarInts.writeLong((ByteBuf)buf, (long)scoreInfo.getScoreboardId());
            helper.writeString(buf, scoreInfo.getObjectiveId());
            buf.writeIntLE(scoreInfo.getScore());
            if (action == SetScorePacket.Action.SET) {
                buf.writeByte(scoreInfo.getType().ordinal());
                switch (scoreInfo.getType()) {
                    case ENTITY: 
                    case PLAYER: {
                        VarInts.writeLong((ByteBuf)buf, (long)scoreInfo.getEntityId());
                        break;
                    }
                    case FAKE: {
                        helper.writeString(buf, scoreInfo.getName());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid score info received");
                    }
                }
            }
        });
    }

    public void deserialize(ByteBuf buffer, BedrockPacketHelper helper, SetScorePacket packet) {
        SetScorePacket.Action action = SetScorePacket.Action.values()[buffer.readUnsignedByte()];
        packet.setAction(action);
        helper.readArray(buffer, (Collection)packet.getInfos(), buf -> {
            long scoreboardId = VarInts.readLong((ByteBuf)buf);
            String objectiveId = helper.readString(buf);
            int score = buf.readIntLE();
            if (action == SetScorePacket.Action.SET) {
                ScoreInfo.ScorerType type = ScoreInfo.ScorerType.values()[buf.readUnsignedByte()];
                switch (type) {
                    case ENTITY: 
                    case PLAYER: {
                        long entityId = VarInts.readLong((ByteBuf)buf);
                        return new ScoreInfo(scoreboardId, objectiveId, score, type, entityId);
                    }
                    case FAKE: {
                        String name = helper.readString(buf);
                        return new ScoreInfo(scoreboardId, objectiveId, score, name);
                    }
                }
                throw new IllegalArgumentException("Invalid score info received");
            }
            return new ScoreInfo(scoreboardId, objectiveId, score);
        });
    }

    protected SetScoreSerializer_v291() {
    }
}

