/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v291.serializer;

import com.nukkitx.network.VarInts;
import com.nukkitx.network.util.Preconditions;
import com.nukkitx.protocol.bedrock.BedrockPacketHelper;
import com.nukkitx.protocol.bedrock.BedrockPacketSerializer;
import com.nukkitx.protocol.bedrock.data.event.AchievementAwardedEventData;
import com.nukkitx.protocol.bedrock.data.event.AgentCommandEventData;
import com.nukkitx.protocol.bedrock.data.event.AgentCreatedEventData;
import com.nukkitx.protocol.bedrock.data.event.BossKilledEventData;
import com.nukkitx.protocol.bedrock.data.event.CauldronUsedEventData;
import com.nukkitx.protocol.bedrock.data.event.EntityInteractEventData;
import com.nukkitx.protocol.bedrock.data.event.EventData;
import com.nukkitx.protocol.bedrock.data.event.EventDataType;
import com.nukkitx.protocol.bedrock.data.event.FishBucketedEventData;
import com.nukkitx.protocol.bedrock.data.event.MobKilledEventData;
import com.nukkitx.protocol.bedrock.data.event.PatternRemovedEventData;
import com.nukkitx.protocol.bedrock.data.event.PlayerDiedEventData;
import com.nukkitx.protocol.bedrock.data.event.PortalBuiltEventData;
import com.nukkitx.protocol.bedrock.data.event.PortalUsedEventData;
import com.nukkitx.protocol.bedrock.data.event.SlashCommandExecutedEventData;
import com.nukkitx.protocol.bedrock.packet.EventPacket;
import com.nukkitx.protocol.bedrock.util.TriConsumer;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.function.BiFunction;

public class EventSerializer_v291
implements BedrockPacketSerializer<EventPacket> {
    public static final EventSerializer_v291 INSTANCE = new EventSerializer_v291();
    protected static final EventDataType[] VALUES = EventDataType.values();
    protected final EnumMap<EventDataType, BiFunction<ByteBuf, BedrockPacketHelper, EventData>> readers = new EnumMap(EventDataType.class);
    protected final EnumMap<EventDataType, TriConsumer<ByteBuf, BedrockPacketHelper, EventData>> writers = new EnumMap(EventDataType.class);

    protected EventSerializer_v291() {
        this.readers.put(EventDataType.ACHIEVEMENT_AWARDED, this::readAchievementAwarded);
        this.readers.put(EventDataType.ENTITY_INTERACT, this::readEntityInteract);
        this.readers.put(EventDataType.PORTAL_BUILT, this::readPortalBuilt);
        this.readers.put(EventDataType.PORTAL_USED, this::readPortalUsed);
        this.readers.put(EventDataType.MOB_KILLED, this::readMobKilled);
        this.readers.put(EventDataType.CAULDRON_USED, this::readCauldronUsed);
        this.readers.put(EventDataType.PLAYER_DIED, this::readPlayerDied);
        this.readers.put(EventDataType.BOSS_KILLED, this::readBossKilled);
        this.readers.put(EventDataType.AGENT_COMMAND, this::readAgentCommand);
        this.readers.put(EventDataType.AGENT_CREATED, (b, h) -> AgentCreatedEventData.INSTANCE);
        this.readers.put(EventDataType.PATTERN_REMOVED, this::readPatternRemoved);
        this.readers.put(EventDataType.SLASH_COMMAND_EXECUTED, this::readSlashCommandExecuted);
        this.readers.put(EventDataType.FISH_BUCKETED, this::readFishBucketed);
        this.writers.put(EventDataType.ACHIEVEMENT_AWARDED, (TriConsumer<ByteBuf, BedrockPacketHelper, EventData>)((TriConsumer)this::writeAchievementAwarded));
        this.writers.put(EventDataType.ENTITY_INTERACT, (TriConsumer<ByteBuf, BedrockPacketHelper, EventData>)((TriConsumer)this::writeEntityInteract));
        this.writers.put(EventDataType.PORTAL_BUILT, (TriConsumer<ByteBuf, BedrockPacketHelper, EventData>)((TriConsumer)this::writePortalBuilt));
        this.writers.put(EventDataType.PORTAL_USED, (TriConsumer<ByteBuf, BedrockPacketHelper, EventData>)((TriConsumer)this::writePortalUsed));
        this.writers.put(EventDataType.MOB_KILLED, (TriConsumer<ByteBuf, BedrockPacketHelper, EventData>)((TriConsumer)this::writeMobKilled));
        this.writers.put(EventDataType.CAULDRON_USED, (TriConsumer<ByteBuf, BedrockPacketHelper, EventData>)((TriConsumer)this::writeCauldronUsed));
        this.writers.put(EventDataType.PLAYER_DIED, (TriConsumer<ByteBuf, BedrockPacketHelper, EventData>)((TriConsumer)this::writePlayerDied));
        this.writers.put(EventDataType.BOSS_KILLED, (TriConsumer<ByteBuf, BedrockPacketHelper, EventData>)((TriConsumer)this::writeBossKilled));
        this.writers.put(EventDataType.AGENT_COMMAND, (TriConsumer<ByteBuf, BedrockPacketHelper, EventData>)((TriConsumer)this::writeAgentCommand));
        this.writers.put(EventDataType.AGENT_CREATED, (TriConsumer<ByteBuf, BedrockPacketHelper, EventData>)((TriConsumer)(b, h, e) -> {}));
        this.writers.put(EventDataType.PATTERN_REMOVED, (TriConsumer<ByteBuf, BedrockPacketHelper, EventData>)((TriConsumer)this::writePatternRemoved));
        this.writers.put(EventDataType.SLASH_COMMAND_EXECUTED, (TriConsumer<ByteBuf, BedrockPacketHelper, EventData>)((TriConsumer)this::writeSlashCommandExecuted));
        this.writers.put(EventDataType.FISH_BUCKETED, (TriConsumer<ByteBuf, BedrockPacketHelper, EventData>)((TriConsumer)this::writeFishBucketed));
    }

    public void serialize(ByteBuf buffer, BedrockPacketHelper helper, EventPacket packet) {
        VarInts.writeLong((ByteBuf)buffer, (long)packet.getUniqueEntityId());
        EventData eventData = packet.getEventData();
        VarInts.writeInt((ByteBuf)buffer, (int)eventData.getType().ordinal());
        buffer.writeByte((int)packet.getUsePlayerId());
        TriConsumer<ByteBuf, BedrockPacketHelper, EventData> function = this.writers.get(eventData.getType());
        if (function == null) {
            throw new UnsupportedOperationException("Unknown event type " + eventData.getType());
        }
        function.accept((Object)buffer, (Object)helper, (Object)eventData);
    }

    public void deserialize(ByteBuf buffer, BedrockPacketHelper helper, EventPacket packet) {
        packet.setUniqueEntityId(VarInts.readLong((ByteBuf)buffer));
        int eventId = VarInts.readInt((ByteBuf)buffer);
        Preconditions.checkElementIndex((int)eventId, (int)VALUES.length, (String)"EventDataType");
        EventDataType type = VALUES[eventId];
        packet.setUsePlayerId(buffer.readByte());
        BiFunction<ByteBuf, BedrockPacketHelper, EventData> function = this.readers.get(type);
        if (function == null) {
            throw new UnsupportedOperationException("Unknown event type " + type);
        }
        function.apply(buffer, helper);
    }

    protected AchievementAwardedEventData readAchievementAwarded(ByteBuf buffer, BedrockPacketHelper helper) {
        int achievementId = VarInts.readInt((ByteBuf)buffer);
        return new AchievementAwardedEventData(achievementId);
    }

    protected void writeAchievementAwarded(ByteBuf buffer, BedrockPacketHelper helper, EventData eventData) {
        AchievementAwardedEventData event = (AchievementAwardedEventData)eventData;
        VarInts.writeInt((ByteBuf)buffer, (int)event.getAchievementId());
    }

    protected EntityInteractEventData readEntityInteract(ByteBuf buffer, BedrockPacketHelper helper) {
        int interactionType = VarInts.readInt((ByteBuf)buffer);
        int interactionEntityType = VarInts.readInt((ByteBuf)buffer);
        int entityVariant = VarInts.readInt((ByteBuf)buffer);
        short entityColor = buffer.readUnsignedByte();
        return new EntityInteractEventData(interactionType, interactionEntityType, entityVariant, (int)entityColor);
    }

    protected void writeEntityInteract(ByteBuf buffer, BedrockPacketHelper helper, EventData eventData) {
        EntityInteractEventData event = (EntityInteractEventData)eventData;
        VarInts.writeInt((ByteBuf)buffer, (int)event.getInteractionType());
        VarInts.writeInt((ByteBuf)buffer, (int)event.getLegacyEntityTypeId());
        VarInts.writeInt((ByteBuf)buffer, (int)event.getVariant());
        buffer.writeByte(event.getPaletteColor());
    }

    protected PortalBuiltEventData readPortalBuilt(ByteBuf buffer, BedrockPacketHelper helper) {
        int dimensionId = VarInts.readInt((ByteBuf)buffer);
        return new PortalBuiltEventData(dimensionId);
    }

    protected void writePortalBuilt(ByteBuf buffer, BedrockPacketHelper helper, EventData eventData) {
        PortalBuiltEventData event = (PortalBuiltEventData)eventData;
        VarInts.writeInt((ByteBuf)buffer, (int)event.getDimensionId());
    }

    protected PortalUsedEventData readPortalUsed(ByteBuf buffer, BedrockPacketHelper helper) {
        int fromDimensionId = VarInts.readInt((ByteBuf)buffer);
        int toDimensionId = VarInts.readInt((ByteBuf)buffer);
        return new PortalUsedEventData(fromDimensionId, toDimensionId);
    }

    protected void writePortalUsed(ByteBuf buffer, BedrockPacketHelper helper, EventData eventData) {
        PortalUsedEventData event = (PortalUsedEventData)eventData;
        VarInts.writeInt((ByteBuf)buffer, (int)event.getFromDimensionId());
        VarInts.writeInt((ByteBuf)buffer, (int)event.getToDimensionId());
    }

    protected MobKilledEventData readMobKilled(ByteBuf buffer, BedrockPacketHelper helper) {
        long killerUniqueEntityId = VarInts.readLong((ByteBuf)buffer);
        long victimUniqueEntityId = VarInts.readLong((ByteBuf)buffer);
        int entityDamageCause = VarInts.readInt((ByteBuf)buffer);
        int villagerTradeTier = VarInts.readInt((ByteBuf)buffer);
        String villagerDisplayName = helper.readString(buffer);
        return new MobKilledEventData(killerUniqueEntityId, victimUniqueEntityId, -1, entityDamageCause, villagerTradeTier, villagerDisplayName);
    }

    protected void writeMobKilled(ByteBuf buffer, BedrockPacketHelper helper, EventData eventData) {
        MobKilledEventData event = (MobKilledEventData)eventData;
        VarInts.writeLong((ByteBuf)buffer, (long)event.getKillerUniqueEntityId());
        VarInts.writeLong((ByteBuf)buffer, (long)event.getVictimUniqueEntityId());
        VarInts.writeInt((ByteBuf)buffer, (int)event.getEntityDamageCause());
        VarInts.writeInt((ByteBuf)buffer, (int)event.getVillagerTradeTier());
        helper.writeString(buffer, event.getVillagerDisplayName());
    }

    protected CauldronUsedEventData readCauldronUsed(ByteBuf buffer, BedrockPacketHelper helper) {
        int potionId = VarInts.readInt((ByteBuf)buffer);
        int color = VarInts.readInt((ByteBuf)buffer);
        int fillLevel = VarInts.readInt((ByteBuf)buffer);
        return new CauldronUsedEventData(potionId, color, fillLevel);
    }

    protected void writeCauldronUsed(ByteBuf buffer, BedrockPacketHelper helper, EventData eventData) {
        CauldronUsedEventData event = (CauldronUsedEventData)eventData;
        VarInts.writeUnsignedInt((ByteBuf)buffer, (int)event.getPotionId());
        VarInts.writeInt((ByteBuf)buffer, (int)event.getColor());
        VarInts.writeInt((ByteBuf)buffer, (int)event.getFillLevel());
    }

    protected PlayerDiedEventData readPlayerDied(ByteBuf buffer, BedrockPacketHelper helper) {
        int attackerEntityId = VarInts.readInt((ByteBuf)buffer);
        int entityDamageCause = VarInts.readInt((ByteBuf)buffer);
        return new PlayerDiedEventData(attackerEntityId, -1, entityDamageCause, false);
    }

    protected void writePlayerDied(ByteBuf buffer, BedrockPacketHelper helper, EventData eventData) {
        PlayerDiedEventData event = (PlayerDiedEventData)eventData;
        VarInts.writeInt((ByteBuf)buffer, (int)event.getAttackerEntityId());
        VarInts.writeInt((ByteBuf)buffer, (int)event.getEntityDamageCause());
    }

    protected BossKilledEventData readBossKilled(ByteBuf buffer, BedrockPacketHelper helper) {
        long bossUniqueEntityId = VarInts.readLong((ByteBuf)buffer);
        int playerPartySize = VarInts.readInt((ByteBuf)buffer);
        int interactionEntityType = VarInts.readInt((ByteBuf)buffer);
        return new BossKilledEventData(bossUniqueEntityId, playerPartySize, interactionEntityType);
    }

    protected void writeBossKilled(ByteBuf buffer, BedrockPacketHelper helper, EventData eventData) {
        BossKilledEventData event = (BossKilledEventData)eventData;
        VarInts.writeLong((ByteBuf)buffer, (long)event.getBossUniqueEntityId());
        VarInts.writeInt((ByteBuf)buffer, (int)event.getPlayerPartySize());
        VarInts.writeInt((ByteBuf)buffer, (int)event.getBossEntityType());
    }

    protected AgentCommandEventData readAgentCommand(ByteBuf buffer, BedrockPacketHelper helper) {
        int agentResult = VarInts.readInt((ByteBuf)buffer);
        int dataValue = VarInts.readInt((ByteBuf)buffer);
        String command = helper.readString(buffer);
        String dataKey = helper.readString(buffer);
        String output = helper.readString(buffer);
        return new AgentCommandEventData(agentResult, command, dataKey, dataValue, output);
    }

    protected void writeAgentCommand(ByteBuf buffer, BedrockPacketHelper helper, EventData eventData) {
        AgentCommandEventData event = (AgentCommandEventData)eventData;
        VarInts.writeInt((ByteBuf)buffer, (int)event.getAgentResult());
        VarInts.writeInt((ByteBuf)buffer, (int)event.getDataValue());
        helper.writeString(buffer, event.getCommand());
        helper.writeString(buffer, event.getDataKey());
        helper.writeString(buffer, event.getOutput());
    }

    protected PatternRemovedEventData readPatternRemoved(ByteBuf buffer, BedrockPacketHelper helper) {
        int itemId = VarInts.readInt((ByteBuf)buffer);
        int auxValue = VarInts.readInt((ByteBuf)buffer);
        int patternsSize = VarInts.readInt((ByteBuf)buffer);
        int patternIndex = VarInts.readInt((ByteBuf)buffer);
        int patternColor = VarInts.readInt((ByteBuf)buffer);
        return new PatternRemovedEventData(itemId, auxValue, patternsSize, patternIndex, patternColor);
    }

    protected void writePatternRemoved(ByteBuf buffer, BedrockPacketHelper helper, EventData eventData) {
        PatternRemovedEventData event = (PatternRemovedEventData)eventData;
        VarInts.writeInt((ByteBuf)buffer, (int)event.getItemId());
        VarInts.writeInt((ByteBuf)buffer, (int)event.getAuxValue());
        VarInts.writeInt((ByteBuf)buffer, (int)event.getPatternsSize());
        VarInts.writeInt((ByteBuf)buffer, (int)event.getPatternIndex());
        VarInts.writeInt((ByteBuf)buffer, (int)event.getPatternColor());
    }

    protected SlashCommandExecutedEventData readSlashCommandExecuted(ByteBuf buffer, BedrockPacketHelper helper) {
        int successCount = VarInts.readInt((ByteBuf)buffer);
        VarInts.readInt((ByteBuf)buffer);
        String commandName = helper.readString(buffer);
        List<String> outputMessages = Arrays.asList(helper.readString(buffer).split(";"));
        return new SlashCommandExecutedEventData(commandName, successCount, outputMessages);
    }

    protected void writeSlashCommandExecuted(ByteBuf buffer, BedrockPacketHelper helper, EventData eventData) {
        SlashCommandExecutedEventData event = (SlashCommandExecutedEventData)eventData;
        VarInts.writeInt((ByteBuf)buffer, (int)event.getSuccessCount());
        List outputMessages = event.getOutputMessages();
        VarInts.writeInt((ByteBuf)buffer, (int)outputMessages.size());
        helper.writeString(buffer, event.getCommandName());
        helper.writeString(buffer, String.join((CharSequence)";", outputMessages));
    }

    protected FishBucketedEventData readFishBucketed(ByteBuf buffer, BedrockPacketHelper helper) {
        int pattern = VarInts.readInt((ByteBuf)buffer);
        int preset = VarInts.readInt((ByteBuf)buffer);
        int bucketedEntityType = VarInts.readInt((ByteBuf)buffer);
        boolean isRelease = buffer.readBoolean();
        return new FishBucketedEventData(pattern, preset, bucketedEntityType, isRelease);
    }

    protected void writeFishBucketed(ByteBuf buffer, BedrockPacketHelper helper, EventData eventData) {
        FishBucketedEventData event = (FishBucketedEventData)eventData;
        VarInts.writeInt((ByteBuf)buffer, (int)event.getPattern());
        VarInts.writeInt((ByteBuf)buffer, (int)event.getPreset());
        VarInts.writeInt((ByteBuf)buffer, (int)event.getBucketedEntityType());
        buffer.writeBoolean(event.isReleaseEvent());
    }
}

