/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v291.serializer;

import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.BedrockPacketHelper;
import com.nukkitx.protocol.bedrock.BedrockPacketSerializer;
import com.nukkitx.protocol.bedrock.data.command.CommandOutputMessage;
import com.nukkitx.protocol.bedrock.data.command.CommandOutputType;
import com.nukkitx.protocol.bedrock.packet.CommandOutputPacket;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.Objects;

public class CommandOutputSerializer_v291
implements BedrockPacketSerializer<CommandOutputPacket> {
    public static final CommandOutputSerializer_v291 INSTANCE = new CommandOutputSerializer_v291();

    public void serialize(ByteBuf buffer, BedrockPacketHelper helper, CommandOutputPacket packet) {
        helper.writeCommandOrigin(buffer, packet.getCommandOriginData());
        buffer.writeByte(packet.getType().ordinal());
        VarInts.writeUnsignedInt((ByteBuf)buffer, (int)packet.getSuccessCount());
        helper.writeArray(buffer, (Collection)packet.getMessages(), this::writeMessage);
        if (packet.getType() == CommandOutputType.DATA_SET) {
            helper.writeString(buffer, packet.getData());
        }
    }

    public void deserialize(ByteBuf buffer, BedrockPacketHelper helper, CommandOutputPacket packet) {
        packet.setCommandOriginData(helper.readCommandOrigin(buffer));
        packet.setType(CommandOutputType.values()[buffer.readUnsignedByte()]);
        packet.setSuccessCount(VarInts.readUnsignedInt((ByteBuf)buffer));
        helper.readArray(buffer, (Collection)packet.getMessages(), this::readMessage);
        if (packet.getType() == CommandOutputType.DATA_SET) {
            packet.setData(helper.readString(buffer));
        }
    }

    public CommandOutputMessage readMessage(ByteBuf buffer, BedrockPacketHelper helper) {
        boolean internal = buffer.readBoolean();
        String messageId = helper.readString(buffer);
        String[] parameters = (String[])helper.readArray(buffer, (Object[])new String[0], arg_0 -> ((BedrockPacketHelper)helper).readString(arg_0));
        return new CommandOutputMessage(internal, messageId, parameters);
    }

    public void writeMessage(ByteBuf buffer, BedrockPacketHelper helper, CommandOutputMessage outputMessage) {
        Objects.requireNonNull(outputMessage, "CommandOutputMessage is null");
        buffer.writeBoolean(outputMessage.isInternal());
        helper.writeString(buffer, outputMessage.getMessageId());
        helper.writeArray(buffer, (Object[])outputMessage.getParameters(), (arg_0, arg_1) -> ((BedrockPacketHelper)helper).writeString(arg_0, arg_1));
    }

    protected CommandOutputSerializer_v291() {
    }
}

