/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v291.serializer;

import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.BedrockPacketHelper;
import com.nukkitx.protocol.bedrock.BedrockPacketSerializer;
import com.nukkitx.protocol.bedrock.BedrockSession;
import com.nukkitx.protocol.bedrock.data.inventory.CraftingData;
import com.nukkitx.protocol.bedrock.data.inventory.CraftingDataType;
import com.nukkitx.protocol.bedrock.data.inventory.ItemData;
import com.nukkitx.protocol.bedrock.packet.CraftingDataPacket;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public class CraftingDataSerializer_v291
implements BedrockPacketSerializer<CraftingDataPacket> {
    public static final CraftingDataSerializer_v291 INSTANCE = new CraftingDataSerializer_v291();
    protected static final ItemData[] EMPTY_ARRAY = new ItemData[0];

    public void serialize(ByteBuf buffer, BedrockPacketHelper helper, CraftingDataPacket packet, BedrockSession session) {
        helper.writeArray(buffer, (Collection)packet.getCraftingData(), (buf, craftingData) -> {
            VarInts.writeInt((ByteBuf)buf, (int)craftingData.getType().ordinal());
            switch (craftingData.getType()) {
                case SHAPELESS: 
                case SHAPELESS_CHEMISTRY: 
                case SHULKER_BOX: {
                    this.writeShapelessRecipe((ByteBuf)buf, helper, (CraftingData)craftingData, session);
                    break;
                }
                case SHAPED: 
                case SHAPED_CHEMISTRY: {
                    this.writeShapedRecipe((ByteBuf)buf, helper, (CraftingData)craftingData, session);
                    break;
                }
                case FURNACE: 
                case FURNACE_DATA: {
                    this.writeFurnaceRecipe((ByteBuf)buf, helper, (CraftingData)craftingData, session);
                    break;
                }
                case MULTI: {
                    this.writeMultiRecipe((ByteBuf)buf, helper, (CraftingData)craftingData);
                }
            }
        });
        buffer.writeBoolean(packet.isCleanRecipes());
    }

    public void deserialize(ByteBuf buffer, BedrockPacketHelper helper, CraftingDataPacket packet, BedrockSession session) {
        helper.readArray(buffer, (Collection)packet.getCraftingData(), buf -> {
            int typeInt = VarInts.readInt((ByteBuf)buf);
            CraftingDataType type = CraftingDataType.byId((int)typeInt);
            switch (type) {
                case SHAPELESS: 
                case SHAPELESS_CHEMISTRY: 
                case SHULKER_BOX: {
                    return this.readShapelessRecipe((ByteBuf)buf, helper, type, session);
                }
                case SHAPED: 
                case SHAPED_CHEMISTRY: {
                    return this.readShapedRecipe((ByteBuf)buf, helper, type, session);
                }
                case FURNACE: 
                case FURNACE_DATA: {
                    return this.readFurnaceRecipe((ByteBuf)buf, helper, type, session);
                }
                case MULTI: {
                    return this.readMultiRecipe((ByteBuf)buf, helper, type);
                }
            }
            throw new IllegalArgumentException("Unhandled crafting data type: " + type);
        });
        packet.setCleanRecipes(buffer.readBoolean());
    }

    protected CraftingData readShapelessRecipe(ByteBuf buffer, BedrockPacketHelper helper, CraftingDataType type, BedrockSession session) {
        ObjectArrayList inputs = new ObjectArrayList();
        helper.readArray(buffer, (Collection)inputs, buf -> helper.readItem(buf, session));
        ObjectArrayList outputs = new ObjectArrayList();
        helper.readArray(buffer, (Collection)outputs, buf -> helper.readItem(buf, session));
        UUID uuid = helper.readUuid(buffer);
        return new CraftingData(type, -1, -1, -1, -1, (List)inputs, (List)outputs, uuid, null);
    }

    protected void writeShapelessRecipe(ByteBuf buffer, BedrockPacketHelper helper, CraftingData data, BedrockSession session) {
        helper.writeArray(buffer, (Collection)data.getInputs(), (buf, item) -> helper.writeItem(buf, item, session));
        helper.writeArray(buffer, (Collection)data.getOutputs(), (buf, item) -> helper.writeItem(buf, item, session));
        helper.writeUuid(buffer, data.getUuid());
    }

    protected CraftingData readShapedRecipe(ByteBuf buffer, BedrockPacketHelper helper, CraftingDataType type, BedrockSession session) {
        int width = VarInts.readInt((ByteBuf)buffer);
        int height = VarInts.readInt((ByteBuf)buffer);
        int inputCount = width * height;
        ObjectArrayList inputs = new ObjectArrayList(inputCount);
        for (int i = 0; i < inputCount; ++i) {
            inputs.add(helper.readItem(buffer, session));
        }
        ObjectArrayList outputs = new ObjectArrayList();
        helper.readArray(buffer, (Collection)outputs, buf -> helper.readItem(buf, session));
        UUID uuid = helper.readUuid(buffer);
        return new CraftingData(type, width, height, -1, -1, (List)inputs, (List)outputs, uuid, null);
    }

    protected void writeShapedRecipe(ByteBuf buffer, BedrockPacketHelper helper, CraftingData data, BedrockSession session) {
        VarInts.writeInt((ByteBuf)buffer, (int)data.getWidth());
        VarInts.writeInt((ByteBuf)buffer, (int)data.getHeight());
        int count = data.getWidth() * data.getHeight();
        List inputs = data.getInputs();
        for (int i = 0; i < count; ++i) {
            helper.writeItem(buffer, (ItemData)inputs.get(i), session);
        }
        helper.writeArray(buffer, (Collection)data.getOutputs(), (buf, item) -> helper.writeItem(buf, item, session));
        helper.writeUuid(buffer, data.getUuid());
    }

    protected CraftingData readFurnaceRecipe(ByteBuf buffer, BedrockPacketHelper helper, CraftingDataType type, BedrockSession session) {
        int inputId = VarInts.readInt((ByteBuf)buffer);
        int inputDamage = type == CraftingDataType.FURNACE_DATA ? VarInts.readInt((ByteBuf)buffer) : -1;
        ObjectArrayList output = new ObjectArrayList(Collections.singleton(helper.readItem(buffer, session)));
        return new CraftingData(type, -1, -1, inputId, inputDamage, null, (List)output, null, null);
    }

    protected void writeFurnaceRecipe(ByteBuf buffer, BedrockPacketHelper helper, CraftingData data, BedrockSession session) {
        VarInts.writeInt((ByteBuf)buffer, (int)data.getInputId());
        if (data.getType() == CraftingDataType.FURNACE_DATA) {
            VarInts.writeInt((ByteBuf)buffer, (int)data.getInputDamage());
        }
        helper.writeItem(buffer, (ItemData)data.getOutputs().get(0), session);
    }

    protected CraftingData readMultiRecipe(ByteBuf buffer, BedrockPacketHelper helper, CraftingDataType type) {
        UUID uuid = helper.readUuid(buffer);
        return CraftingData.fromMulti((UUID)uuid);
    }

    protected void writeMultiRecipe(ByteBuf buffer, BedrockPacketHelper helper, CraftingData data) {
        helper.writeUuid(buffer, data.getUuid());
    }

    protected CraftingDataSerializer_v291() {
    }
}

