/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.data.inventory;

import com.nukkitx.protocol.bedrock.data.inventory.stackrequestactions.StackRequestActionData;
import java.util.Arrays;

public final class ItemStackRequest {
    private final int requestId;
    private final StackRequestActionData[] actions;
    private final String[] filterStrings;

    public ItemStackRequest(int requestId, StackRequestActionData[] actions, String[] filterStrings) {
        this.requestId = requestId;
        this.actions = actions;
        this.filterStrings = filterStrings;
    }

    public int getRequestId() {
        return this.requestId;
    }

    public StackRequestActionData[] getActions() {
        return this.actions;
    }

    public String[] getFilterStrings() {
        return this.filterStrings;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ItemStackRequest)) {
            return false;
        }
        ItemStackRequest other = (ItemStackRequest)o;
        if (this.getRequestId() != other.getRequestId()) {
            return false;
        }
        if (!Arrays.deepEquals(this.getActions(), other.getActions())) {
            return false;
        }
        return Arrays.deepEquals(this.getFilterStrings(), other.getFilterStrings());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getRequestId();
        result = result * 59 + Arrays.deepHashCode(this.getActions());
        result = result * 59 + Arrays.deepHashCode(this.getFilterStrings());
        return result;
    }

    public String toString() {
        return "ItemStackRequest(requestId=" + this.getRequestId() + ", actions=" + Arrays.deepToString(this.getActions()) + ", filterStrings=" + Arrays.deepToString(this.getFilterStrings()) + ")";
    }
}

