/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.data.command;

import com.nukkitx.protocol.bedrock.data.command.CommandEnumData;
import com.nukkitx.protocol.bedrock.data.command.CommandParamData;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public final class CommandData {
    private final String name;
    private final String description;
    private final List<Flag> flags;
    private final int permission;
    private final CommandEnumData aliases;
    private final CommandParamData[][] overloads;

    public String toString() {
        StringBuilder overloads = new StringBuilder("[\r\n");
        for (CommandParamData[] overload : this.overloads) {
            overloads.append("    [\r\n");
            for (CommandParamData parameter : overload) {
                overloads.append("       ").append(parameter).append("\r\n");
            }
            overloads.append("    ]\r\n");
        }
        overloads.append("]\r\n");
        StringBuilder builder = new StringBuilder("CommandData(\r\n");
        List<String> objects = Arrays.asList("name=" + this.name, "description=" + this.description, "flags=" + Arrays.toString(this.flags.toArray()), "permission=" + this.permission, "aliases=" + this.aliases, "overloads=" + overloads);
        for (String object : objects) {
            builder.append("    ").append(Objects.toString(object).replaceAll("\r\n", "\r\n    ")).append("\r\n");
        }
        return builder.append(")").toString();
    }

    public CommandData(String name, String description, List<Flag> flags, int permission, CommandEnumData aliases, CommandParamData[][] overloads) {
        this.name = name;
        this.description = description;
        this.flags = flags;
        this.permission = permission;
        this.aliases = aliases;
        this.overloads = overloads;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<Flag> getFlags() {
        return this.flags;
    }

    public int getPermission() {
        return this.permission;
    }

    public CommandEnumData getAliases() {
        return this.aliases;
    }

    public CommandParamData[][] getOverloads() {
        return this.overloads;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommandData)) {
            return false;
        }
        CommandData other = (CommandData)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List<Flag> this$flags = this.getFlags();
        List<Flag> other$flags = other.getFlags();
        if (this$flags == null ? other$flags != null : !((Object)this$flags).equals(other$flags)) {
            return false;
        }
        if (this.getPermission() != other.getPermission()) {
            return false;
        }
        CommandEnumData this$aliases = this.getAliases();
        CommandEnumData other$aliases = other.getAliases();
        if (this$aliases == null ? other$aliases != null : !((Object)this$aliases).equals(other$aliases)) {
            return false;
        }
        return Arrays.deepEquals((Object[])this.getOverloads(), (Object[])other.getOverloads());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List<Flag> $flags = this.getFlags();
        result = result * 59 + ($flags == null ? 43 : ((Object)$flags).hashCode());
        result = result * 59 + this.getPermission();
        CommandEnumData $aliases = this.getAliases();
        result = result * 59 + ($aliases == null ? 43 : ((Object)$aliases).hashCode());
        result = result * 59 + Arrays.deepHashCode((Object[])this.getOverloads());
        return result;
    }

    public static enum Flag {
        USAGE,
        VISIBILITY,
        SYNC,
        EXECUTE,
        TYPE,
        CHEAT,
        UNKNOWN_6;

    }

    public static final class Builder {
        private final String name;
        private final String description;
        private final int flags;
        private final int permission;
        private final int aliases;
        private final CommandParamData.Builder[][] overloads;

        public Builder(String name, String description, int flags, int permission, int aliases, CommandParamData.Builder[][] overloads) {
            this.name = name;
            this.description = description;
            this.flags = flags;
            this.permission = permission;
            this.aliases = aliases;
            this.overloads = overloads;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public int getFlags() {
            return this.flags;
        }

        public int getPermission() {
            return this.permission;
        }

        public int getAliases() {
            return this.aliases;
        }

        public CommandParamData.Builder[][] getOverloads() {
            return this.overloads;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Builder)) {
                return false;
            }
            Builder other = (Builder)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            if (this.getFlags() != other.getFlags()) {
                return false;
            }
            if (this.getPermission() != other.getPermission()) {
                return false;
            }
            if (this.getAliases() != other.getAliases()) {
                return false;
            }
            return Arrays.deepEquals((Object[])this.getOverloads(), (Object[])other.getOverloads());
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            result = result * 59 + this.getFlags();
            result = result * 59 + this.getPermission();
            result = result * 59 + this.getAliases();
            result = result * 59 + Arrays.deepHashCode((Object[])this.getOverloads());
            return result;
        }

        public String toString() {
            return "CommandData.Builder(name=" + this.getName() + ", description=" + this.getDescription() + ", flags=" + this.getFlags() + ", permission=" + this.getPermission() + ", aliases=" + this.getAliases() + ", overloads=" + Arrays.deepToString((Object[])this.getOverloads()) + ")";
        }
    }
}

