/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.internal.ui.transaction;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentViewModelLazyKt;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStore;
import androidx.lifecycle.viewmodel.CreationExtras;
import com.chuckerteam.chucker.R;
import com.chuckerteam.chucker.databinding.ChuckerFragmentTransactionOverviewBinding;
import com.chuckerteam.chucker.internal.data.entity.HttpTransaction;
import com.chuckerteam.chucker.internal.support.LiveDataUtilsKt;
import com.chuckerteam.chucker.internal.ui.transaction.TransactionViewModel;
import com.chuckerteam.chucker.internal.ui.transaction.TransactionViewModelFactory;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J&\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0018\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u0019H\u0016J\u001a\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u00112\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u001a\u0010\u001c\u001a\u00020\r2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionOverviewFragment;", "Landroidx/fragment/app/Fragment;", "<init>", "()V", "viewModel", "Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionViewModel;", "getViewModel", "()Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionViewModel;", "viewModel$delegate", "Lkotlin/Lazy;", "overviewBinding", "Lcom/chuckerteam/chucker/databinding/ChuckerFragmentTransactionOverviewBinding;", "onCreate", "", "savedInstanceState", "Landroid/os/Bundle;", "onCreateView", "Landroid/view/View;", "inflater", "Landroid/view/LayoutInflater;", "container", "Landroid/view/ViewGroup;", "onCreateOptionsMenu", "menu", "Landroid/view/Menu;", "Landroid/view/MenuInflater;", "onViewCreated", "view", "populateUI", "transaction", "Lcom/chuckerteam/chucker/internal/data/entity/HttpTransaction;", "encodeUrl", "", "com.github.ChuckerTeam.Chucker.library"})
@SourceDebugExtension(value={"SMAP\nTransactionOverviewFragment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransactionOverviewFragment.kt\ncom/chuckerteam/chucker/internal/ui/transaction/TransactionOverviewFragment\n+ 2 FragmentViewModelLazy.kt\nandroidx/fragment/app/FragmentViewModelLazyKt\n*L\n1#1,101:1\n172#2,9:102\n*S KotlinDebug\n*F\n+ 1 TransactionOverviewFragment.kt\ncom/chuckerteam/chucker/internal/ui/transaction/TransactionOverviewFragment\n*L\n18#1:102,9\n*E\n"})
public final class TransactionOverviewFragment
extends Fragment {
    @NotNull
    private final Lazy viewModel$delegate;
    private ChuckerFragmentTransactionOverviewBinding overviewBinding;

    /*
     * WARNING - void declaration
     */
    public TransactionOverviewFragment() {
        void $this$activityViewModels_u24default$iv;
        Fragment fragment = this;
        Function0 factoryProducer$iv = TransactionOverviewFragment::viewModel_delegate$lambda$0;
        Function0 extrasProducer$iv = null;
        boolean $i$f$activityViewModels = false;
        KClass kClass = Reflection.getOrCreateKotlinClass(TransactionViewModel.class);
        Function0 function0 = (Function0)new Function0<ViewModelStore>((Fragment)$this$activityViewModels_u24default$iv){
            final /* synthetic */ Fragment $this_activityViewModels;
            {
                this.$this_activityViewModels = $receiver;
                super(0);
            }

            @NotNull
            public final ViewModelStore invoke() {
                return this.$this_activityViewModels.requireActivity().getViewModelStore();
            }
        };
        Function0 function02 = (Function0)new Function0<CreationExtras>(extrasProducer$iv, (Fragment)$this$activityViewModels_u24default$iv){
            final /* synthetic */ Function0 $extrasProducer;
            final /* synthetic */ Fragment $this_activityViewModels;
            {
                this.$extrasProducer = $extrasProducer;
                this.$this_activityViewModels = $receiver;
                super(0);
            }

            @NotNull
            public final CreationExtras invoke() {
                Function0 function0 = this.$extrasProducer;
                if (function0 == null || (function0 = (CreationExtras)function0.invoke()) == null) {
                    function0 = this.$this_activityViewModels.requireActivity().getDefaultViewModelCreationExtras();
                }
                return function0;
            }
        };
        Function0 function03 = factoryProducer$iv;
        if (function03 == null) {
            function03 = (Function0)new Function0<ViewModelProvider.Factory>((Fragment)$this$activityViewModels_u24default$iv){
                final /* synthetic */ Fragment $this_activityViewModels;
                {
                    this.$this_activityViewModels = $receiver;
                    super(0);
                }

                @NotNull
                public final ViewModelProvider.Factory invoke() {
                    return this.$this_activityViewModels.requireActivity().getDefaultViewModelProviderFactory();
                }
            };
        }
        this.viewModel$delegate = FragmentViewModelLazyKt.createViewModelLazy((Fragment)$this$activityViewModels_u24default$iv, (KClass)kClass, (Function0)function0, (Function0)function02, (Function0)function03);
    }

    private final TransactionViewModel getViewModel() {
        Lazy lazy = this.viewModel$delegate;
        return (TransactionViewModel)((Object)lazy.getValue());
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setHasOptionsMenu(true);
    }

    @Nullable
    public View onCreateView(@NotNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)inflater, (String)"inflater");
        ChuckerFragmentTransactionOverviewBinding chuckerFragmentTransactionOverviewBinding = ChuckerFragmentTransactionOverviewBinding.inflate(inflater, container, false);
        Intrinsics.checkNotNullExpressionValue((Object)chuckerFragmentTransactionOverviewBinding, (String)"inflate(...)");
        this.overviewBinding = chuckerFragmentTransactionOverviewBinding;
        ChuckerFragmentTransactionOverviewBinding chuckerFragmentTransactionOverviewBinding2 = this.overviewBinding;
        if (chuckerFragmentTransactionOverviewBinding2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"overviewBinding");
            chuckerFragmentTransactionOverviewBinding2 = null;
        }
        return (View)chuckerFragmentTransactionOverviewBinding2.getRoot();
    }

    public void onCreateOptionsMenu(@NotNull Menu menu2, @NotNull MenuInflater inflater) {
        Intrinsics.checkNotNullParameter((Object)menu2, (String)"menu");
        Intrinsics.checkNotNullParameter((Object)inflater, (String)"inflater");
        menu2.findItem(R.id.save_body).setVisible(false);
        this.getViewModel().getDoesUrlRequireEncoding().observe(this.getViewLifecycleOwner(), arg_0 -> TransactionOverviewFragment.onCreateOptionsMenu$lambda$0(menu2, arg_0));
        super.onCreateOptionsMenu(menu2, inflater);
    }

    public void onViewCreated(@NotNull View view, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        super.onViewCreated(view, savedInstanceState);
        LiveDataUtilsKt.combineLatest(this.getViewModel().getTransaction(), this.getViewModel().getEncodeUrl()).observe(this.getViewLifecycleOwner(), arg_0 -> TransactionOverviewFragment.onViewCreated$lambda$0(this, arg_0));
    }

    private final void populateUI(HttpTransaction transaction, boolean encodeUrl) {
        Boolean bl;
        ChuckerFragmentTransactionOverviewBinding chuckerFragmentTransactionOverviewBinding = this.overviewBinding;
        if (chuckerFragmentTransactionOverviewBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"overviewBinding");
            chuckerFragmentTransactionOverviewBinding = null;
        }
        ChuckerFragmentTransactionOverviewBinding $this$populateUI_u24lambda_u240 = chuckerFragmentTransactionOverviewBinding;
        boolean bl2 = false;
        HttpTransaction httpTransaction = transaction;
        $this$populateUI_u24lambda_u240.url.setText((CharSequence)(httpTransaction != null ? httpTransaction.getFormattedUrl(encodeUrl) : null));
        HttpTransaction httpTransaction2 = transaction;
        $this$populateUI_u24lambda_u240.method.setText((CharSequence)(httpTransaction2 != null ? httpTransaction2.getMethod() : null));
        HttpTransaction httpTransaction3 = transaction;
        $this$populateUI_u24lambda_u240.protocol.setText((CharSequence)(httpTransaction3 != null ? httpTransaction3.getProtocol() : null));
        HttpTransaction httpTransaction4 = transaction;
        $this$populateUI_u24lambda_u240.status.setText((CharSequence)String.valueOf((Object)(httpTransaction4 != null ? httpTransaction4.getStatus() : null)));
        HttpTransaction httpTransaction5 = transaction;
        $this$populateUI_u24lambda_u240.response.setText((CharSequence)(httpTransaction5 != null ? httpTransaction5.getResponseSummaryText() : null));
        HttpTransaction httpTransaction6 = transaction;
        Boolean bl3 = bl = httpTransaction6 != null ? Boolean.valueOf(httpTransaction6.isSsl()) : null;
        if (bl == null) {
            $this$populateUI_u24lambda_u240.sslGroup.setVisibility(8);
        } else if (Intrinsics.areEqual((Object)bl, (Object)true)) {
            $this$populateUI_u24lambda_u240.sslGroup.setVisibility(0);
            $this$populateUI_u24lambda_u240.sslValue.setText(R.string.chucker_yes);
        } else {
            $this$populateUI_u24lambda_u240.sslGroup.setVisibility(0);
            $this$populateUI_u24lambda_u240.sslValue.setText(R.string.chucker_no);
        }
        HttpTransaction httpTransaction7 = transaction;
        if ((httpTransaction7 != null ? httpTransaction7.getResponseTlsVersion() : null) != null) {
            $this$populateUI_u24lambda_u240.tlsVersionValue.setText((CharSequence)transaction.getResponseTlsVersion());
            $this$populateUI_u24lambda_u240.tlsGroup.setVisibility(0);
        }
        HttpTransaction httpTransaction8 = transaction;
        if ((httpTransaction8 != null ? httpTransaction8.getResponseCipherSuite() : null) != null) {
            $this$populateUI_u24lambda_u240.cipherSuiteValue.setText((CharSequence)transaction.getResponseCipherSuite());
            $this$populateUI_u24lambda_u240.cipherSuiteGroup.setVisibility(0);
        }
        HttpTransaction httpTransaction9 = transaction;
        $this$populateUI_u24lambda_u240.requestTime.setText((CharSequence)(httpTransaction9 != null ? httpTransaction9.getRequestDateString() : null));
        HttpTransaction httpTransaction10 = transaction;
        $this$populateUI_u24lambda_u240.responseTime.setText((CharSequence)(httpTransaction10 != null ? httpTransaction10.getResponseDateString() : null));
        HttpTransaction httpTransaction11 = transaction;
        $this$populateUI_u24lambda_u240.duration.setText((CharSequence)(httpTransaction11 != null ? httpTransaction11.getDurationString() : null));
        HttpTransaction httpTransaction12 = transaction;
        $this$populateUI_u24lambda_u240.requestSize.setText((CharSequence)(httpTransaction12 != null ? httpTransaction12.getRequestSizeString() : null));
        HttpTransaction httpTransaction13 = transaction;
        $this$populateUI_u24lambda_u240.responseSize.setText((CharSequence)(httpTransaction13 != null ? httpTransaction13.getResponseSizeString() : null));
        HttpTransaction httpTransaction14 = transaction;
        $this$populateUI_u24lambda_u240.totalSize.setText((CharSequence)(httpTransaction14 != null ? httpTransaction14.getTotalSizeString() : null));
    }

    private static final ViewModelProvider.Factory viewModel_delegate$lambda$0() {
        return (ViewModelProvider.Factory)new TransactionViewModelFactory(0L, 1, null);
    }

    private static final void onCreateOptionsMenu$lambda$0(Menu $menu, Boolean it) {
        MenuItem menuItem = $menu.findItem(R.id.encode_url);
        Intrinsics.checkNotNull((Object)it);
        menuItem.setVisible(it.booleanValue());
    }

    private static final void onViewCreated$lambda$0(TransactionOverviewFragment this$0, Pair pair) {
        HttpTransaction transaction = (HttpTransaction)pair.component1();
        boolean encodeUrl = (Boolean)pair.component2();
        this$0.populateUI(transaction, encodeUrl);
    }
}

