/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.internal.ui.transaction;

import android.content.Context;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import androidx.recyclerview.widget.RecyclerView;
import com.chuckerteam.chucker.databinding.ChuckerTransactionItemBodyLineBinding;
import com.chuckerteam.chucker.databinding.ChuckerTransactionItemCopyBinding;
import com.chuckerteam.chucker.databinding.ChuckerTransactionItemHeadersBinding;
import com.chuckerteam.chucker.databinding.ChuckerTransactionItemImageBinding;
import com.chuckerteam.chucker.internal.support.SearchHighlightUtilKt;
import com.chuckerteam.chucker.internal.support.SpanTextUtil;
import com.chuckerteam.chucker.internal.ui.transaction.TransactionPayloadItem;
import com.chuckerteam.chucker.internal.ui.transaction.TransactionPayloadViewHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 (2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002()B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\f\u001a\u00020\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eJ\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0012H\u0016J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J+\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u001fJ5\u0010 \u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b#J\r\u0010$\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b%J\f\u0010&\u001a\u00020\u0012*\u00020'H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionBodyAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionPayloadViewHolder;", "onCopyBodyListener", "Lkotlin/Function0;", "", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "items", "Ljava/util/ArrayList;", "Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionPayloadItem;", "Lkotlin/collections/ArrayList;", "setItems", "bodyItems", "", "onBindViewHolder", "holder", "position", "", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "getItemCount", "getItemViewType", "highlightQueryWithColors", "Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionBodyAdapter$SearchItemBodyLine;", "newText", "", "backgroundColor", "foregroundColor", "highlightQueryWithColors$com_github_ChuckerTeam_Chucker_library", "highlightItemWithColorOnPosition", "queryStartPosition", "queryText", "highlightItemWithColorOnPosition$com_github_ChuckerTeam_Chucker_library", "resetHighlight", "resetHighlight$com_github_ChuckerTeam_Chucker_library", "clearHighlightSpans", "Landroid/text/SpannableStringBuilder;", "Companion", "SearchItemBodyLine", "com.github.ChuckerTeam.Chucker.library"})
@SourceDebugExtension(value={"SMAP\nTransactionPayloadAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransactionPayloadAdapter.kt\ncom/chuckerteam/chucker/internal/ui/transaction/TransactionBodyAdapter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 SpannedString.kt\nandroidx/core/text/SpannedStringKt\n*L\n1#1,284:1\n1915#2:285\n1915#2,2:286\n1916#2:288\n1915#2,2:289\n34#3:291\n*S KotlinDebug\n*F\n+ 1 TransactionPayloadAdapter.kt\ncom/chuckerteam/chucker/internal/ui/transaction/TransactionBodyAdapter\n*L\n95#1:285\n100#1:286,2\n95#1:288\n153#1:289,2\n175#1:291\n*E\n"})
public final class TransactionBodyAdapter
extends RecyclerView.Adapter<TransactionPayloadViewHolder> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function0<Unit> onCopyBodyListener;
    @NotNull
    private final ArrayList<TransactionPayloadItem> items;
    private static final int TYPE_HEADERS = 1;
    private static final int TYPE_BODY_LINE = 2;
    private static final int TYPE_IMAGE = 3;
    private static final int TYPE_COPY = 4;

    public TransactionBodyAdapter(@NotNull Function0<Unit> onCopyBodyListener) {
        Intrinsics.checkNotNullParameter(onCopyBodyListener, (String)"onCopyBodyListener");
        this.onCopyBodyListener = onCopyBodyListener;
        this.items = new ArrayList();
    }

    public final void setItems(@NotNull List<? extends TransactionPayloadItem> bodyItems) {
        Intrinsics.checkNotNullParameter(bodyItems, (String)"bodyItems");
        int previousItemCount = this.items.size();
        this.items.clear();
        this.items.addAll((Collection<TransactionPayloadItem>)bodyItems);
        this.notifyItemRangeRemoved(0, previousItemCount);
        this.notifyItemRangeInserted(0, this.items.size());
    }

    public void onBindViewHolder(@NotNull TransactionPayloadViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        TransactionPayloadItem transactionPayloadItem = this.items.get(position);
        Intrinsics.checkNotNullExpressionValue((Object)transactionPayloadItem, (String)"get(...)");
        holder.bind(transactionPayloadItem);
    }

    @NotNull
    public TransactionPayloadViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
        return switch (viewType) {
            case 1 -> {
                ChuckerTransactionItemHeadersBinding v0 = ChuckerTransactionItemHeadersBinding.inflate(inflater, parent, false);
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"inflate(...)");
                ChuckerTransactionItemHeadersBinding headersItemBinding = v0;
                yield new TransactionPayloadViewHolder.HeaderViewHolder(headersItemBinding);
            }
            case 2 -> {
                ChuckerTransactionItemBodyLineBinding v2 = ChuckerTransactionItemBodyLineBinding.inflate(inflater, parent, false);
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"inflate(...)");
                ChuckerTransactionItemBodyLineBinding bodyItemBinding = v2;
                yield new TransactionPayloadViewHolder.BodyLineViewHolder(bodyItemBinding);
            }
            case 4 -> {
                ChuckerTransactionItemCopyBinding v3 = ChuckerTransactionItemCopyBinding.inflate(inflater, parent, false);
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"inflate(...)");
                ChuckerTransactionItemCopyBinding copyItemBinding = v3;
                yield new TransactionPayloadViewHolder.CopyViewHolder(copyItemBinding, this.onCopyBodyListener);
            }
            default -> {
                ChuckerTransactionItemImageBinding v4 = ChuckerTransactionItemImageBinding.inflate(inflater, parent, false);
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"inflate(...)");
                ChuckerTransactionItemImageBinding imageItemBinding = v4;
                yield new TransactionPayloadViewHolder.ImageViewHolder(imageItemBinding);
            }
        };
    }

    public int getItemCount() {
        return this.items.size();
    }

    public int getItemViewType(int position) {
        int n;
        TransactionPayloadItem transactionPayloadItem = this.items.get(position);
        if (transactionPayloadItem instanceof TransactionPayloadItem.HeaderItem) {
            n = 1;
        } else if (transactionPayloadItem instanceof TransactionPayloadItem.BodyLineItem) {
            n = 2;
        } else if (transactionPayloadItem instanceof TransactionPayloadItem.ImageItem) {
            n = 3;
        } else if (transactionPayloadItem instanceof TransactionPayloadItem.CopyItem) {
            n = 4;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<SearchItemBodyLine> highlightQueryWithColors$com_github_ChuckerTeam_Chucker_library(@NotNull String newText, int backgroundColor, int foregroundColor) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
        ArrayList<SearchItemBodyLine> listOfSearchItems = new ArrayList<SearchItemBodyLine>();
        Iterable iterable = CollectionsKt.withIndex((Iterable)this.items);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IndexedValue indexedValue = (IndexedValue)element$iv;
            boolean bl = false;
            int index = indexedValue.component1();
            TransactionPayloadItem item = (TransactionPayloadItem)indexedValue.component2();
            if (!(item instanceof TransactionPayloadItem.BodyLineItem)) continue;
            List<Integer> listOfOccurrences = SearchHighlightUtilKt.indicesOf((CharSequence)((TransactionPayloadItem.BodyLineItem)item).getLine(), newText);
            if (!((Collection)listOfOccurrences).isEmpty()) {
                Iterable $this$forEach$iv2 = listOfOccurrences;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    int it = ((Number)element$iv2).intValue();
                    boolean bl2 = false;
                    listOfSearchItems.add(new SearchItemBodyLine(index, it));
                }
                this.clearHighlightSpans(((TransactionPayloadItem.BodyLineItem)item).getLine());
                ((TransactionPayloadItem.BodyLineItem)item).setLine(SearchHighlightUtilKt.highlightWithDefinedColors(((TransactionPayloadItem.BodyLineItem)item).getLine(), newText, listOfOccurrences, backgroundColor, foregroundColor));
                this.notifyItemChanged(index);
                continue;
            }
            int removedSpansCount = this.clearHighlightSpans(((TransactionPayloadItem.BodyLineItem)item).getLine());
            if (removedSpansCount <= 0) continue;
            this.notifyItemChanged(index);
        }
        return listOfSearchItems;
    }

    public final void highlightItemWithColorOnPosition$com_github_ChuckerTeam_Chucker_library(int position, int queryStartPosition, @NotNull String queryText, int backgroundColor, int foregroundColor) {
        TransactionPayloadItem.BodyLineItem item;
        Intrinsics.checkNotNullParameter((Object)queryText, (String)"queryText");
        Object object = CollectionsKt.getOrNull((List)this.items, (int)position);
        TransactionPayloadItem.BodyLineItem bodyLineItem = item = object instanceof TransactionPayloadItem.BodyLineItem ? (TransactionPayloadItem.BodyLineItem)object : null;
        if (item != null) {
            item.setLine(SearchHighlightUtilKt.highlightWithDefinedColorsSubstring(item.getLine(), queryText, queryStartPosition, backgroundColor, foregroundColor));
            this.notifyItemChanged(position);
        }
    }

    public final void resetHighlight$com_github_ChuckerTeam_Chucker_library() {
        Iterable $this$forEach$iv = CollectionsKt.withIndex((Iterable)this.items);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int removedSpansCount;
            IndexedValue indexedValue = (IndexedValue)element$iv;
            boolean bl = false;
            int index = indexedValue.component1();
            TransactionPayloadItem item = (TransactionPayloadItem)indexedValue.component2();
            if (!(item instanceof TransactionPayloadItem.BodyLineItem) || (removedSpansCount = this.clearHighlightSpans(((TransactionPayloadItem.BodyLineItem)item).getLine())) <= 0) continue;
            this.notifyItemChanged(index);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int clearHighlightSpans(SpannableStringBuilder $this$clearHighlightSpans) {
        void start$iv;
        void $this$getSpans$iv;
        int removedSpansCount = 0;
        Spanned spanned = (Spanned)$this$clearHighlightSpans;
        int n = 0;
        int end$iv = $this$clearHighlightSpans.length();
        boolean $i$f$getSpans = false;
        for (Object span : $this$getSpans$iv.getSpans((int)start$iv, end$iv, Object.class)) {
            if (span instanceof SpanTextUtil.ChuckerForegroundColorSpan) continue;
            $this$clearHighlightSpans.removeSpan(span);
            ++removedSpansCount;
        }
        return removedSpansCount;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionBodyAdapter$Companion;", "", "<init>", "()V", "TYPE_HEADERS", "", "TYPE_BODY_LINE", "TYPE_IMAGE", "TYPE_COPY", "com.github.ChuckerTeam.Chucker.library"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0010\u001a\u00020\u0003H\u00d6\u0081\u0004J\n\u0010\u0011\u001a\u00020\u0012H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionBodyAdapter$SearchItemBodyLine;", "", "indexBodyLine", "", "indexStartOfQuerySubString", "<init>", "(II)V", "getIndexBodyLine", "()I", "getIndexStartOfQuerySubString", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "com.github.ChuckerTeam.Chucker.library"})
    public static final class SearchItemBodyLine {
        private final int indexBodyLine;
        private final int indexStartOfQuerySubString;

        public SearchItemBodyLine(int indexBodyLine, int indexStartOfQuerySubString) {
            this.indexBodyLine = indexBodyLine;
            this.indexStartOfQuerySubString = indexStartOfQuerySubString;
        }

        public final int getIndexBodyLine() {
            return this.indexBodyLine;
        }

        public final int getIndexStartOfQuerySubString() {
            return this.indexStartOfQuerySubString;
        }

        public final int component1() {
            return this.indexBodyLine;
        }

        public final int component2() {
            return this.indexStartOfQuerySubString;
        }

        @NotNull
        public final SearchItemBodyLine copy(int indexBodyLine, int indexStartOfQuerySubString) {
            return new SearchItemBodyLine(indexBodyLine, indexStartOfQuerySubString);
        }

        public static /* synthetic */ SearchItemBodyLine copy$default(SearchItemBodyLine searchItemBodyLine, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = searchItemBodyLine.indexBodyLine;
            }
            if ((n3 & 2) != 0) {
                n2 = searchItemBodyLine.indexStartOfQuerySubString;
            }
            return searchItemBodyLine.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "SearchItemBodyLine(indexBodyLine=" + this.indexBodyLine + ", indexStartOfQuerySubString=" + this.indexStartOfQuerySubString + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.indexBodyLine);
            result = result * 31 + Integer.hashCode(this.indexStartOfQuerySubString);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SearchItemBodyLine)) {
                return false;
            }
            SearchItemBodyLine searchItemBodyLine = (SearchItemBodyLine)other;
            if (this.indexBodyLine != searchItemBodyLine.indexBodyLine) {
                return false;
            }
            return this.indexStartOfQuerySubString == searchItemBodyLine.indexStartOfQuerySubString;
        }
    }
}

