/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.internal.support;

import android.content.Context;
import com.chuckerteam.chucker.R;
import com.chuckerteam.chucker.internal.data.entity.HttpTransaction;
import com.chuckerteam.chucker.internal.support.FormatUtils;
import com.chuckerteam.chucker.internal.support.Sharable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.Buffer;
import okio.Source;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/chuckerteam/chucker/internal/support/TransactionDetailsSharable;", "Lcom/chuckerteam/chucker/internal/support/Sharable;", "transaction", "Lcom/chuckerteam/chucker/internal/data/entity/HttpTransaction;", "encodeUrls", "", "<init>", "(Lcom/chuckerteam/chucker/internal/data/entity/HttpTransaction;Z)V", "toSharableContent", "Lokio/Source;", "context", "Landroid/content/Context;", "com.github.ChuckerTeam.Chucker.library"})
public final class TransactionDetailsSharable
implements Sharable {
    @NotNull
    private final HttpTransaction transaction;
    private final boolean encodeUrls;

    public TransactionDetailsSharable(@NotNull HttpTransaction transaction, boolean encodeUrls) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        this.transaction = transaction;
        this.encodeUrls = encodeUrls;
    }

    @Override
    @NotNull
    public Source toSharableContent(@NotNull Context context) {
        String string2;
        CharSequence resId2;
        String string3;
        CharSequence charSequence;
        Buffer buffer;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Buffer $this$toSharableContent_u24lambda_u240 = buffer = new Buffer();
        boolean bl = false;
        $this$toSharableContent_u24lambda_u240.writeUtf8(context.getString(R.string.chucker_url) + ": " + this.transaction.getFormattedUrl(this.encodeUrls) + "\n");
        $this$toSharableContent_u24lambda_u240.writeUtf8(context.getString(R.string.chucker_method) + ": " + this.transaction.getMethod() + "\n");
        $this$toSharableContent_u24lambda_u240.writeUtf8(context.getString(R.string.chucker_protocol) + ": " + this.transaction.getProtocol() + "\n");
        $this$toSharableContent_u24lambda_u240.writeUtf8(context.getString(R.string.chucker_status) + ": " + this.transaction.getStatus() + "\n");
        $this$toSharableContent_u24lambda_u240.writeUtf8(context.getString(R.string.chucker_response) + ": " + this.transaction.getResponseSummaryText() + "\n");
        int isSsl = this.transaction.isSsl() ? R.string.chucker_yes : R.string.chucker_no;
        $this$toSharableContent_u24lambda_u240.writeUtf8(context.getString(R.string.chucker_ssl) + ": " + context.getString(isSsl) + "\n");
        $this$toSharableContent_u24lambda_u240.writeUtf8("\n");
        $this$toSharableContent_u24lambda_u240.writeUtf8(context.getString(R.string.chucker_request_time) + ": " + this.transaction.getRequestDateString() + "\n");
        $this$toSharableContent_u24lambda_u240.writeUtf8(context.getString(R.string.chucker_response_time) + ": " + this.transaction.getResponseDateString() + "\n");
        $this$toSharableContent_u24lambda_u240.writeUtf8(context.getString(R.string.chucker_duration) + ": " + this.transaction.getDurationString() + "\n");
        $this$toSharableContent_u24lambda_u240.writeUtf8("\n");
        $this$toSharableContent_u24lambda_u240.writeUtf8(context.getString(R.string.chucker_request_size) + ": " + this.transaction.getRequestSizeString() + "\n");
        $this$toSharableContent_u24lambda_u240.writeUtf8(context.getString(R.string.chucker_response_size) + ": " + this.transaction.getResponseSizeString() + "\n");
        $this$toSharableContent_u24lambda_u240.writeUtf8(context.getString(R.string.chucker_total_size) + ": " + this.transaction.getTotalSizeString() + "\n");
        $this$toSharableContent_u24lambda_u240.writeUtf8("\n");
        $this$toSharableContent_u24lambda_u240.writeUtf8("---------- " + context.getString(R.string.chucker_request) + " ----------\n\n");
        String headers = FormatUtils.INSTANCE.formatHeaders(this.transaction.getParsedRequestHeaders(), false);
        if (!StringsKt.isBlank((CharSequence)headers)) {
            $this$toSharableContent_u24lambda_u240.writeUtf8(headers);
            $this$toSharableContent_u24lambda_u240.writeUtf8("\n");
        }
        if ((charSequence = (CharSequence)this.transaction.getRequestBody()) == null || StringsKt.isBlank((CharSequence)charSequence)) {
            int resId2 = this.transaction.isResponseBodyEncoded() ? R.string.chucker_body_omitted : R.string.chucker_body_empty;
            string3 = context.getString(resId2);
        } else {
            string3 = this.transaction.getFormattedRequestBody();
        }
        String string4 = string3;
        Intrinsics.checkNotNull((Object)string4);
        $this$toSharableContent_u24lambda_u240.writeUtf8(string4);
        $this$toSharableContent_u24lambda_u240.writeUtf8("\n\n");
        $this$toSharableContent_u24lambda_u240.writeUtf8("---------- " + context.getString(R.string.chucker_response) + " ----------\n\n");
        headers = FormatUtils.INSTANCE.formatHeaders(this.transaction.getParsedResponseHeaders(), false);
        if (!StringsKt.isBlank((CharSequence)headers)) {
            $this$toSharableContent_u24lambda_u240.writeUtf8(headers);
            $this$toSharableContent_u24lambda_u240.writeUtf8("\n");
        }
        if ((resId2 = (CharSequence)this.transaction.getResponseBody()) == null || StringsKt.isBlank((CharSequence)resId2)) {
            int resId3 = this.transaction.isResponseBodyEncoded() ? R.string.chucker_body_omitted : R.string.chucker_body_empty;
            string2 = context.getString(resId3);
        } else {
            string2 = this.transaction.getFormattedResponseBody();
        }
        string4 = string2;
        Intrinsics.checkNotNull((Object)string4);
        $this$toSharableContent_u24lambda_u240.writeUtf8(string4);
        return (Source)buffer;
    }
}

