/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.internal.support;

import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.Headers;
import okhttp3.Response;
import okio.GzipSource;
import okio.Okio;
import okio.Source;
import org.brotli.dec.BrotliInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0000\u001a\f\u0010\u0002\u001a\u00020\u0003*\u00020\u0004H\u0000\u001a\u0014\u0010\u0019\u001a\u00020\u001a*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0010H\u0000\u001a\u001a\u0010\u001c\u001a\u00020\u0010*\u00020\u00102\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\f0\u001eH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0018\u0010\t\u001a\u00020\u0003*\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\"\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\"\u0018\u0010\u000f\u001a\u00020\u0003*\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\"\u0018\u0010\u0013\u001a\u00020\u0003*\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012\"\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0017\u001a\u00020\u0003*\u00020\u00108@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0012\u00a8\u0006\u001f"}, d2={"HTTP_CONTINUE", "", "hasBody", "", "Lokhttp3/Response;", "contentLength", "", "getContentLength", "(Lokhttp3/Response;)J", "isChunked", "(Lokhttp3/Response;)Z", "contentType", "", "getContentType", "(Lokhttp3/Response;)Ljava/lang/String;", "containsGzip", "Lokhttp3/Headers;", "getContainsGzip", "(Lokhttp3/Headers;)Z", "containsBrotli", "getContainsBrotli", "supportedEncodings", "", "hasSupportedContentEncoding", "getHasSupportedContentEncoding", "uncompress", "Lokio/Source;", "headers", "redact", "names", "", "com.github.ChuckerTeam.Chucker.library"})
@SourceDebugExtension(value={"SMAP\nOkHttpUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OkHttpUtils.kt\ncom/chuckerteam/chucker/internal/support/OkHttpUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 GzipSource.kt\nokio/-GzipSourceExtensions\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,87:1\n1#2:88\n221#3:89\n1807#4,3:90\n*S KotlinDebug\n*F\n+ 1 OkHttpUtils.kt\ncom/chuckerteam/chucker/internal/support/OkHttpUtilsKt\n*L\n73#1:89\n81#1:90,3\n*E\n"})
public final class OkHttpUtilsKt {
    private static final int HTTP_CONTINUE = 100;
    @NotNull
    private static final List<String> supportedEncodings;

    public static final boolean hasBody(@NotNull Response $this$hasBody) {
        Intrinsics.checkNotNullParameter((Object)$this$hasBody, (String)"<this>");
        if (Intrinsics.areEqual((Object)$this$hasBody.request().method(), (Object)"HEAD")) {
            return false;
        }
        int responseCode = $this$hasBody.code();
        if ((responseCode < 100 || responseCode >= 200) && responseCode != 204 && responseCode != 304) {
            return true;
        }
        return OkHttpUtilsKt.getContentLength($this$hasBody) > 0L || OkHttpUtilsKt.isChunked($this$hasBody);
    }

    private static final long getContentLength(Response $this$contentLength) {
        Object object = Response.header$default((Response)$this$contentLength, (String)"Content-Length", null, (int)2, null);
        return object != null && (object = StringsKt.toLongOrNull((String)object)) != null ? (Long)object : -1L;
    }

    public static final boolean isChunked(@NotNull Response $this$isChunked) {
        Intrinsics.checkNotNullParameter((Object)$this$isChunked, (String)"<this>");
        return StringsKt.equals((String)Response.header$default((Response)$this$isChunked, (String)"Transfer-Encoding", null, (int)2, null), (String)"chunked", (boolean)true);
    }

    @Nullable
    public static final String getContentType(@NotNull Response $this$contentType) {
        Intrinsics.checkNotNullParameter((Object)$this$contentType, (String)"<this>");
        return Response.header$default((Response)$this$contentType, (String)"Content-Type", null, (int)2, null);
    }

    private static final boolean getContainsGzip(Headers $this$containsGzip) {
        return StringsKt.equals((String)$this$containsGzip.get("Content-Encoding"), (String)"gzip", (boolean)true);
    }

    private static final boolean getContainsBrotli(Headers $this$containsBrotli) {
        return StringsKt.equals((String)$this$containsBrotli.get("Content-Encoding"), (String)"br", (boolean)true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean getHasSupportedContentEncoding(@NotNull Headers $this$hasSupportedContentEncoding) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$hasSupportedContentEncoding, (String)"<this>");
        String string3 = $this$hasSupportedContentEncoding.get("Content-Encoding");
        if (string3 == null) return true;
        String it = string2 = string3;
        boolean bl = false;
        if (((CharSequence)it).length() <= 0) return true;
        boolean bl2 = true;
        if (!bl2) return true;
        String string4 = string2;
        String string5 = string4;
        if (string5 == null) return true;
        String it2 = string5;
        boolean bl3 = false;
        String string6 = it2;
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
        String string7 = string6.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toLowerCase(...)");
        boolean bl4 = supportedEncodings.contains(string7);
        return bl4;
    }

    @NotNull
    public static final Source uncompress(@NotNull Source $this$uncompress, @NotNull Headers headers) {
        Source source;
        Intrinsics.checkNotNullParameter((Object)$this$uncompress, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        if (OkHttpUtilsKt.getContainsGzip(headers)) {
            Source $this$gzip$iv = $this$uncompress;
            boolean $i$f$gzip = false;
            source = (Source)new GzipSource($this$gzip$iv);
        } else {
            source = OkHttpUtilsKt.getContainsBrotli(headers) ? Okio.source((InputStream)((InputStream)new BrotliInputStream(Okio.buffer((Source)$this$uncompress).inputStream()))) : $this$uncompress;
        }
        return source;
    }

    @NotNull
    public static final Headers redact(@NotNull Headers $this$redact, @NotNull Iterable<String> names) {
        Intrinsics.checkNotNullParameter((Object)$this$redact, (String)"<this>");
        Intrinsics.checkNotNullParameter(names, (String)"names");
        Headers.Builder builder = $this$redact.newBuilder();
        for (String name : $this$redact.names()) {
            boolean bl;
            block4: {
                Iterable<String> $this$any$iv = names;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    Iterator<String> iterator = $this$any$iv.iterator();
                    while (iterator.hasNext()) {
                        String element$iv;
                        String userHeader = element$iv = iterator.next();
                        boolean bl2 = false;
                        if (!StringsKt.equals((String)userHeader, (String)name, (boolean)true)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            builder.set(name, "**");
        }
        return builder.build();
    }

    static {
        Object[] objectArray = new String[]{"identity", "gzip", "br"};
        supportedEncodings = CollectionsKt.listOf((Object[])objectArray);
    }
}

