/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.internal.data.room;

import androidx.lifecycle.LiveData;
import androidx.room.EntityDeleteOrUpdateAdapter;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteConnectionUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.SQLiteConnection;
import androidx.sqlite.SQLiteStatement;
import com.chuckerteam.chucker.internal.data.entity.HttpTransaction;
import com.chuckerteam.chucker.internal.data.entity.HttpTransactionTuple;
import com.chuckerteam.chucker.internal.data.room.HttpTransactionDao;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 )2\u00020\u0001:\u0001)B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\bH\u0096@\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\bH\u0096@\u00a2\u0006\u0002\u0010\u000eJ\u0014\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u0012H\u0016J,\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0017H\u0016J\u0018\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00122\u0006\u0010\u001b\u001a\u00020\fH\u0016J\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\b0\u0013H\u0096@\u00a2\u0006\u0002\u0010\u001dJ\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\b0\u00132\u0006\u0010\u001f\u001a\u00020\fH\u0016J\"\u0010 \u001a\b\u0012\u0004\u0012\u00020\b0\u00132\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\f0\u0013H\u0096@\u00a2\u0006\u0002\u0010\"J\u000e\u0010#\u001a\u00020\u0010H\u0096@\u00a2\u0006\u0002\u0010\u001dJ\u0016\u0010$\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\fH\u0096@\u00a2\u0006\u0002\u0010&J\u001c\u0010'\u001a\u00020(2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\f0\u0013H\u0096@\u00a2\u0006\u0002\u0010\"R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/chuckerteam/chucker/internal/data/room/HttpTransactionDao_Impl;", "Lcom/chuckerteam/chucker/internal/data/room/HttpTransactionDao;", "__db", "Landroidx/room/RoomDatabase;", "<init>", "(Landroidx/room/RoomDatabase;)V", "__insertAdapterOfHttpTransaction", "Landroidx/room/EntityInsertAdapter;", "Lcom/chuckerteam/chucker/internal/data/entity/HttpTransaction;", "__updateAdapterOfHttpTransaction", "Landroidx/room/EntityDeleteOrUpdateAdapter;", "insert", "", "transaction", "(Lcom/chuckerteam/chucker/internal/data/entity/HttpTransaction;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "update", "", "getSortedTuples", "Landroidx/lifecycle/LiveData;", "", "Lcom/chuckerteam/chucker/internal/data/entity/HttpTransactionTuple;", "getFilteredTuples", "codeQuery", "", "pathQuery", "graphQlQuery", "getById", "id", "getAll", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getTransactionsInTimeRange", "timestamp", "getSelectedTransactions", "selectedTransactions", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "deleteAll", "deleteBefore", "threshold", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "deleteSelected", "", "Companion", "com.github.ChuckerTeam.Chucker.library"})
public final class HttpTransactionDao_Impl
implements HttpTransactionDao {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RoomDatabase __db;
    @NotNull
    private final EntityInsertAdapter<HttpTransaction> __insertAdapterOfHttpTransaction;
    @NotNull
    private final EntityDeleteOrUpdateAdapter<HttpTransaction> __updateAdapterOfHttpTransaction;

    public HttpTransactionDao_Impl(@NotNull RoomDatabase __db) {
        Intrinsics.checkNotNullParameter((Object)__db, (String)"__db");
        this.__db = __db;
        this.__insertAdapterOfHttpTransaction = (EntityInsertAdapter)new EntityInsertAdapter<HttpTransaction>(){

            protected String createQuery() {
                return "INSERT OR ABORT INTO `transactions` (`id`,`requestDate`,`responseDate`,`tookMs`,`protocol`,`method`,`url`,`host`,`path`,`scheme`,`responseTlsVersion`,`responseCipherSuite`,`requestPayloadSize`,`requestContentType`,`requestHeaders`,`requestHeadersSize`,`requestBody`,`isRequestBodyEncoded`,`responseCode`,`responseMessage`,`error`,`responsePayloadSize`,`responseContentType`,`responseHeaders`,`responseHeadersSize`,`responseBody`,`isResponseBodyEncoded`,`responseImageData`,`graphQlDetected`,`graphQlOperationName`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(SQLiteStatement statement, HttpTransaction entity) {
                Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                statement.bindLong(1, entity.getId());
                Long _tmpRequestDate = entity.getRequestDate();
                if (_tmpRequestDate == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindLong(2, _tmpRequestDate.longValue());
                }
                Long _tmpResponseDate = entity.getResponseDate();
                if (_tmpResponseDate == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindLong(3, _tmpResponseDate.longValue());
                }
                Long _tmpTookMs = entity.getTookMs();
                if (_tmpTookMs == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindLong(4, _tmpTookMs.longValue());
                }
                String _tmpProtocol = entity.getProtocol();
                if (_tmpProtocol == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmpProtocol);
                }
                String _tmpMethod = entity.getMethod();
                if (_tmpMethod == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmpMethod);
                }
                String _tmpUrl = entity.getUrl();
                if (_tmpUrl == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, _tmpUrl);
                }
                String _tmpHost = entity.getHost();
                if (_tmpHost == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, _tmpHost);
                }
                String _tmpPath = entity.getPath();
                if (_tmpPath == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindText(9, _tmpPath);
                }
                String _tmpScheme = entity.getScheme();
                if (_tmpScheme == null) {
                    statement.bindNull(10);
                } else {
                    statement.bindText(10, _tmpScheme);
                }
                String _tmpResponseTlsVersion = entity.getResponseTlsVersion();
                if (_tmpResponseTlsVersion == null) {
                    statement.bindNull(11);
                } else {
                    statement.bindText(11, _tmpResponseTlsVersion);
                }
                String _tmpResponseCipherSuite = entity.getResponseCipherSuite();
                if (_tmpResponseCipherSuite == null) {
                    statement.bindNull(12);
                } else {
                    statement.bindText(12, _tmpResponseCipherSuite);
                }
                Long _tmpRequestPayloadSize = entity.getRequestPayloadSize();
                if (_tmpRequestPayloadSize == null) {
                    statement.bindNull(13);
                } else {
                    statement.bindLong(13, _tmpRequestPayloadSize.longValue());
                }
                String _tmpRequestContentType = entity.getRequestContentType();
                if (_tmpRequestContentType == null) {
                    statement.bindNull(14);
                } else {
                    statement.bindText(14, _tmpRequestContentType);
                }
                String _tmpRequestHeaders = entity.getRequestHeaders();
                if (_tmpRequestHeaders == null) {
                    statement.bindNull(15);
                } else {
                    statement.bindText(15, _tmpRequestHeaders);
                }
                Long _tmpRequestHeadersSize = entity.getRequestHeadersSize();
                if (_tmpRequestHeadersSize == null) {
                    statement.bindNull(16);
                } else {
                    statement.bindLong(16, _tmpRequestHeadersSize.longValue());
                }
                String _tmpRequestBody = entity.getRequestBody();
                if (_tmpRequestBody == null) {
                    statement.bindNull(17);
                } else {
                    statement.bindText(17, _tmpRequestBody);
                }
                int _tmp = entity.isRequestBodyEncoded() ? 1 : 0;
                statement.bindLong(18, (long)_tmp);
                Integer _tmpResponseCode = entity.getResponseCode();
                if (_tmpResponseCode == null) {
                    statement.bindNull(19);
                } else {
                    statement.bindLong(19, (long)_tmpResponseCode.intValue());
                }
                String _tmpResponseMessage = entity.getResponseMessage();
                if (_tmpResponseMessage == null) {
                    statement.bindNull(20);
                } else {
                    statement.bindText(20, _tmpResponseMessage);
                }
                String _tmpError = entity.getError();
                if (_tmpError == null) {
                    statement.bindNull(21);
                } else {
                    statement.bindText(21, _tmpError);
                }
                Long _tmpResponsePayloadSize = entity.getResponsePayloadSize();
                if (_tmpResponsePayloadSize == null) {
                    statement.bindNull(22);
                } else {
                    statement.bindLong(22, _tmpResponsePayloadSize.longValue());
                }
                String _tmpResponseContentType = entity.getResponseContentType();
                if (_tmpResponseContentType == null) {
                    statement.bindNull(23);
                } else {
                    statement.bindText(23, _tmpResponseContentType);
                }
                String _tmpResponseHeaders = entity.getResponseHeaders();
                if (_tmpResponseHeaders == null) {
                    statement.bindNull(24);
                } else {
                    statement.bindText(24, _tmpResponseHeaders);
                }
                Long _tmpResponseHeadersSize = entity.getResponseHeadersSize();
                if (_tmpResponseHeadersSize == null) {
                    statement.bindNull(25);
                } else {
                    statement.bindLong(25, _tmpResponseHeadersSize.longValue());
                }
                String _tmpResponseBody = entity.getResponseBody();
                if (_tmpResponseBody == null) {
                    statement.bindNull(26);
                } else {
                    statement.bindText(26, _tmpResponseBody);
                }
                int _tmp_1 = entity.isResponseBodyEncoded() ? 1 : 0;
                statement.bindLong(27, (long)_tmp_1);
                byte[] _tmpResponseImageData = entity.getResponseImageData();
                if (_tmpResponseImageData == null) {
                    statement.bindNull(28);
                } else {
                    statement.bindBlob(28, _tmpResponseImageData);
                }
                int _tmp_2 = entity.getGraphQlDetected() ? 1 : 0;
                statement.bindLong(29, (long)_tmp_2);
                String _tmpGraphQlOperationName = entity.getGraphQlOperationName();
                if (_tmpGraphQlOperationName == null) {
                    statement.bindNull(30);
                } else {
                    statement.bindText(30, _tmpGraphQlOperationName);
                }
            }
        };
        this.__updateAdapterOfHttpTransaction = (EntityDeleteOrUpdateAdapter)new EntityDeleteOrUpdateAdapter<HttpTransaction>(){

            protected String createQuery() {
                return "UPDATE OR REPLACE `transactions` SET `id` = ?,`requestDate` = ?,`responseDate` = ?,`tookMs` = ?,`protocol` = ?,`method` = ?,`url` = ?,`host` = ?,`path` = ?,`scheme` = ?,`responseTlsVersion` = ?,`responseCipherSuite` = ?,`requestPayloadSize` = ?,`requestContentType` = ?,`requestHeaders` = ?,`requestHeadersSize` = ?,`requestBody` = ?,`isRequestBodyEncoded` = ?,`responseCode` = ?,`responseMessage` = ?,`error` = ?,`responsePayloadSize` = ?,`responseContentType` = ?,`responseHeaders` = ?,`responseHeadersSize` = ?,`responseBody` = ?,`isResponseBodyEncoded` = ?,`responseImageData` = ?,`graphQlDetected` = ?,`graphQlOperationName` = ? WHERE `id` = ?";
            }

            protected void bind(SQLiteStatement statement, HttpTransaction entity) {
                Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                statement.bindLong(1, entity.getId());
                Long _tmpRequestDate = entity.getRequestDate();
                if (_tmpRequestDate == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindLong(2, _tmpRequestDate.longValue());
                }
                Long _tmpResponseDate = entity.getResponseDate();
                if (_tmpResponseDate == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindLong(3, _tmpResponseDate.longValue());
                }
                Long _tmpTookMs = entity.getTookMs();
                if (_tmpTookMs == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindLong(4, _tmpTookMs.longValue());
                }
                String _tmpProtocol = entity.getProtocol();
                if (_tmpProtocol == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmpProtocol);
                }
                String _tmpMethod = entity.getMethod();
                if (_tmpMethod == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmpMethod);
                }
                String _tmpUrl = entity.getUrl();
                if (_tmpUrl == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, _tmpUrl);
                }
                String _tmpHost = entity.getHost();
                if (_tmpHost == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, _tmpHost);
                }
                String _tmpPath = entity.getPath();
                if (_tmpPath == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindText(9, _tmpPath);
                }
                String _tmpScheme = entity.getScheme();
                if (_tmpScheme == null) {
                    statement.bindNull(10);
                } else {
                    statement.bindText(10, _tmpScheme);
                }
                String _tmpResponseTlsVersion = entity.getResponseTlsVersion();
                if (_tmpResponseTlsVersion == null) {
                    statement.bindNull(11);
                } else {
                    statement.bindText(11, _tmpResponseTlsVersion);
                }
                String _tmpResponseCipherSuite = entity.getResponseCipherSuite();
                if (_tmpResponseCipherSuite == null) {
                    statement.bindNull(12);
                } else {
                    statement.bindText(12, _tmpResponseCipherSuite);
                }
                Long _tmpRequestPayloadSize = entity.getRequestPayloadSize();
                if (_tmpRequestPayloadSize == null) {
                    statement.bindNull(13);
                } else {
                    statement.bindLong(13, _tmpRequestPayloadSize.longValue());
                }
                String _tmpRequestContentType = entity.getRequestContentType();
                if (_tmpRequestContentType == null) {
                    statement.bindNull(14);
                } else {
                    statement.bindText(14, _tmpRequestContentType);
                }
                String _tmpRequestHeaders = entity.getRequestHeaders();
                if (_tmpRequestHeaders == null) {
                    statement.bindNull(15);
                } else {
                    statement.bindText(15, _tmpRequestHeaders);
                }
                Long _tmpRequestHeadersSize = entity.getRequestHeadersSize();
                if (_tmpRequestHeadersSize == null) {
                    statement.bindNull(16);
                } else {
                    statement.bindLong(16, _tmpRequestHeadersSize.longValue());
                }
                String _tmpRequestBody = entity.getRequestBody();
                if (_tmpRequestBody == null) {
                    statement.bindNull(17);
                } else {
                    statement.bindText(17, _tmpRequestBody);
                }
                int _tmp = entity.isRequestBodyEncoded() ? 1 : 0;
                statement.bindLong(18, (long)_tmp);
                Integer _tmpResponseCode = entity.getResponseCode();
                if (_tmpResponseCode == null) {
                    statement.bindNull(19);
                } else {
                    statement.bindLong(19, (long)_tmpResponseCode.intValue());
                }
                String _tmpResponseMessage = entity.getResponseMessage();
                if (_tmpResponseMessage == null) {
                    statement.bindNull(20);
                } else {
                    statement.bindText(20, _tmpResponseMessage);
                }
                String _tmpError = entity.getError();
                if (_tmpError == null) {
                    statement.bindNull(21);
                } else {
                    statement.bindText(21, _tmpError);
                }
                Long _tmpResponsePayloadSize = entity.getResponsePayloadSize();
                if (_tmpResponsePayloadSize == null) {
                    statement.bindNull(22);
                } else {
                    statement.bindLong(22, _tmpResponsePayloadSize.longValue());
                }
                String _tmpResponseContentType = entity.getResponseContentType();
                if (_tmpResponseContentType == null) {
                    statement.bindNull(23);
                } else {
                    statement.bindText(23, _tmpResponseContentType);
                }
                String _tmpResponseHeaders = entity.getResponseHeaders();
                if (_tmpResponseHeaders == null) {
                    statement.bindNull(24);
                } else {
                    statement.bindText(24, _tmpResponseHeaders);
                }
                Long _tmpResponseHeadersSize = entity.getResponseHeadersSize();
                if (_tmpResponseHeadersSize == null) {
                    statement.bindNull(25);
                } else {
                    statement.bindLong(25, _tmpResponseHeadersSize.longValue());
                }
                String _tmpResponseBody = entity.getResponseBody();
                if (_tmpResponseBody == null) {
                    statement.bindNull(26);
                } else {
                    statement.bindText(26, _tmpResponseBody);
                }
                int _tmp_1 = entity.isResponseBodyEncoded() ? 1 : 0;
                statement.bindLong(27, (long)_tmp_1);
                byte[] _tmpResponseImageData = entity.getResponseImageData();
                if (_tmpResponseImageData == null) {
                    statement.bindNull(28);
                } else {
                    statement.bindBlob(28, _tmpResponseImageData);
                }
                int _tmp_2 = entity.getGraphQlDetected() ? 1 : 0;
                statement.bindLong(29, (long)_tmp_2);
                String _tmpGraphQlOperationName = entity.getGraphQlOperationName();
                if (_tmpGraphQlOperationName == null) {
                    statement.bindNull(30);
                } else {
                    statement.bindText(30, _tmpGraphQlOperationName);
                }
                statement.bindLong(31, entity.getId());
            }
        };
    }

    @Override
    @Nullable
    public Object insert(@NotNull HttpTransaction transaction, @NotNull Continuation<? super Long> $completion) {
        return DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)false, (boolean)true, arg_0 -> HttpTransactionDao_Impl.insert$lambda$0(this, transaction, arg_0), $completion);
    }

    @Override
    @Nullable
    public Object update(@NotNull HttpTransaction transaction, @NotNull Continuation<? super Integer> $completion) {
        return DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)false, (boolean)true, arg_0 -> HttpTransactionDao_Impl.update$lambda$0(this, transaction, arg_0), $completion);
    }

    @Override
    @NotNull
    public LiveData<List<HttpTransactionTuple>> getSortedTuples() {
        String _sql = "SELECT id, requestDate, tookMs, protocol, method, host, path, scheme, responseCode, requestPayloadSize, responsePayloadSize, error, graphQLDetected, graphQlOperationName FROM transactions ORDER BY requestDate DESC";
        String[] stringArray = new String[]{"transactions"};
        return this.__db.getInvalidationTracker().createLiveData(stringArray, false, arg_0 -> HttpTransactionDao_Impl.getSortedTuples$lambda$0(_sql, arg_0));
    }

    @Override
    @NotNull
    public LiveData<List<HttpTransactionTuple>> getFilteredTuples(@NotNull String codeQuery, @NotNull String pathQuery, @NotNull String graphQlQuery) {
        Intrinsics.checkNotNullParameter((Object)codeQuery, (String)"codeQuery");
        Intrinsics.checkNotNullParameter((Object)pathQuery, (String)"pathQuery");
        Intrinsics.checkNotNullParameter((Object)graphQlQuery, (String)"graphQlQuery");
        String _sql = "SELECT id, requestDate, tookMs, protocol, method, host, path, scheme, responseCode, requestPayloadSize, responsePayloadSize, error, graphQLDetected, graphQlOperationName FROM transactions WHERE responseCode LIKE ? AND (path LIKE ? OR graphQlOperationName LIKE ?) ORDER BY requestDate DESC";
        String[] stringArray = new String[]{"transactions"};
        return this.__db.getInvalidationTracker().createLiveData(stringArray, false, arg_0 -> HttpTransactionDao_Impl.getFilteredTuples$lambda$0(_sql, codeQuery, pathQuery, graphQlQuery, arg_0));
    }

    @Override
    @NotNull
    public LiveData<HttpTransaction> getById(long id) {
        String _sql = "SELECT * FROM transactions WHERE id = ?";
        String[] stringArray = new String[]{"transactions"};
        return this.__db.getInvalidationTracker().createLiveData(stringArray, false, arg_0 -> HttpTransactionDao_Impl.getById$lambda$0(_sql, id, arg_0));
    }

    @Override
    @Nullable
    public Object getAll(@NotNull Continuation<? super List<HttpTransaction>> $completion) {
        String _sql = "SELECT * FROM transactions";
        return DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)true, (boolean)false, arg_0 -> HttpTransactionDao_Impl.getAll$lambda$0(_sql, arg_0), $completion);
    }

    @Override
    @NotNull
    public List<HttpTransaction> getTransactionsInTimeRange(long timestamp) {
        String _sql = "SELECT * FROM transactions WHERE requestDate >= ?";
        return (List)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, arg_0 -> HttpTransactionDao_Impl.getTransactionsInTimeRange$lambda$0(_sql, timestamp, arg_0));
    }

    @Override
    @Nullable
    public Object getSelectedTransactions(@NotNull List<Long> selectedTransactions, @NotNull Continuation<? super List<HttpTransaction>> $completion) {
        StringBuilder _stringBuilder = new StringBuilder();
        _stringBuilder.append("SELECT * FROM transactions WHERE id IN (");
        int _inputSize = selectedTransactions.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String string2 = _stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String _sql = string2;
        return DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)true, (boolean)false, arg_0 -> HttpTransactionDao_Impl.getSelectedTransactions$lambda$0(_sql, selectedTransactions, arg_0), $completion);
    }

    @Override
    @Nullable
    public Object deleteAll(@NotNull Continuation<? super Integer> $completion) {
        String _sql = "DELETE FROM transactions";
        return DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)false, (boolean)true, arg_0 -> HttpTransactionDao_Impl.deleteAll$lambda$0(_sql, arg_0), $completion);
    }

    @Override
    @Nullable
    public Object deleteBefore(long threshold, @NotNull Continuation<? super Integer> $completion) {
        String _sql = "DELETE FROM transactions WHERE requestDate <= ?";
        return DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)false, (boolean)true, arg_0 -> HttpTransactionDao_Impl.deleteBefore$lambda$0(_sql, threshold, arg_0), $completion);
    }

    @Override
    @Nullable
    public Object deleteSelected(@NotNull List<Long> selectedTransactions, @NotNull Continuation<? super Unit> $completion) {
        StringBuilder _stringBuilder = new StringBuilder();
        _stringBuilder.append("DELETE FROM transactions WHERE id IN (");
        int _inputSize = selectedTransactions.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String string2 = _stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String _sql = string2;
        Object object = DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)false, (boolean)true, arg_0 -> HttpTransactionDao_Impl.deleteSelected$lambda$0(_sql, selectedTransactions, arg_0), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private static final Long insert$lambda$0(HttpTransactionDao_Impl this$0, HttpTransaction $transaction, SQLiteConnection _connection) {
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        Long _result = this$0.__insertAdapterOfHttpTransaction.insertAndReturnId(_connection, (Object)$transaction);
        return _result;
    }

    private static final int update$lambda$0(HttpTransactionDao_Impl this$0, HttpTransaction $transaction, SQLiteConnection _connection) {
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        int _result = 0;
        return _result += this$0.__updateAdapterOfHttpTransaction.handle(_connection, (Object)$transaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List getSortedTuples$lambda$0(String $_sql, SQLiteConnection _connection) {
        List list;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _columnIndexOfId = 0;
            int _columnIndexOfRequestDate = 1;
            int _columnIndexOfTookMs = 2;
            int _columnIndexOfProtocol = 3;
            int _columnIndexOfMethod = 4;
            int _columnIndexOfHost = 5;
            int _columnIndexOfPath = 6;
            int _columnIndexOfScheme = 7;
            int _columnIndexOfResponseCode = 8;
            int _columnIndexOfRequestPayloadSize = 9;
            int _columnIndexOfResponsePayloadSize = 10;
            int _columnIndexOfError = 11;
            int _columnIndexOfGraphQlDetected = 12;
            int _columnIndexOfGraphQlOperationName = 13;
            List _result = new ArrayList();
            while (_stmt.step()) {
                HttpTransactionTuple _item = null;
                long _tmpId = 0L;
                _tmpId = _stmt.getLong(_columnIndexOfId);
                Long _tmpRequestDate = null;
                _tmpRequestDate = _stmt.isNull(_columnIndexOfRequestDate) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfRequestDate));
                Long _tmpTookMs = null;
                _tmpTookMs = _stmt.isNull(_columnIndexOfTookMs) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfTookMs));
                String _tmpProtocol = null;
                _tmpProtocol = _stmt.isNull(_columnIndexOfProtocol) ? null : _stmt.getText(_columnIndexOfProtocol);
                String _tmpMethod = null;
                _tmpMethod = _stmt.isNull(_columnIndexOfMethod) ? null : _stmt.getText(_columnIndexOfMethod);
                String _tmpHost = null;
                _tmpHost = _stmt.isNull(_columnIndexOfHost) ? null : _stmt.getText(_columnIndexOfHost);
                String _tmpPath = null;
                _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                String _tmpScheme = null;
                _tmpScheme = _stmt.isNull(_columnIndexOfScheme) ? null : _stmt.getText(_columnIndexOfScheme);
                Integer _tmpResponseCode = null;
                _tmpResponseCode = _stmt.isNull(_columnIndexOfResponseCode) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfResponseCode));
                Long _tmpRequestPayloadSize = null;
                _tmpRequestPayloadSize = _stmt.isNull(_columnIndexOfRequestPayloadSize) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfRequestPayloadSize));
                Long _tmpResponsePayloadSize = null;
                _tmpResponsePayloadSize = _stmt.isNull(_columnIndexOfResponsePayloadSize) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfResponsePayloadSize));
                String _tmpError = null;
                _tmpError = _stmt.isNull(_columnIndexOfError) ? null : _stmt.getText(_columnIndexOfError);
                boolean _tmpGraphQlDetected = false;
                int _tmp = 0;
                _tmp = (int)_stmt.getLong(_columnIndexOfGraphQlDetected);
                _tmpGraphQlDetected = _tmp != 0;
                String _tmpGraphQlOperationName = null;
                _tmpGraphQlOperationName = _stmt.isNull(_columnIndexOfGraphQlOperationName) ? null : _stmt.getText(_columnIndexOfGraphQlOperationName);
                _item = new HttpTransactionTuple(_tmpId, _tmpRequestDate, _tmpTookMs, _tmpProtocol, _tmpMethod, _tmpHost, _tmpPath, _tmpScheme, _tmpResponseCode, _tmpRequestPayloadSize, _tmpResponsePayloadSize, _tmpError, _tmpGraphQlDetected, _tmpGraphQlOperationName);
                _result.add(_item);
            }
            list = _result;
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List getFilteredTuples$lambda$0(String $_sql, String $codeQuery, String $pathQuery, String $graphQlQuery, SQLiteConnection _connection) {
        List list;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            _stmt.bindText(_argIndex, $codeQuery);
            _argIndex = 2;
            _stmt.bindText(_argIndex, $pathQuery);
            _argIndex = 3;
            _stmt.bindText(_argIndex, $graphQlQuery);
            int _columnIndexOfId = 0;
            int _columnIndexOfRequestDate = 1;
            int _columnIndexOfTookMs = 2;
            int _columnIndexOfProtocol = 3;
            int _columnIndexOfMethod = 4;
            int _columnIndexOfHost = 5;
            int _columnIndexOfPath = 6;
            int _columnIndexOfScheme = 7;
            int _columnIndexOfResponseCode = 8;
            int _columnIndexOfRequestPayloadSize = 9;
            int _columnIndexOfResponsePayloadSize = 10;
            int _columnIndexOfError = 11;
            int _columnIndexOfGraphQlDetected = 12;
            int _columnIndexOfGraphQlOperationName = 13;
            List _result = new ArrayList();
            while (_stmt.step()) {
                HttpTransactionTuple _item = null;
                long _tmpId = 0L;
                _tmpId = _stmt.getLong(_columnIndexOfId);
                Long _tmpRequestDate = null;
                _tmpRequestDate = _stmt.isNull(_columnIndexOfRequestDate) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfRequestDate));
                Long _tmpTookMs = null;
                _tmpTookMs = _stmt.isNull(_columnIndexOfTookMs) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfTookMs));
                String _tmpProtocol = null;
                _tmpProtocol = _stmt.isNull(_columnIndexOfProtocol) ? null : _stmt.getText(_columnIndexOfProtocol);
                String _tmpMethod = null;
                _tmpMethod = _stmt.isNull(_columnIndexOfMethod) ? null : _stmt.getText(_columnIndexOfMethod);
                String _tmpHost = null;
                _tmpHost = _stmt.isNull(_columnIndexOfHost) ? null : _stmt.getText(_columnIndexOfHost);
                String _tmpPath = null;
                _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                String _tmpScheme = null;
                _tmpScheme = _stmt.isNull(_columnIndexOfScheme) ? null : _stmt.getText(_columnIndexOfScheme);
                Integer _tmpResponseCode = null;
                _tmpResponseCode = _stmt.isNull(_columnIndexOfResponseCode) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfResponseCode));
                Long _tmpRequestPayloadSize = null;
                _tmpRequestPayloadSize = _stmt.isNull(_columnIndexOfRequestPayloadSize) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfRequestPayloadSize));
                Long _tmpResponsePayloadSize = null;
                _tmpResponsePayloadSize = _stmt.isNull(_columnIndexOfResponsePayloadSize) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfResponsePayloadSize));
                String _tmpError = null;
                _tmpError = _stmt.isNull(_columnIndexOfError) ? null : _stmt.getText(_columnIndexOfError);
                boolean _tmpGraphQlDetected = false;
                int _tmp = 0;
                _tmp = (int)_stmt.getLong(_columnIndexOfGraphQlDetected);
                _tmpGraphQlDetected = _tmp != 0;
                String _tmpGraphQlOperationName = null;
                _tmpGraphQlOperationName = _stmt.isNull(_columnIndexOfGraphQlOperationName) ? null : _stmt.getText(_columnIndexOfGraphQlOperationName);
                _item = new HttpTransactionTuple(_tmpId, _tmpRequestDate, _tmpTookMs, _tmpProtocol, _tmpMethod, _tmpHost, _tmpPath, _tmpScheme, _tmpResponseCode, _tmpRequestPayloadSize, _tmpResponsePayloadSize, _tmpError, _tmpGraphQlDetected, _tmpGraphQlOperationName);
                _result.add(_item);
            }
            list = _result;
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final HttpTransaction getById$lambda$0(String $_sql, long $id, SQLiteConnection _connection) {
        HttpTransaction httpTransaction;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            _stmt.bindLong(_argIndex, $id);
            int _columnIndexOfId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"id");
            int _columnIndexOfRequestDate = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"requestDate");
            int _columnIndexOfResponseDate = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"responseDate");
            int _columnIndexOfTookMs = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"tookMs");
            int _columnIndexOfProtocol = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"protocol");
            int _columnIndexOfMethod = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"method");
            int _columnIndexOfUrl = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"url");
            int _columnIndexOfHost = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"host");
            int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
            int _columnIndexOfScheme = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"scheme");
            int _columnIndexOfResponseTlsVersion = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"responseTlsVersion");
            int _columnIndexOfResponseCipherSuite = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"responseCipherSuite");
            int _columnIndexOfRequestPayloadSize = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"requestPayloadSize");
            int _columnIndexOfRequestContentType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"requestContentType");
            int _columnIndexOfRequestHeaders = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"requestHeaders");
            int _columnIndexOfRequestHeadersSize = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"requestHeadersSize");
            int _columnIndexOfRequestBody = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"requestBody");
            int _columnIndexOfIsRequestBodyEncoded = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isRequestBodyEncoded");
            int _columnIndexOfResponseCode = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"responseCode");
            int _columnIndexOfResponseMessage = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"responseMessage");
            int _columnIndexOfError = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"error");
            int _columnIndexOfResponsePayloadSize = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"responsePayloadSize");
            int _columnIndexOfResponseContentType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"responseContentType");
            int _columnIndexOfResponseHeaders = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"responseHeaders");
            int _columnIndexOfResponseHeadersSize = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"responseHeadersSize");
            int _columnIndexOfResponseBody = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"responseBody");
            int _columnIndexOfIsResponseBodyEncoded = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isResponseBodyEncoded");
            int _columnIndexOfResponseImageData = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"responseImageData");
            int _columnIndexOfGraphQlDetected = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"graphQlDetected");
            int _columnIndexOfGraphQlOperationName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"graphQlOperationName");
            HttpTransaction _result = null;
            if (_stmt.step()) {
                long _tmpId = 0L;
                _tmpId = _stmt.getLong(_columnIndexOfId);
                Long _tmpRequestDate = null;
                _tmpRequestDate = _stmt.isNull(_columnIndexOfRequestDate) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfRequestDate));
                Long _tmpResponseDate = null;
                _tmpResponseDate = _stmt.isNull(_columnIndexOfResponseDate) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfResponseDate));
                Long _tmpTookMs = null;
                _tmpTookMs = _stmt.isNull(_columnIndexOfTookMs) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfTookMs));
                String _tmpProtocol = null;
                _tmpProtocol = _stmt.isNull(_columnIndexOfProtocol) ? null : _stmt.getText(_columnIndexOfProtocol);
                String _tmpMethod = null;
                _tmpMethod = _stmt.isNull(_columnIndexOfMethod) ? null : _stmt.getText(_columnIndexOfMethod);
                String _tmpUrl = null;
                _tmpUrl = _stmt.isNull(_columnIndexOfUrl) ? null : _stmt.getText(_columnIndexOfUrl);
                String _tmpHost = null;
                _tmpHost = _stmt.isNull(_columnIndexOfHost) ? null : _stmt.getText(_columnIndexOfHost);
                String _tmpPath = null;
                _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                String _tmpScheme = null;
                _tmpScheme = _stmt.isNull(_columnIndexOfScheme) ? null : _stmt.getText(_columnIndexOfScheme);
                String _tmpResponseTlsVersion = null;
                _tmpResponseTlsVersion = _stmt.isNull(_columnIndexOfResponseTlsVersion) ? null : _stmt.getText(_columnIndexOfResponseTlsVersion);
                String _tmpResponseCipherSuite = null;
                _tmpResponseCipherSuite = _stmt.isNull(_columnIndexOfResponseCipherSuite) ? null : _stmt.getText(_columnIndexOfResponseCipherSuite);
                Long _tmpRequestPayloadSize = null;
                _tmpRequestPayloadSize = _stmt.isNull(_columnIndexOfRequestPayloadSize) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfRequestPayloadSize));
                String _tmpRequestContentType = null;
                _tmpRequestContentType = _stmt.isNull(_columnIndexOfRequestContentType) ? null : _stmt.getText(_columnIndexOfRequestContentType);
                String _tmpRequestHeaders = null;
                _tmpRequestHeaders = _stmt.isNull(_columnIndexOfRequestHeaders) ? null : _stmt.getText(_columnIndexOfRequestHeaders);
                Long _tmpRequestHeadersSize = null;
                _tmpRequestHeadersSize = _stmt.isNull(_columnIndexOfRequestHeadersSize) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfRequestHeadersSize));
                String _tmpRequestBody = null;
                _tmpRequestBody = _stmt.isNull(_columnIndexOfRequestBody) ? null : _stmt.getText(_columnIndexOfRequestBody);
                boolean _tmpIsRequestBodyEncoded = false;
                int _tmp = 0;
                _tmp = (int)_stmt.getLong(_columnIndexOfIsRequestBodyEncoded);
                _tmpIsRequestBodyEncoded = _tmp != 0;
                Integer _tmpResponseCode = null;
                _tmpResponseCode = _stmt.isNull(_columnIndexOfResponseCode) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfResponseCode));
                String _tmpResponseMessage = null;
                _tmpResponseMessage = _stmt.isNull(_columnIndexOfResponseMessage) ? null : _stmt.getText(_columnIndexOfResponseMessage);
                String _tmpError = null;
                _tmpError = _stmt.isNull(_columnIndexOfError) ? null : _stmt.getText(_columnIndexOfError);
                Long _tmpResponsePayloadSize = null;
                _tmpResponsePayloadSize = _stmt.isNull(_columnIndexOfResponsePayloadSize) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfResponsePayloadSize));
                String _tmpResponseContentType = null;
                _tmpResponseContentType = _stmt.isNull(_columnIndexOfResponseContentType) ? null : _stmt.getText(_columnIndexOfResponseContentType);
                String _tmpResponseHeaders = null;
                _tmpResponseHeaders = _stmt.isNull(_columnIndexOfResponseHeaders) ? null : _stmt.getText(_columnIndexOfResponseHeaders);
                Long _tmpResponseHeadersSize = null;
                _tmpResponseHeadersSize = _stmt.isNull(_columnIndexOfResponseHeadersSize) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfResponseHeadersSize));
                String _tmpResponseBody = null;
                _tmpResponseBody = _stmt.isNull(_columnIndexOfResponseBody) ? null : _stmt.getText(_columnIndexOfResponseBody);
                boolean _tmpIsResponseBodyEncoded = false;
                int _tmp_1 = 0;
                _tmp_1 = (int)_stmt.getLong(_columnIndexOfIsResponseBodyEncoded);
                _tmpIsResponseBodyEncoded = _tmp_1 != 0;
                byte[] _tmpResponseImageData = null;
                _tmpResponseImageData = _stmt.isNull(_columnIndexOfResponseImageData) ? null : _stmt.getBlob(_columnIndexOfResponseImageData);
                boolean _tmpGraphQlDetected = false;
                int _tmp_2 = 0;
                _tmp_2 = (int)_stmt.getLong(_columnIndexOfGraphQlDetected);
                _tmpGraphQlDetected = _tmp_2 != 0;
                String _tmpGraphQlOperationName = null;
                _tmpGraphQlOperationName = _stmt.isNull(_columnIndexOfGraphQlOperationName) ? null : _stmt.getText(_columnIndexOfGraphQlOperationName);
                _result = new HttpTransaction(_tmpId, _tmpRequestDate, _tmpResponseDate, _tmpTookMs, _tmpProtocol, _tmpMethod, _tmpUrl, _tmpHost, _tmpPath, _tmpScheme, _tmpResponseTlsVersion, _tmpResponseCipherSuite, _tmpRequestPayloadSize, _tmpRequestContentType, _tmpRequestHeaders, _tmpRequestHeadersSize, _tmpRequestBody, _tmpIsRequestBodyEncoded, _tmpResponseCode, _tmpResponseMessage, _tmpError, _tmpResponsePayloadSize, _tmpResponseContentType, _tmpResponseHeaders, _tmpResponseHeadersSize, _tmpResponseBody, _tmpIsResponseBodyEncoded, _tmpResponseImageData, _tmpGraphQlDetected, _tmpGraphQlOperationName);
            } else {
                _result = null;
            }
            httpTransaction = _result;
        }
        return httpTransaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List getAll$lambda$0(String $_sql, SQLiteConnection _connection) {
        List list;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _columnIndexOfId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"id");
            int _columnIndexOfRequestDate = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"requestDate");
            int _columnIndexOfResponseDate = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"responseDate");
            int _columnIndexOfTookMs = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"tookMs");
            int _columnIndexOfProtocol = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"protocol");
            int _columnIndexOfMethod = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"method");
            int _columnIndexOfUrl = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"url");
            int _columnIndexOfHost = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"host");
            int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
            int _columnIndexOfScheme = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"scheme");
            int _columnIndexOfResponseTlsVersion = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"responseTlsVersion");
            int _columnIndexOfResponseCipherSuite = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"responseCipherSuite");
            int _columnIndexOfRequestPayloadSize = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"requestPayloadSize");
            int _columnIndexOfRequestContentType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"requestContentType");
            int _columnIndexOfRequestHeaders = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"requestHeaders");
            int _columnIndexOfRequestHeadersSize = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"requestHeadersSize");
            int _columnIndexOfRequestBody = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"requestBody");
            int _columnIndexOfIsRequestBodyEncoded = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isRequestBodyEncoded");
            int _columnIndexOfResponseCode = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"responseCode");
            int _columnIndexOfResponseMessage = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"responseMessage");
            int _columnIndexOfError = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"error");
            int _columnIndexOfResponsePayloadSize = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"responsePayloadSize");
            int _columnIndexOfResponseContentType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"responseContentType");
            int _columnIndexOfResponseHeaders = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"responseHeaders");
            int _columnIndexOfResponseHeadersSize = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"responseHeadersSize");
            int _columnIndexOfResponseBody = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"responseBody");
            int _columnIndexOfIsResponseBodyEncoded = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isResponseBodyEncoded");
            int _columnIndexOfResponseImageData = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"responseImageData");
            int _columnIndexOfGraphQlDetected = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"graphQlDetected");
            int _columnIndexOfGraphQlOperationName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"graphQlOperationName");
            List _result = new ArrayList();
            while (_stmt.step()) {
                HttpTransaction _item = null;
                long _tmpId = 0L;
                _tmpId = _stmt.getLong(_columnIndexOfId);
                Long _tmpRequestDate = null;
                _tmpRequestDate = _stmt.isNull(_columnIndexOfRequestDate) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfRequestDate));
                Long _tmpResponseDate = null;
                _tmpResponseDate = _stmt.isNull(_columnIndexOfResponseDate) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfResponseDate));
                Long _tmpTookMs = null;
                _tmpTookMs = _stmt.isNull(_columnIndexOfTookMs) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfTookMs));
                String _tmpProtocol = null;
                _tmpProtocol = _stmt.isNull(_columnIndexOfProtocol) ? null : _stmt.getText(_columnIndexOfProtocol);
                String _tmpMethod = null;
                _tmpMethod = _stmt.isNull(_columnIndexOfMethod) ? null : _stmt.getText(_columnIndexOfMethod);
                String _tmpUrl = null;
                _tmpUrl = _stmt.isNull(_columnIndexOfUrl) ? null : _stmt.getText(_columnIndexOfUrl);
                String _tmpHost = null;
                _tmpHost = _stmt.isNull(_columnIndexOfHost) ? null : _stmt.getText(_columnIndexOfHost);
                String _tmpPath = null;
                _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                String _tmpScheme = null;
                _tmpScheme = _stmt.isNull(_columnIndexOfScheme) ? null : _stmt.getText(_columnIndexOfScheme);
                String _tmpResponseTlsVersion = null;
                _tmpResponseTlsVersion = _stmt.isNull(_columnIndexOfResponseTlsVersion) ? null : _stmt.getText(_columnIndexOfResponseTlsVersion);
                String _tmpResponseCipherSuite = null;
                _tmpResponseCipherSuite = _stmt.isNull(_columnIndexOfResponseCipherSuite) ? null : _stmt.getText(_columnIndexOfResponseCipherSuite);
                Long _tmpRequestPayloadSize = null;
                _tmpRequestPayloadSize = _stmt.isNull(_columnIndexOfRequestPayloadSize) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfRequestPayloadSize));
                String _tmpRequestContentType = null;
                _tmpRequestContentType = _stmt.isNull(_columnIndexOfRequestContentType) ? null : _stmt.getText(_columnIndexOfRequestContentType);
                String _tmpRequestHeaders = null;
                _tmpRequestHeaders = _stmt.isNull(_columnIndexOfRequestHeaders) ? null : _stmt.getText(_columnIndexOfRequestHeaders);
                Long _tmpRequestHeadersSize = null;
                _tmpRequestHeadersSize = _stmt.isNull(_columnIndexOfRequestHeadersSize) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfRequestHeadersSize));
                String _tmpRequestBody = null;
                _tmpRequestBody = _stmt.isNull(_columnIndexOfRequestBody) ? null : _stmt.getText(_columnIndexOfRequestBody);
                boolean _tmpIsRequestBodyEncoded = false;
                int _tmp = 0;
                _tmp = (int)_stmt.getLong(_columnIndexOfIsRequestBodyEncoded);
                _tmpIsRequestBodyEncoded = _tmp != 0;
                Integer _tmpResponseCode = null;
                _tmpResponseCode = _stmt.isNull(_columnIndexOfResponseCode) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfResponseCode));
                String _tmpResponseMessage = null;
                _tmpResponseMessage = _stmt.isNull(_columnIndexOfResponseMessage) ? null : _stmt.getText(_columnIndexOfResponseMessage);
                String _tmpError = null;
                _tmpError = _stmt.isNull(_columnIndexOfError) ? null : _stmt.getText(_columnIndexOfError);
                Long _tmpResponsePayloadSize = null;
                _tmpResponsePayloadSize = _stmt.isNull(_columnIndexOfResponsePayloadSize) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfResponsePayloadSize));
                String _tmpResponseContentType = null;
                _tmpResponseContentType = _stmt.isNull(_columnIndexOfResponseContentType) ? null : _stmt.getText(_columnIndexOfResponseContentType);
                String _tmpResponseHeaders = null;
                _tmpResponseHeaders = _stmt.isNull(_columnIndexOfResponseHeaders) ? null : _stmt.getText(_columnIndexOfResponseHeaders);
                Long _tmpResponseHeadersSize = null;
                _tmpResponseHeadersSize = _stmt.isNull(_columnIndexOfResponseHeadersSize) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfResponseHeadersSize));
                String _tmpResponseBody = null;
                _tmpResponseBody = _stmt.isNull(_columnIndexOfResponseBody) ? null : _stmt.getText(_columnIndexOfResponseBody);
                boolean _tmpIsResponseBodyEncoded = false;
                int _tmp_1 = 0;
                _tmp_1 = (int)_stmt.getLong(_columnIndexOfIsResponseBodyEncoded);
                _tmpIsResponseBodyEncoded = _tmp_1 != 0;
                byte[] _tmpResponseImageData = null;
                _tmpResponseImageData = _stmt.isNull(_columnIndexOfResponseImageData) ? null : _stmt.getBlob(_columnIndexOfResponseImageData);
                boolean _tmpGraphQlDetected = false;
                int _tmp_2 = 0;
                _tmp_2 = (int)_stmt.getLong(_columnIndexOfGraphQlDetected);
                _tmpGraphQlDetected = _tmp_2 != 0;
                String _tmpGraphQlOperationName = null;
                _tmpGraphQlOperationName = _stmt.isNull(_columnIndexOfGraphQlOperationName) ? null : _stmt.getText(_columnIndexOfGraphQlOperationName);
                _item = new HttpTransaction(_tmpId, _tmpRequestDate, _tmpResponseDate, _tmpTookMs, _tmpProtocol, _tmpMethod, _tmpUrl, _tmpHost, _tmpPath, _tmpScheme, _tmpResponseTlsVersion, _tmpResponseCipherSuite, _tmpRequestPayloadSize, _tmpRequestContentType, _tmpRequestHeaders, _tmpRequestHeadersSize, _tmpRequestBody, _tmpIsRequestBodyEncoded, _tmpResponseCode, _tmpResponseMessage, _tmpError, _tmpResponsePayloadSize, _tmpResponseContentType, _tmpResponseHeaders, _tmpResponseHeadersSize, _tmpResponseBody, _tmpIsResponseBodyEncoded, _tmpResponseImageData, _tmpGraphQlDetected, _tmpGraphQlOperationName);
                _result.add(_item);
            }
            list = _result;
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List getTransactionsInTimeRange$lambda$0(String $_sql, long $timestamp, SQLiteConnection _connection) {
        List list;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            _stmt.bindLong(_argIndex, $timestamp);
            int _columnIndexOfId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"id");
            int _columnIndexOfRequestDate = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"requestDate");
            int _columnIndexOfResponseDate = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"responseDate");
            int _columnIndexOfTookMs = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"tookMs");
            int _columnIndexOfProtocol = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"protocol");
            int _columnIndexOfMethod = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"method");
            int _columnIndexOfUrl = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"url");
            int _columnIndexOfHost = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"host");
            int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
            int _columnIndexOfScheme = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"scheme");
            int _columnIndexOfResponseTlsVersion = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"responseTlsVersion");
            int _columnIndexOfResponseCipherSuite = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"responseCipherSuite");
            int _columnIndexOfRequestPayloadSize = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"requestPayloadSize");
            int _columnIndexOfRequestContentType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"requestContentType");
            int _columnIndexOfRequestHeaders = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"requestHeaders");
            int _columnIndexOfRequestHeadersSize = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"requestHeadersSize");
            int _columnIndexOfRequestBody = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"requestBody");
            int _columnIndexOfIsRequestBodyEncoded = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isRequestBodyEncoded");
            int _columnIndexOfResponseCode = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"responseCode");
            int _columnIndexOfResponseMessage = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"responseMessage");
            int _columnIndexOfError = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"error");
            int _columnIndexOfResponsePayloadSize = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"responsePayloadSize");
            int _columnIndexOfResponseContentType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"responseContentType");
            int _columnIndexOfResponseHeaders = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"responseHeaders");
            int _columnIndexOfResponseHeadersSize = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"responseHeadersSize");
            int _columnIndexOfResponseBody = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"responseBody");
            int _columnIndexOfIsResponseBodyEncoded = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isResponseBodyEncoded");
            int _columnIndexOfResponseImageData = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"responseImageData");
            int _columnIndexOfGraphQlDetected = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"graphQlDetected");
            int _columnIndexOfGraphQlOperationName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"graphQlOperationName");
            List _result = new ArrayList();
            while (_stmt.step()) {
                HttpTransaction _item = null;
                long _tmpId = 0L;
                _tmpId = _stmt.getLong(_columnIndexOfId);
                Long _tmpRequestDate = null;
                _tmpRequestDate = _stmt.isNull(_columnIndexOfRequestDate) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfRequestDate));
                Long _tmpResponseDate = null;
                _tmpResponseDate = _stmt.isNull(_columnIndexOfResponseDate) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfResponseDate));
                Long _tmpTookMs = null;
                _tmpTookMs = _stmt.isNull(_columnIndexOfTookMs) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfTookMs));
                String _tmpProtocol = null;
                _tmpProtocol = _stmt.isNull(_columnIndexOfProtocol) ? null : _stmt.getText(_columnIndexOfProtocol);
                String _tmpMethod = null;
                _tmpMethod = _stmt.isNull(_columnIndexOfMethod) ? null : _stmt.getText(_columnIndexOfMethod);
                String _tmpUrl = null;
                _tmpUrl = _stmt.isNull(_columnIndexOfUrl) ? null : _stmt.getText(_columnIndexOfUrl);
                String _tmpHost = null;
                _tmpHost = _stmt.isNull(_columnIndexOfHost) ? null : _stmt.getText(_columnIndexOfHost);
                String _tmpPath = null;
                _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                String _tmpScheme = null;
                _tmpScheme = _stmt.isNull(_columnIndexOfScheme) ? null : _stmt.getText(_columnIndexOfScheme);
                String _tmpResponseTlsVersion = null;
                _tmpResponseTlsVersion = _stmt.isNull(_columnIndexOfResponseTlsVersion) ? null : _stmt.getText(_columnIndexOfResponseTlsVersion);
                String _tmpResponseCipherSuite = null;
                _tmpResponseCipherSuite = _stmt.isNull(_columnIndexOfResponseCipherSuite) ? null : _stmt.getText(_columnIndexOfResponseCipherSuite);
                Long _tmpRequestPayloadSize = null;
                _tmpRequestPayloadSize = _stmt.isNull(_columnIndexOfRequestPayloadSize) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfRequestPayloadSize));
                String _tmpRequestContentType = null;
                _tmpRequestContentType = _stmt.isNull(_columnIndexOfRequestContentType) ? null : _stmt.getText(_columnIndexOfRequestContentType);
                String _tmpRequestHeaders = null;
                _tmpRequestHeaders = _stmt.isNull(_columnIndexOfRequestHeaders) ? null : _stmt.getText(_columnIndexOfRequestHeaders);
                Long _tmpRequestHeadersSize = null;
                _tmpRequestHeadersSize = _stmt.isNull(_columnIndexOfRequestHeadersSize) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfRequestHeadersSize));
                String _tmpRequestBody = null;
                _tmpRequestBody = _stmt.isNull(_columnIndexOfRequestBody) ? null : _stmt.getText(_columnIndexOfRequestBody);
                boolean _tmpIsRequestBodyEncoded = false;
                int _tmp = 0;
                _tmp = (int)_stmt.getLong(_columnIndexOfIsRequestBodyEncoded);
                _tmpIsRequestBodyEncoded = _tmp != 0;
                Integer _tmpResponseCode = null;
                _tmpResponseCode = _stmt.isNull(_columnIndexOfResponseCode) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfResponseCode));
                String _tmpResponseMessage = null;
                _tmpResponseMessage = _stmt.isNull(_columnIndexOfResponseMessage) ? null : _stmt.getText(_columnIndexOfResponseMessage);
                String _tmpError = null;
                _tmpError = _stmt.isNull(_columnIndexOfError) ? null : _stmt.getText(_columnIndexOfError);
                Long _tmpResponsePayloadSize = null;
                _tmpResponsePayloadSize = _stmt.isNull(_columnIndexOfResponsePayloadSize) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfResponsePayloadSize));
                String _tmpResponseContentType = null;
                _tmpResponseContentType = _stmt.isNull(_columnIndexOfResponseContentType) ? null : _stmt.getText(_columnIndexOfResponseContentType);
                String _tmpResponseHeaders = null;
                _tmpResponseHeaders = _stmt.isNull(_columnIndexOfResponseHeaders) ? null : _stmt.getText(_columnIndexOfResponseHeaders);
                Long _tmpResponseHeadersSize = null;
                _tmpResponseHeadersSize = _stmt.isNull(_columnIndexOfResponseHeadersSize) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfResponseHeadersSize));
                String _tmpResponseBody = null;
                _tmpResponseBody = _stmt.isNull(_columnIndexOfResponseBody) ? null : _stmt.getText(_columnIndexOfResponseBody);
                boolean _tmpIsResponseBodyEncoded = false;
                int _tmp_1 = 0;
                _tmp_1 = (int)_stmt.getLong(_columnIndexOfIsResponseBodyEncoded);
                _tmpIsResponseBodyEncoded = _tmp_1 != 0;
                byte[] _tmpResponseImageData = null;
                _tmpResponseImageData = _stmt.isNull(_columnIndexOfResponseImageData) ? null : _stmt.getBlob(_columnIndexOfResponseImageData);
                boolean _tmpGraphQlDetected = false;
                int _tmp_2 = 0;
                _tmp_2 = (int)_stmt.getLong(_columnIndexOfGraphQlDetected);
                _tmpGraphQlDetected = _tmp_2 != 0;
                String _tmpGraphQlOperationName = null;
                _tmpGraphQlOperationName = _stmt.isNull(_columnIndexOfGraphQlOperationName) ? null : _stmt.getText(_columnIndexOfGraphQlOperationName);
                _item = new HttpTransaction(_tmpId, _tmpRequestDate, _tmpResponseDate, _tmpTookMs, _tmpProtocol, _tmpMethod, _tmpUrl, _tmpHost, _tmpPath, _tmpScheme, _tmpResponseTlsVersion, _tmpResponseCipherSuite, _tmpRequestPayloadSize, _tmpRequestContentType, _tmpRequestHeaders, _tmpRequestHeadersSize, _tmpRequestBody, _tmpIsRequestBodyEncoded, _tmpResponseCode, _tmpResponseMessage, _tmpError, _tmpResponsePayloadSize, _tmpResponseContentType, _tmpResponseHeaders, _tmpResponseHeadersSize, _tmpResponseBody, _tmpIsResponseBodyEncoded, _tmpResponseImageData, _tmpGraphQlDetected, _tmpGraphQlOperationName);
                _result.add(_item);
            }
            list = _result;
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List getSelectedTransactions$lambda$0(String $_sql, List $selectedTransactions, SQLiteConnection _connection) {
        List list;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            Iterator iterator = $selectedTransactions.iterator();
            while (iterator.hasNext()) {
                long _item = ((Number)iterator.next()).longValue();
                _stmt.bindLong(_argIndex, _item);
                ++_argIndex;
            }
            int _columnIndexOfId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"id");
            int _columnIndexOfRequestDate = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"requestDate");
            int _columnIndexOfResponseDate = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"responseDate");
            int _columnIndexOfTookMs = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"tookMs");
            int _columnIndexOfProtocol = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"protocol");
            int _columnIndexOfMethod = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"method");
            int _columnIndexOfUrl = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"url");
            int _columnIndexOfHost = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"host");
            int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
            int _columnIndexOfScheme = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"scheme");
            int _columnIndexOfResponseTlsVersion = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"responseTlsVersion");
            int _columnIndexOfResponseCipherSuite = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"responseCipherSuite");
            int _columnIndexOfRequestPayloadSize = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"requestPayloadSize");
            int _columnIndexOfRequestContentType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"requestContentType");
            int _columnIndexOfRequestHeaders = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"requestHeaders");
            int _columnIndexOfRequestHeadersSize = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"requestHeadersSize");
            int _columnIndexOfRequestBody = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"requestBody");
            int _columnIndexOfIsRequestBodyEncoded = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isRequestBodyEncoded");
            int _columnIndexOfResponseCode = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"responseCode");
            int _columnIndexOfResponseMessage = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"responseMessage");
            int _columnIndexOfError = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"error");
            int _columnIndexOfResponsePayloadSize = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"responsePayloadSize");
            int _columnIndexOfResponseContentType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"responseContentType");
            int _columnIndexOfResponseHeaders = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"responseHeaders");
            int _columnIndexOfResponseHeadersSize = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"responseHeadersSize");
            int _columnIndexOfResponseBody = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"responseBody");
            int _columnIndexOfIsResponseBodyEncoded = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isResponseBodyEncoded");
            int _columnIndexOfResponseImageData = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"responseImageData");
            int _columnIndexOfGraphQlDetected = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"graphQlDetected");
            int _columnIndexOfGraphQlOperationName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"graphQlOperationName");
            List _result = new ArrayList();
            while (_stmt.step()) {
                HttpTransaction _item_1 = null;
                long _tmpId = 0L;
                _tmpId = _stmt.getLong(_columnIndexOfId);
                Long _tmpRequestDate = null;
                _tmpRequestDate = _stmt.isNull(_columnIndexOfRequestDate) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfRequestDate));
                Long _tmpResponseDate = null;
                _tmpResponseDate = _stmt.isNull(_columnIndexOfResponseDate) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfResponseDate));
                Long _tmpTookMs = null;
                _tmpTookMs = _stmt.isNull(_columnIndexOfTookMs) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfTookMs));
                String _tmpProtocol = null;
                _tmpProtocol = _stmt.isNull(_columnIndexOfProtocol) ? null : _stmt.getText(_columnIndexOfProtocol);
                String _tmpMethod = null;
                _tmpMethod = _stmt.isNull(_columnIndexOfMethod) ? null : _stmt.getText(_columnIndexOfMethod);
                String _tmpUrl = null;
                _tmpUrl = _stmt.isNull(_columnIndexOfUrl) ? null : _stmt.getText(_columnIndexOfUrl);
                String _tmpHost = null;
                _tmpHost = _stmt.isNull(_columnIndexOfHost) ? null : _stmt.getText(_columnIndexOfHost);
                String _tmpPath = null;
                _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                String _tmpScheme = null;
                _tmpScheme = _stmt.isNull(_columnIndexOfScheme) ? null : _stmt.getText(_columnIndexOfScheme);
                String _tmpResponseTlsVersion = null;
                _tmpResponseTlsVersion = _stmt.isNull(_columnIndexOfResponseTlsVersion) ? null : _stmt.getText(_columnIndexOfResponseTlsVersion);
                String _tmpResponseCipherSuite = null;
                _tmpResponseCipherSuite = _stmt.isNull(_columnIndexOfResponseCipherSuite) ? null : _stmt.getText(_columnIndexOfResponseCipherSuite);
                Long _tmpRequestPayloadSize = null;
                _tmpRequestPayloadSize = _stmt.isNull(_columnIndexOfRequestPayloadSize) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfRequestPayloadSize));
                String _tmpRequestContentType = null;
                _tmpRequestContentType = _stmt.isNull(_columnIndexOfRequestContentType) ? null : _stmt.getText(_columnIndexOfRequestContentType);
                String _tmpRequestHeaders = null;
                _tmpRequestHeaders = _stmt.isNull(_columnIndexOfRequestHeaders) ? null : _stmt.getText(_columnIndexOfRequestHeaders);
                Long _tmpRequestHeadersSize = null;
                _tmpRequestHeadersSize = _stmt.isNull(_columnIndexOfRequestHeadersSize) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfRequestHeadersSize));
                String _tmpRequestBody = null;
                _tmpRequestBody = _stmt.isNull(_columnIndexOfRequestBody) ? null : _stmt.getText(_columnIndexOfRequestBody);
                boolean _tmpIsRequestBodyEncoded = false;
                int _tmp = 0;
                _tmp = (int)_stmt.getLong(_columnIndexOfIsRequestBodyEncoded);
                _tmpIsRequestBodyEncoded = _tmp != 0;
                Integer _tmpResponseCode = null;
                _tmpResponseCode = _stmt.isNull(_columnIndexOfResponseCode) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfResponseCode));
                String _tmpResponseMessage = null;
                _tmpResponseMessage = _stmt.isNull(_columnIndexOfResponseMessage) ? null : _stmt.getText(_columnIndexOfResponseMessage);
                String _tmpError = null;
                _tmpError = _stmt.isNull(_columnIndexOfError) ? null : _stmt.getText(_columnIndexOfError);
                Long _tmpResponsePayloadSize = null;
                _tmpResponsePayloadSize = _stmt.isNull(_columnIndexOfResponsePayloadSize) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfResponsePayloadSize));
                String _tmpResponseContentType = null;
                _tmpResponseContentType = _stmt.isNull(_columnIndexOfResponseContentType) ? null : _stmt.getText(_columnIndexOfResponseContentType);
                String _tmpResponseHeaders = null;
                _tmpResponseHeaders = _stmt.isNull(_columnIndexOfResponseHeaders) ? null : _stmt.getText(_columnIndexOfResponseHeaders);
                Long _tmpResponseHeadersSize = null;
                _tmpResponseHeadersSize = _stmt.isNull(_columnIndexOfResponseHeadersSize) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfResponseHeadersSize));
                String _tmpResponseBody = null;
                _tmpResponseBody = _stmt.isNull(_columnIndexOfResponseBody) ? null : _stmt.getText(_columnIndexOfResponseBody);
                boolean _tmpIsResponseBodyEncoded = false;
                int _tmp_1 = 0;
                _tmp_1 = (int)_stmt.getLong(_columnIndexOfIsResponseBodyEncoded);
                _tmpIsResponseBodyEncoded = _tmp_1 != 0;
                byte[] _tmpResponseImageData = null;
                _tmpResponseImageData = _stmt.isNull(_columnIndexOfResponseImageData) ? null : _stmt.getBlob(_columnIndexOfResponseImageData);
                boolean _tmpGraphQlDetected = false;
                int _tmp_2 = 0;
                _tmp_2 = (int)_stmt.getLong(_columnIndexOfGraphQlDetected);
                _tmpGraphQlDetected = _tmp_2 != 0;
                String _tmpGraphQlOperationName = null;
                _tmpGraphQlOperationName = _stmt.isNull(_columnIndexOfGraphQlOperationName) ? null : _stmt.getText(_columnIndexOfGraphQlOperationName);
                _item_1 = new HttpTransaction(_tmpId, _tmpRequestDate, _tmpResponseDate, _tmpTookMs, _tmpProtocol, _tmpMethod, _tmpUrl, _tmpHost, _tmpPath, _tmpScheme, _tmpResponseTlsVersion, _tmpResponseCipherSuite, _tmpRequestPayloadSize, _tmpRequestContentType, _tmpRequestHeaders, _tmpRequestHeadersSize, _tmpRequestBody, _tmpIsRequestBodyEncoded, _tmpResponseCode, _tmpResponseMessage, _tmpError, _tmpResponsePayloadSize, _tmpResponseContentType, _tmpResponseHeaders, _tmpResponseHeadersSize, _tmpResponseBody, _tmpIsResponseBodyEncoded, _tmpResponseImageData, _tmpGraphQlDetected, _tmpGraphQlOperationName);
                _result.add(_item_1);
            }
            list = _result;
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final int deleteAll$lambda$0(String $_sql, SQLiteConnection _connection) {
        int n;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            _stmt.step();
            n = SQLiteConnectionUtil.getTotalChangedRows((SQLiteConnection)_connection);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final int deleteBefore$lambda$0(String $_sql, long $threshold, SQLiteConnection _connection) {
        int n;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            _stmt.bindLong(_argIndex, $threshold);
            _stmt.step();
            n = SQLiteConnectionUtil.getTotalChangedRows((SQLiteConnection)_connection);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit deleteSelected$lambda$0(String $_sql, List $selectedTransactions, SQLiteConnection _connection) {
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            Iterator iterator = $selectedTransactions.iterator();
            while (iterator.hasNext()) {
                long _item = ((Number)iterator.next()).longValue();
                _stmt.bindLong(_argIndex, _item);
                ++_argIndex;
            }
            _stmt.step();
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/chuckerteam/chucker/internal/data/room/HttpTransactionDao_Impl$Companion;", "", "<init>", "()V", "getRequiredConverters", "", "Lkotlin/reflect/KClass;", "com.github.ChuckerTeam.Chucker.library"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<KClass<?>> getRequiredConverters() {
            return CollectionsKt.emptyList();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

