/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.internal.data.har.log;

import androidx.annotation.VisibleForTesting;
import com.chuckerteam.chucker.internal.data.entity.HttpTransaction;
import com.chuckerteam.chucker.internal.data.har.log.entry.Cache;
import com.chuckerteam.chucker.internal.data.har.log.entry.Request;
import com.chuckerteam.chucker.internal.data.har.log.entry.Response;
import com.chuckerteam.chucker.internal.data.har.log.entry.Timings;
import com.google.gson.annotations.SerializedName;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u001f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0080\b\u0018\u0000 ;2\u00020\u0001:\u0002:;Bg\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013B\u0011\b\u0016\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0012\u0010\u0016J\u000b\u0010)\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010*\u001a\u00020\u0003H\u00c6\u0003J\t\u0010+\u001a\u00020\u0006H\u00c6\u0003J\t\u0010,\u001a\u00020\bH\u00c6\u0003J\t\u0010-\u001a\u00020\nH\u00c6\u0003J\t\u0010.\u001a\u00020\fH\u00c6\u0003J\t\u0010/\u001a\u00020\u000eH\u00c6\u0003J\u000b\u00100\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u00101\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u00102\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003Ju\u00103\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0014\u00104\u001a\u0002052\b\u00106\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u00107\u001a\u000208H\u00d6\u0081\u0004J\n\u00109\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0018\u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0018R\u001e\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0016\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0016\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0016\u0010\u000b\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0016\u0010\r\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0018R\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0018R\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0018\u00a8\u0006<"}, d2={"Lcom/chuckerteam/chucker/internal/data/har/log/Entry;", "", "pageref", "", "startedDateTime", "time", "", "request", "Lcom/chuckerteam/chucker/internal/data/har/log/entry/Request;", "response", "Lcom/chuckerteam/chucker/internal/data/har/log/entry/Response;", "cache", "Lcom/chuckerteam/chucker/internal/data/har/log/entry/Cache;", "timings", "Lcom/chuckerteam/chucker/internal/data/har/log/entry/Timings;", "serverIPAddress", "connection", "comment", "<init>", "(Ljava/lang/String;Ljava/lang/String;JLcom/chuckerteam/chucker/internal/data/har/log/entry/Request;Lcom/chuckerteam/chucker/internal/data/har/log/entry/Response;Lcom/chuckerteam/chucker/internal/data/har/log/entry/Cache;Lcom/chuckerteam/chucker/internal/data/har/log/entry/Timings;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "transaction", "Lcom/chuckerteam/chucker/internal/data/entity/HttpTransaction;", "(Lcom/chuckerteam/chucker/internal/data/entity/HttpTransaction;)V", "getPageref", "()Ljava/lang/String;", "getStartedDateTime", "getTime", "()J", "setTime", "(J)V", "getRequest", "()Lcom/chuckerteam/chucker/internal/data/har/log/entry/Request;", "getResponse", "()Lcom/chuckerteam/chucker/internal/data/har/log/entry/Response;", "getCache", "()Lcom/chuckerteam/chucker/internal/data/har/log/entry/Cache;", "getTimings", "()Lcom/chuckerteam/chucker/internal/data/har/log/entry/Timings;", "getServerIPAddress", "getConnection", "getComment", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "copy", "equals", "", "other", "hashCode", "", "toString", "DateFormat", "Companion", "com.github.ChuckerTeam.Chucker.library"})
public final class Entry {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @SerializedName(value="pageref")
    @Nullable
    private final String pageref;
    @SerializedName(value="startedDateTime")
    @NotNull
    private final String startedDateTime;
    @SerializedName(value="time")
    private long time;
    @SerializedName(value="request")
    @NotNull
    private final Request request;
    @SerializedName(value="response")
    @NotNull
    private final Response response;
    @SerializedName(value="cache")
    @NotNull
    private final Cache cache;
    @SerializedName(value="timings")
    @NotNull
    private final Timings timings;
    @SerializedName(value="serverIPAddress")
    @Nullable
    private final String serverIPAddress;
    @SerializedName(value="connection")
    @Nullable
    private final String connection;
    @SerializedName(value="comment")
    @Nullable
    private final String comment;
    @NotNull
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";

    public Entry(@Nullable String pageref, @NotNull String startedDateTime, long time, @NotNull Request request, @NotNull Response response, @NotNull Cache cache, @NotNull Timings timings, @Nullable String serverIPAddress, @Nullable String connection, @Nullable String comment) {
        Intrinsics.checkNotNullParameter((Object)startedDateTime, (String)"startedDateTime");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
        Intrinsics.checkNotNullParameter((Object)timings, (String)"timings");
        this.pageref = pageref;
        this.startedDateTime = startedDateTime;
        this.time = time;
        this.request = request;
        this.response = response;
        this.cache = cache;
        this.timings = timings;
        this.serverIPAddress = serverIPAddress;
        this.connection = connection;
        this.comment = comment;
    }

    public /* synthetic */ Entry(String string2, String string3, long l, Request request, Response response, Cache cache, Timings timings, String string4, String string5, String string6, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string2 = null;
        }
        if ((n & 0x80) != 0) {
            string4 = null;
        }
        if ((n & 0x100) != 0) {
            string5 = null;
        }
        if ((n & 0x200) != 0) {
            string6 = null;
        }
        this(string2, string3, l, request, response, cache, timings, string4, string5, string6);
    }

    @Nullable
    public final String getPageref() {
        return this.pageref;
    }

    @NotNull
    public final String getStartedDateTime() {
        return this.startedDateTime;
    }

    public final long getTime() {
        return this.time;
    }

    public final void setTime(long l) {
        this.time = l;
    }

    @NotNull
    public final Request getRequest() {
        return this.request;
    }

    @NotNull
    public final Response getResponse() {
        return this.response;
    }

    @NotNull
    public final Cache getCache() {
        return this.cache;
    }

    @NotNull
    public final Timings getTimings() {
        return this.timings;
    }

    @Nullable
    public final String getServerIPAddress() {
        return this.serverIPAddress;
    }

    @Nullable
    public final String getConnection() {
        return this.connection;
    }

    @Nullable
    public final String getComment() {
        return this.comment;
    }

    public Entry(@NotNull HttpTransaction transaction) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Long l = transaction.getRequestDate();
        String string2 = l != null ? Entry.Companion.harFormatted(l) : null;
        if (string2 == null) {
            string2 = "";
        }
        this(null, string2, new Timings(transaction).getTime(), new Request(transaction), new Response(transaction), new Cache(null, null, null, 7, null), new Timings(transaction), null, null, null, 897, null);
    }

    @Nullable
    public final String component1() {
        return this.pageref;
    }

    @NotNull
    public final String component2() {
        return this.startedDateTime;
    }

    public final long component3() {
        return this.time;
    }

    @NotNull
    public final Request component4() {
        return this.request;
    }

    @NotNull
    public final Response component5() {
        return this.response;
    }

    @NotNull
    public final Cache component6() {
        return this.cache;
    }

    @NotNull
    public final Timings component7() {
        return this.timings;
    }

    @Nullable
    public final String component8() {
        return this.serverIPAddress;
    }

    @Nullable
    public final String component9() {
        return this.connection;
    }

    @Nullable
    public final String component10() {
        return this.comment;
    }

    @NotNull
    public final Entry copy(@Nullable String pageref, @NotNull String startedDateTime, long time, @NotNull Request request, @NotNull Response response, @NotNull Cache cache, @NotNull Timings timings, @Nullable String serverIPAddress, @Nullable String connection, @Nullable String comment) {
        Intrinsics.checkNotNullParameter((Object)startedDateTime, (String)"startedDateTime");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
        Intrinsics.checkNotNullParameter((Object)timings, (String)"timings");
        return new Entry(pageref, startedDateTime, time, request, response, cache, timings, serverIPAddress, connection, comment);
    }

    public static /* synthetic */ Entry copy$default(Entry entry, String string2, String string3, long l, Request request, Response response, Cache cache, Timings timings, String string4, String string5, String string6, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = entry.pageref;
        }
        if ((n & 2) != 0) {
            string3 = entry.startedDateTime;
        }
        if ((n & 4) != 0) {
            l = entry.time;
        }
        if ((n & 8) != 0) {
            request = entry.request;
        }
        if ((n & 0x10) != 0) {
            response = entry.response;
        }
        if ((n & 0x20) != 0) {
            cache = entry.cache;
        }
        if ((n & 0x40) != 0) {
            timings = entry.timings;
        }
        if ((n & 0x80) != 0) {
            string4 = entry.serverIPAddress;
        }
        if ((n & 0x100) != 0) {
            string5 = entry.connection;
        }
        if ((n & 0x200) != 0) {
            string6 = entry.comment;
        }
        return entry.copy(string2, string3, l, request, response, cache, timings, string4, string5, string6);
    }

    @NotNull
    public String toString() {
        return "Entry(pageref=" + this.pageref + ", startedDateTime=" + this.startedDateTime + ", time=" + this.time + ", request=" + this.request + ", response=" + this.response + ", cache=" + this.cache + ", timings=" + this.timings + ", serverIPAddress=" + this.serverIPAddress + ", connection=" + this.connection + ", comment=" + this.comment + ")";
    }

    public int hashCode() {
        int result = this.pageref == null ? 0 : this.pageref.hashCode();
        result = result * 31 + this.startedDateTime.hashCode();
        result = result * 31 + Long.hashCode(this.time);
        result = result * 31 + this.request.hashCode();
        result = result * 31 + this.response.hashCode();
        result = result * 31 + this.cache.hashCode();
        result = result * 31 + this.timings.hashCode();
        result = result * 31 + (this.serverIPAddress == null ? 0 : this.serverIPAddress.hashCode());
        result = result * 31 + (this.connection == null ? 0 : this.connection.hashCode());
        result = result * 31 + (this.comment == null ? 0 : this.comment.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Entry)) {
            return false;
        }
        Entry entry = (Entry)other;
        if (!Intrinsics.areEqual((Object)this.pageref, (Object)entry.pageref)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.startedDateTime, (Object)entry.startedDateTime)) {
            return false;
        }
        if (this.time != entry.time) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.request, (Object)entry.request)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.response, (Object)entry.response)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.cache, (Object)entry.cache)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.timings, (Object)entry.timings)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.serverIPAddress, (Object)entry.serverIPAddress)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.connection, (Object)entry.connection)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.comment, (Object)entry.comment);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0006\u001a\u00020\u0005*\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/chuckerteam/chucker/internal/data/har/log/Entry$Companion;", "", "<init>", "()V", "DATE_FORMAT", "", "harFormatted", "", "com.github.ChuckerTeam.Chucker.library"})
    public static final class Companion {
        private Companion() {
        }

        private final String harFormatted(long $this$harFormatted) {
            Object t = DateFormat.INSTANCE.get();
            Intrinsics.checkNotNull(t);
            String string2 = ((SimpleDateFormat)t).format(new Date($this$harFormatted));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            return string2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0002H\u0014\u00a8\u0006\u0006"}, d2={"Lcom/chuckerteam/chucker/internal/data/har/log/Entry$DateFormat;", "Ljava/lang/ThreadLocal;", "Ljava/text/SimpleDateFormat;", "<init>", "()V", "initialValue", "com.github.ChuckerTeam.Chucker.library"})
    @VisibleForTesting
    public static final class DateFormat
    extends ThreadLocal<SimpleDateFormat> {
        @NotNull
        public static final DateFormat INSTANCE = new DateFormat();

        private DateFormat() {
        }

        @Override
        @NotNull
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat(Entry.DATE_FORMAT, Locale.US);
        }
    }
}

