/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.internal.support;

import com.chuckerteam.chucker.api.BodyDecoder;
import com.chuckerteam.chucker.internal.support.OkHttpUtilsKt;
import com.chuckerteam.chucker.internal.support.OkioUtilsKt;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\r\u001a\u0004\u0018\u00010\u0005*\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/chuckerteam/chucker/internal/support/PlainTextDecoder;", "Lcom/chuckerteam/chucker/api/BodyDecoder;", "<init>", "()V", "decodeRequest", "", "request", "Lokhttp3/Request;", "body", "Lokio/ByteString;", "decodeResponse", "response", "Lokhttp3/Response;", "tryDecodeAsPlainText", "headers", "Lokhttp3/Headers;", "contentType", "Lokhttp3/MediaType;", "com.github.ChuckerTeam.Chucker.library"})
public final class PlainTextDecoder
implements BodyDecoder {
    @NotNull
    public static final PlainTextDecoder INSTANCE = new PlainTextDecoder();

    private PlainTextDecoder() {
    }

    @Override
    @Nullable
    public String decodeRequest(@NotNull Request request, @NotNull ByteString body) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        RequestBody requestBody = request.body();
        return this.tryDecodeAsPlainText(body, request.headers(), (MediaType)(requestBody != null ? requestBody.contentType() : null));
    }

    @Override
    @Nullable
    public String decodeResponse(@NotNull Response response, @NotNull ByteString body) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        ResponseBody responseBody = response.body();
        return this.tryDecodeAsPlainText(body, response.headers(), (MediaType)(responseBody != null ? responseBody.contentType() : null));
    }

    private final String tryDecodeAsPlainText(ByteString $this$tryDecodeAsPlainText, Headers headers, MediaType contentType) {
        String string2;
        if (OkHttpUtilsKt.getHasSupportedContentEncoding(headers) && OkioUtilsKt.isProbablyPlainText($this$tryDecodeAsPlainText)) {
            Object object = contentType;
            if (object == null || (object = MediaType.charset$default((MediaType)object, null, (int)1, null)) == null) {
                object = Charsets.UTF_8;
            }
            string2 = $this$tryDecodeAsPlainText.string((Charset)object);
        } else {
            string2 = null;
        }
        return string2;
    }
}

