/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.internal.support;

import com.chuckerteam.chucker.internal.support.Logger;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.ForwardingSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/chuckerteam/chucker/internal/support/DepletingSource;", "Lokio/ForwardingSource;", "delegate", "Lokio/Source;", "(Lokio/Source;)V", "shouldDeplete", "", "close", "", "read", "", "sink", "Lokio/Buffer;", "byteCount", "com.github.ChuckerTeam.Chucker.library"})
public final class DepletingSource
extends ForwardingSource {
    private boolean shouldDeplete;

    public DepletingSource(@NotNull Source delegate) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        super(delegate);
        this.shouldDeplete = true;
    }

    public long read(@NotNull Buffer sink, long byteCount) {
        long l;
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        try {
            long bytesRead = super.read(sink, byteCount);
            if (bytesRead == -1L) {
                this.shouldDeplete = false;
            }
            l = bytesRead;
        }
        catch (IOException e) {
            this.shouldDeplete = false;
            throw e;
        }
        return l;
    }

    public void close() {
        if (this.shouldDeplete) {
            try {
                Okio.buffer((Source)this.delegate()).readAll(Okio.blackhole());
            }
            catch (IOException e) {
                Logger.Companion.error("An error occurred while depleting the source", e);
            }
        }
        this.shouldDeplete = false;
        super.close();
    }
}

