/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.api;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ShortcutInfo;
import android.content.pm.ShortcutManager;
import android.graphics.drawable.Icon;
import android.os.Build;
import android.util.Log;
import androidx.core.content.ContextCompat;
import com.chuckerteam.chucker.R;
import com.chuckerteam.chucker.internal.support.Logger;
import com.chuckerteam.chucker.internal.support.NotificationHelper;
import com.chuckerteam.chucker.internal.ui.MainActivity;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0013J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0012H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0002\u001a\u0004\b\u0005\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lcom/chuckerteam/chucker/api/Chucker;", "", "()V", "SHORTCUT_ID", "", "isOp", "", "isOp$annotations", "()Z", "logger", "Lcom/chuckerteam/chucker/internal/support/Logger;", "getLogger$com_github_ChuckerTeam_Chucker_library", "()Lcom/chuckerteam/chucker/internal/support/Logger;", "setLogger$com_github_ChuckerTeam_Chucker_library", "(Lcom/chuckerteam/chucker/internal/support/Logger;)V", "createShortcut", "", "context", "Landroid/content/Context;", "createShortcut$com_github_ChuckerTeam_Chucker_library", "dismissNotifications", "getLaunchIntent", "Landroid/content/Intent;", "com.github.ChuckerTeam.Chucker.library"})
@SourceDebugExtension(value={"SMAP\nChucker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Chucker.kt\ncom/chuckerteam/chucker/api/Chucker\n+ 2 Context.kt\nandroidx/core/content/ContextKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,94:1\n31#2:95\n1747#3,3:96\n*S KotlinDebug\n*F\n+ 1 Chucker.kt\ncom/chuckerteam/chucker/api/Chucker\n*L\n50#1:95\n51#1:96,3\n*E\n"})
public final class Chucker {
    @NotNull
    public static final Chucker INSTANCE = new Chucker();
    @NotNull
    private static final String SHORTCUT_ID = "chuckerShortcutId";
    private static final boolean isOp = true;
    @NotNull
    private static Logger logger = new Logger(){
        @NotNull
        private final String TAG;
        {
            this.TAG = "Chucker";
        }

        @NotNull
        public final String getTAG() {
            return this.TAG;
        }

        public void info(@NotNull String message, @Nullable Throwable throwable) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Log.i((String)this.TAG, (String)message, (Throwable)throwable);
        }

        public void warn(@NotNull String message, @Nullable Throwable throwable) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Log.w((String)this.TAG, (String)message, (Throwable)throwable);
        }

        public void error(@NotNull String message, @Nullable Throwable throwable) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Log.e((String)this.TAG, (String)message, (Throwable)throwable);
        }
    };

    private Chucker() {
    }

    public final boolean isOp() {
        return isOp;
    }

    public static /* synthetic */ void isOp$annotations() {
    }

    @JvmStatic
    @NotNull
    public static final Intent getLaunchIntent(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intent intent = new Intent(context, MainActivity.class).setFlags(0x10000000);
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"Intent(context, MainActi\u2026t.FLAG_ACTIVITY_NEW_TASK)");
        return intent;
    }

    public final void createShortcut$com_github_ChuckerTeam_Chucker_library(@NotNull Context context) {
        boolean bl;
        ShortcutManager shortcutManager;
        block9: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (Build.VERSION.SDK_INT < 25) {
                return;
            }
            Context $this$getSystemService$iv = context;
            boolean $i$f$getSystemService = false;
            ShortcutManager shortcutManager2 = (ShortcutManager)ContextCompat.getSystemService((Context)$this$getSystemService$iv, ShortcutManager.class);
            if (shortcutManager2 == null) {
                return;
            }
            shortcutManager = shortcutManager2;
            List list = shortcutManager.getDynamicShortcuts();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"shortcutManager.dynamicShortcuts");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ShortcutInfo it = (ShortcutInfo)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)SHORTCUT_ID)) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        ShortcutInfo shortcutInfo = new ShortcutInfo.Builder(context, SHORTCUT_ID).setShortLabel((CharSequence)context.getString(R.string.chucker_shortcut_label)).setLongLabel((CharSequence)context.getString(R.string.chucker_shortcut_label)).setIcon(Icon.createWithResource((Context)context, (int)R.mipmap.chucker_ic_launcher)).setIntent(Chucker.getLaunchIntent(context).setAction("android.intent.action.VIEW")).build();
        Intrinsics.checkNotNullExpressionValue((Object)shortcutInfo, (String)"Builder(context, SHORTCU\u2026EW))\n            .build()");
        ShortcutInfo shortcut = shortcutInfo;
        try {
            shortcutManager.addDynamicShortcuts(CollectionsKt.listOf((Object)shortcut));
        }
        catch (IllegalArgumentException e) {
            Logger.Companion.warn("ShortcutManager addDynamicShortcuts failed ", e);
        }
        catch (IllegalStateException e) {
            Logger.Companion.warn("ShortcutManager addDynamicShortcuts failed ", e);
        }
    }

    @JvmStatic
    public static final void dismissNotifications(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        new NotificationHelper(context).dismissNotifications();
    }

    @NotNull
    public final Logger getLogger$com_github_ChuckerTeam_Chucker_library() {
        return logger;
    }

    public final void setLogger$com_github_ChuckerTeam_Chucker_library(@NotNull Logger logger2) {
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"<set-?>");
        logger = logger2;
    }
}

