/*
 * Decompiled with CFR 0.152.
 */
package com.core.util;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.KeyguardManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.net.Uri;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.SystemClock;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.Xml;
import android.view.Display;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import androidx.core.app.ActivityCompat;
import com.core.XUtil;
import com.core.util.StatusBarUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;
import org.xmlpull.v1.XmlSerializer;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0007\n\u0002\b\u0018\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010 \u001a\u00020!2\u000e\u0010\"\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030#H\u0007J\u0018\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0004H\u0007J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0007J\u0010\u0010,\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0007J\u0018\u0010-\u001a\u00020.2\u0006\u0010%\u001a\u00020&2\u0006\u0010/\u001a\u00020\u0004H\u0007J\u0018\u00100\u001a\u00020!2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0004H\u0007J\"\u00101\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040#022\u0006\u0010%\u001a\u00020&H\u0007J\u0010\u00103\u001a\u00020!2\u0006\u0010%\u001a\u00020&H\u0007J\u0010\u00104\u001a\u00020\u00042\u0006\u0010%\u001a\u00020&H\u0007J\u0012\u00105\u001a\u00020\u00042\b\u0010%\u001a\u0004\u0018\u00010&H\u0007J\u0010\u00106\u001a\u0002072\u0006\u0010%\u001a\u00020&H\u0007J\u0010\u00108\u001a\u00020!2\u0006\u0010%\u001a\u00020+H\u0007J\u0012\u00109\u001a\u0004\u0018\u00010\u00042\u0006\u0010%\u001a\u00020&H\u0007J\u0012\u0010:\u001a\u0004\u0018\u00010\u00042\u0006\u0010%\u001a\u00020&H\u0007J\u0012\u0010;\u001a\u0004\u0018\u00010\u00042\u0006\u0010%\u001a\u00020&H\u0007J\u0010\u0010<\u001a\u00020=2\u0006\u0010%\u001a\u00020&H\u0007J\u0012\u0010>\u001a\u0004\u0018\u00010\u00042\u0006\u0010%\u001a\u00020&H\u0007J\u0012\u0010?\u001a\u0004\u0018\u00010\u00042\u0006\u0010%\u001a\u00020&H\u0007J\u0012\u0010@\u001a\u0004\u0018\u00010\u00042\u0006\u0010%\u001a\u00020&H\u0007J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00042\u0006\u0010%\u001a\u00020&H\u0007J\u0010\u0010A\u001a\u00020\u00042\u0006\u0010%\u001a\u00020&H\u0007J\u0010\u0010B\u001a\u00020\u00042\u0006\u0010%\u001a\u00020&H\u0007J\u0010\u0010C\u001a\u00020\u00042\u0006\u0010%\u001a\u00020&H\u0007J\u0010\u0010D\u001a\u0002072\u0006\u0010%\u001a\u00020&H\u0007J\u0012\u0010E\u001a\u0004\u0018\u00010\u00042\u0006\u0010%\u001a\u00020&H\u0007J\u0010\u0010F\u001a\u0002072\u0006\u0010%\u001a\u00020&H\u0007J\u0010\u0010G\u001a\u0002072\u0006\u0010%\u001a\u00020&H\u0007J\u0010\u0010H\u001a\u00020I2\u0006\u0010%\u001a\u00020&H\u0007J\u0010\u0010J\u001a\u0002072\u0006\u0010%\u001a\u00020&H\u0007J\u0010\u0010K\u001a\u0002072\u0006\u0010%\u001a\u00020&H\u0007J\u0010\u0010L\u001a\u0002072\u0006\u0010*\u001a\u00020+H\u0007J\u0010\u0010M\u001a\u0002072\u0006\u0010%\u001a\u00020&H\u0007J\u0010\u0010N\u001a\u0002072\u0006\u0010%\u001a\u00020&H\u0007J\u0010\u0010O\u001a\u00020\u00042\u0006\u0010%\u001a\u00020&H\u0007J\u0010\u0010P\u001a\u00020\u00042\u0006\u0010%\u001a\u00020&H\u0007J\u0010\u0010Q\u001a\u00020\u00042\u0006\u0010%\u001a\u00020&H\u0007J\u0012\u0010R\u001a\u0004\u0018\u00010\u00042\u0006\u0010%\u001a\u00020&H\u0007J\u0010\u0010S\u001a\u0002072\u0006\u0010%\u001a\u00020&H\u0007J\u0012\u0010T\u001a\u0004\u0018\u00010\u00042\u0006\u0010%\u001a\u00020&H\u0007J\u000e\u0010U\u001a\u0002072\u0006\u0010%\u001a\u00020&J\u0012\u0010V\u001a\u0004\u0018\u00010\u00042\u0006\u0010%\u001a\u00020&H\u0007J\u000e\u0010W\u001a\u00020.2\u0006\u0010%\u001a\u00020&J\u0010\u0010X\u001a\u00020.2\u0006\u0010%\u001a\u00020&H\u0007J\u0010\u0010Y\u001a\u00020.2\u0006\u0010%\u001a\u00020&H\u0007J\u0010\u0010Z\u001a\u00020.2\u0006\u0010%\u001a\u00020&H\u0007J\u0010\u0010[\u001a\u00020.2\u0006\u0010%\u001a\u00020&H\u0007J\u0010\u0010\\\u001a\u00020!2\u0006\u0010*\u001a\u00020+H\u0007J$\u0010]\u001a\u00020!2\u0006\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\u00042\b\u0010^\u001a\u0004\u0018\u00010\u0004H\u0007J\u0010\u0010_\u001a\u00020!2\u0006\u0010*\u001a\u00020+H\u0007J\u0010\u0010`\u001a\u00020!2\u0006\u0010*\u001a\u00020+H\u0007R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\b\u0010\u0002\u001a\u0004\b\t\u0010\u0006R\u001a\u0010\n\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u000b\u0010\u0002\u001a\u0004\b\f\u0010\u0006R\u001a\u0010\r\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u000e\u0010\u0002\u001a\u0004\b\u000f\u0010\u0006R\u0011\u0010\u0010\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0006R$\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0013X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0019\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u00048GX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u001b\u0010\u0002\u001a\u0004\b\u001c\u0010\u0006R\u001a\u0010\u001d\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u001e\u0010\u0002\u001a\u0004\b\u001f\u0010\u0006\u00a8\u0006a"}, d2={"Lcom/core/util/DeviceUtil;", "", "()V", "appPackageName", "", "getAppPackageName", "()Ljava/lang/String;", "buildBrand", "getBuildBrand$annotations", "getBuildBrand", "buildBrandModel", "getBuildBrandModel$annotations", "getBuildBrandModel", "buildMANUFACTURER", "getBuildMANUFACTURER$annotations", "getBuildMANUFACTURER", "macAddress", "getMacAddress", "sRealSizes", "", "Landroid/graphics/Point;", "getSRealSizes", "()[Landroid/graphics/Point;", "setSRealSizes", "([Landroid/graphics/Point;)V", "[Landroid/graphics/Point;", "serialNumber", "getSerialNumber$annotations", "getSerialNumber", "uniqueSerialNumber", "getUniqueSerialNumber$annotations", "getUniqueSerialNumber", "ThroughArray", "", "res", "Ljava/util/HashMap;", "callPhone", "context", "Landroid/content/Context;", "phoneNumber", "captureWithStatusBar", "Landroid/graphics/Bitmap;", "activity", "Landroid/app/Activity;", "captureWithoutStatusBar", "checkPermission", "", "permission", "dial", "getAllContactInfo", "", "getAllSMS", "getAndroidId", "getAppVersionName", "getAppVersionNo", "", "getContantNum", "getDeviceIdIMEI", "getDeviceInfo", "getDeviceSoftwareVersion", "getDisplayMetrics", "Landroid/util/DisplayMetrics;", "getIMEI", "getIMSI", "getLine1Number", "getNetworkCountryIso", "getNetworkOperator", "getNetworkOperatorName", "getNetworkType", "getPhoneStatus", "getPhoneType", "getRealScreenHeight", "getScreenDensity", "", "getScreenHeight", "getScreenHeights", "getScreenRotation", "getScreenWidth", "getScreenWidths", "getSimCountryIso", "getSimOperator", "getSimOperatorName", "getSimSerialNumber", "getSimState", "getSubscriberId", "getUseScreenHeight", "getVoiceMailNumber", "isAllScreenDevice", "isLandscape", "isPhone", "isPortrait", "isScreenLock", "noScreenshots", "sendSms", "content", "setLandscape", "setPortrait", "XUtils_release"})
public final class DeviceUtil {
    @NotNull
    private static Point[] sRealSizes;
    @NotNull
    public static final DeviceUtil INSTANCE;

    @NotNull
    public final Point[] getSRealSizes() {
        return sRealSizes;
    }

    public final void setSRealSizes(@NotNull Point[] pointArray) {
        Intrinsics.checkNotNullParameter((Object)pointArray, (String)"<set-?>");
        sRealSizes = pointArray;
    }

    @JvmStatic
    public static final int getScreenHeight(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("window");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
        }
        WindowManager wm = (WindowManager)object;
        Display display = wm.getDefaultDisplay();
        Intrinsics.checkNotNullExpressionValue((Object)display, (String)"wm.defaultDisplay");
        return display.getHeight();
    }

    @JvmStatic
    public static final int getRealScreenHeight(@NotNull Context context) {
        Integer orientation;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Resources resources = context.getResources();
        Integer n = orientation = resources != null && (resources = resources.getConfiguration()) != null ? Integer.valueOf(resources.orientation) : null;
        Integer n2 = orientation = n != null && n == 1 ? Integer.valueOf(0) : Integer.valueOf(1);
        if (sRealSizes[orientation] == null) {
            Object object = context.getSystemService("window");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
            }
            WindowManager windowManager = (WindowManager)object;
            Display display = windowManager.getDefaultDisplay();
            Point point = new Point();
            display.getRealSize(point);
            DeviceUtil.sRealSizes[orientation.intValue()] = point;
        }
        Point point = sRealSizes[orientation];
        return point != null ? point.y : DeviceUtil.getRealScreenHeight(context);
    }

    public final int getUseScreenHeight(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.isAllScreenDevice(context) ? DeviceUtil.getRealScreenHeight(context) : DeviceUtil.getScreenHeight(context);
    }

    @JvmStatic
    public static final int getScreenWidth(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("window");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
        }
        WindowManager wm = (WindowManager)object;
        Display display = wm.getDefaultDisplay();
        Intrinsics.checkNotNullExpressionValue((Object)display, (String)"wm.defaultDisplay");
        return display.getWidth();
    }

    @JvmStatic
    public static final int getScreenWidths(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"context.resources");
        return resources.getDisplayMetrics().widthPixels;
    }

    @JvmStatic
    public static final int getScreenHeights(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"context.resources");
        return resources.getDisplayMetrics().heightPixels;
    }

    @JvmStatic
    public static final float getScreenDensity(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"context.resources");
        return resources.getDisplayMetrics().density;
    }

    @JvmStatic
    public static /* synthetic */ void getUniqueSerialNumber$annotations() {
    }

    @NotNull
    public static final String getUniqueSerialNumber() {
        String phoneName = Build.MODEL;
        String manuFacturer = Build.MANUFACTURER;
        Log.d((String)"\u8be6\u7ec6\u5e8f\u5217\u53f7", (String)(manuFacturer + '-' + phoneName + '-' + DeviceUtil.getSerialNumber()));
        return manuFacturer + '-' + phoneName + '-' + DeviceUtil.getSerialNumber();
    }

    @JvmStatic
    @Nullable
    public static final String getIMEI(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return DeviceUtil.isPhone(context) ? DeviceUtil.getDeviceIdIMEI(context) : DeviceUtil.getAndroidId(context);
    }

    @JvmStatic
    @Nullable
    public static final String getIMSI(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return DeviceUtil.getSubscriberId(context);
    }

    @JvmStatic
    @SuppressLint(value={"HardwareIds"})
    @Nullable
    public static final String getDeviceIdIMEI(@NotNull Context context) {
        String string;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String id = null;
        Object object = context.getSystemService("phone");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.telephony.TelephonyManager");
        }
        TelephonyManager mTelephony = (TelephonyManager)object;
        if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") != 0) {
            return null;
        }
        if (mTelephony.getDeviceId() != null) {
            String string2 = mTelephony.getDeviceId();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"mTelephony.deviceId");
        } else {
            Context context2 = context.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.applicationContext");
            String string3 = Settings.Secure.getString((ContentResolver)context2.getContentResolver(), (String)"android_id");
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"Settings.Secure.getStrin\u2026.ANDROID_ID\n            )");
        }
        id = string;
        return id;
    }

    @JvmStatic
    @Nullable
    public static final String getDeviceSoftwareVersion(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("phone");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.telephony.TelephonyManager");
        }
        TelephonyManager tm = (TelephonyManager)object;
        if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") != 0) {
            return null;
        }
        return tm.getDeviceSoftwareVersion();
    }

    @JvmStatic
    @SuppressLint(value={"HardwareIds"})
    @Nullable
    public static final String getLine1Number(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("phone");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.telephony.TelephonyManager");
        }
        TelephonyManager tm = (TelephonyManager)object;
        if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_SMS") != 0 && ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_NUMBERS") != 0 && ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") != 0) {
            return null;
        }
        return tm.getLine1Number();
    }

    @JvmStatic
    @NotNull
    public static final String getNetworkCountryIso(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("phone");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.telephony.TelephonyManager");
        }
        TelephonyManager tm = (TelephonyManager)object;
        String string = tm.getNetworkCountryIso();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tm.networkCountryIso");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String getNetworkOperator(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("phone");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.telephony.TelephonyManager");
        }
        TelephonyManager tm = (TelephonyManager)object;
        String string = tm.getNetworkOperator();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tm.networkOperator");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String getNetworkOperatorName(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("phone");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.telephony.TelephonyManager");
        }
        TelephonyManager tm = (TelephonyManager)object;
        String string = tm.getNetworkOperatorName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tm.networkOperatorName");
        return string;
    }

    @JvmStatic
    @SuppressLint(value={"MissingPermission"})
    public static final int getNetworkType(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("phone");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.telephony.TelephonyManager");
        }
        TelephonyManager tm = (TelephonyManager)object;
        return tm.getNetworkType();
    }

    @JvmStatic
    public static final int getPhoneType(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("phone");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.telephony.TelephonyManager");
        }
        TelephonyManager tm = (TelephonyManager)object;
        return tm.getPhoneType();
    }

    @JvmStatic
    @NotNull
    public static final String getSimCountryIso(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("phone");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.telephony.TelephonyManager");
        }
        TelephonyManager tm = (TelephonyManager)object;
        String string = tm.getSimCountryIso();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tm.simCountryIso");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String getSimOperator(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("phone");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.telephony.TelephonyManager");
        }
        TelephonyManager tm = (TelephonyManager)object;
        String string = tm.getSimOperator();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tm.simOperator");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String getSimOperatorName(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("phone");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.telephony.TelephonyManager");
        }
        TelephonyManager tm = (TelephonyManager)object;
        String string = tm.getSimOperatorName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tm.simOperatorName");
        return string;
    }

    @JvmStatic
    @SuppressLint(value={"HardwareIds"})
    @Nullable
    public static final String getSimSerialNumber(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("phone");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.telephony.TelephonyManager");
        }
        TelephonyManager tm = (TelephonyManager)object;
        if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") != 0) {
            return null;
        }
        return tm.getSimSerialNumber();
    }

    @JvmStatic
    public static final int getSimState(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("phone");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.telephony.TelephonyManager");
        }
        TelephonyManager tm = (TelephonyManager)object;
        return tm.getSimState();
    }

    @JvmStatic
    @SuppressLint(value={"HardwareIds"})
    @Nullable
    public static final String getSubscriberId(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("phone");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.telephony.TelephonyManager");
        }
        TelephonyManager tm = (TelephonyManager)object;
        if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") != 0) {
            return null;
        }
        return tm.getSubscriberId();
    }

    @JvmStatic
    @Nullable
    public static final String getVoiceMailNumber(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("phone");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.telephony.TelephonyManager");
        }
        TelephonyManager tm = (TelephonyManager)object;
        if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") != 0) {
            return null;
        }
        return tm.getVoiceMailNumber();
    }

    @JvmStatic
    @SuppressLint(value={"HardwareIds"})
    @NotNull
    public static final String getAndroidId(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Settings.Secure.getStrin\u2026ttings.Secure.ANDROID_ID)");
        return string;
    }

    @JvmStatic
    public static /* synthetic */ void getBuildBrandModel$annotations() {
    }

    @NotNull
    public static final String getBuildBrandModel() {
        String string = Build.MODEL;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Build.MODEL");
        return string;
    }

    @JvmStatic
    public static /* synthetic */ void getBuildBrand$annotations() {
    }

    @NotNull
    public static final String getBuildBrand() {
        String string = Build.BRAND;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Build.BRAND");
        return string;
    }

    @JvmStatic
    public static /* synthetic */ void getBuildMANUFACTURER$annotations() {
    }

    @NotNull
    public static final String getBuildMANUFACTURER() {
        String string = Build.MANUFACTURER;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Build.MANUFACTURER");
        return string;
    }

    @JvmStatic
    public static /* synthetic */ void getSerialNumber$annotations() {
    }

    @SuppressLint(value={"PrivateApi", "HardwareIds"})
    @Nullable
    public static final String getSerialNumber() {
        String serial = null;
        try {
            Class<?> c = Class.forName("android.os.SystemProperties");
            Method get = c.getMethod("get", String.class);
            Object object = get.invoke(c, "ro.serialno");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            serial = (String)object;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return serial;
    }

    @NotNull
    public final String getAppPackageName() {
        String string = XUtil.INSTANCE.getApp().getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"XUtil.getApp().packageName");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String getAppVersionName(@Nullable Context context) {
        Context context2 = context;
        PackageManager packageManager = context2 != null ? context2.getPackageManager() : null;
        PackageInfo packInfo = null;
        try {
            PackageManager packageManager2 = packageManager;
            packInfo = packageManager2 != null ? packageManager2.getPackageInfo(context.getPackageName(), 0) : null;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        PackageInfo packageInfo = packInfo;
        Intrinsics.checkNotNull((Object)packageInfo);
        String string = packageInfo.versionName;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"packInfo!!.versionName");
        return string;
    }

    @JvmStatic
    public static final int getAppVersionNo(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PackageManager packageManager = context.getPackageManager();
        PackageInfo packInfo = null;
        try {
            packInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        PackageInfo packageInfo = packInfo;
        Intrinsics.checkNotNull((Object)packageInfo);
        return packageInfo.versionCode;
    }

    @JvmStatic
    public static final boolean checkPermission(@NotNull Context context, @NotNull String permission) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        boolean result = false;
        if (Build.VERSION.SDK_INT >= 23) {
            boolean clazz22;
            try {
                Class<?> clazz22 = Class.forName("android.content.Context");
                Method method = clazz22.getMethod("checkSelfPermission", String.class);
                Object object = method.invoke((Object)context, permission);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                }
                int rest = (Integer)object;
                clazz22 = rest == 0;
            }
            catch (Exception e) {
                clazz22 = false;
            }
            result = clazz22;
        } else {
            PackageManager pm = context.getPackageManager();
            if (pm.checkPermission(permission, context.getPackageName()) == 0) {
                result = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @JvmStatic
    @Nullable
    public static final String getDeviceInfo(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            String mac;
            String device_id;
            JSONObject json;
            block26: {
                FileReader fileReader;
                json = new JSONObject();
                Object object = context.getSystemService("phone");
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.telephony.TelephonyManager");
                }
                TelephonyManager tm = (TelephonyManager)object;
                device_id = null;
                if (DeviceUtil.checkPermission(context, "android.permission.READ_PHONE_STATE")) {
                    device_id = DeviceUtil.getDeviceIdIMEI(context);
                }
                mac = null;
                FileReader fstream = null;
                try {
                    fileReader = new FileReader("/sys/class/net/wlan0/address");
                }
                catch (FileNotFoundException e) {
                    fileReader = new FileReader("/sys/class/net/eth0/address");
                }
                fstream = fileReader;
                BufferedReader in = null;
                in = new BufferedReader(fstream, 1024);
                mac = in.readLine();
                try {
                    fstream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                break block26;
                catch (IOException e) {
                    try {
                        fstream.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e3) {
                            e3.printStackTrace();
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            fstream.close();
                        }
                        catch (IOException e4) {
                            e4.printStackTrace();
                        }
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException e5) {
                                e5.printStackTrace();
                            }
                        }
                        throw throwable;
                    }
                }
            }
            json.put("mac", (Object)mac);
            if (TextUtils.isEmpty((CharSequence)device_id)) {
                device_id = mac;
            }
            if (TextUtils.isEmpty((CharSequence)device_id)) {
                device_id = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
            }
            json.put("device_id", (Object)device_id);
            return json.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @JvmStatic
    public static final void ThroughArray(@NotNull HashMap<?, ?> res) {
        Intrinsics.checkNotNullParameter(res, (String)"res");
        Iterator<Map.Entry<?, ?>> ite = res.entrySet().iterator();
        while (ite.hasNext()) {
            Object value;
            Object key;
            Map.Entry<?, ?> entry;
            if (ite.next() == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map.Entry<*, *>");
            }
            Intrinsics.checkNotNull(entry.getKey());
            Intrinsics.checkNotNull(entry.getValue());
            Log.d((String)"MSG_AUTH_COMPLETE", (String)(key + "\uff1a " + value));
        }
    }

    @JvmStatic
    @Nullable
    public static final String getMacAddress(@NotNull Context context) {
        String macAddress;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("wifi");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.net.wifi.WifiManager");
        }
        WifiManager wifi = (WifiManager)object;
        WifiInfo info = wifi.getConnectionInfo();
        if (info != null && (macAddress = info.getMacAddress()) != null) {
            return StringsKt.replace$default((String)macAddress, (String)":", (String)"", (boolean)false, (int)4, null);
        }
        return null;
    }

    @NotNull
    public final String getMacAddress() {
        String macAddress = "";
        NetworkInterface networkInterface = null;
        try {
            if (NetworkInterface.getByName("eth0") != null) {
                networkInterface = NetworkInterface.getByName("eth0");
            } else if (NetworkInterface.getByName("wlan0") != null) {
                networkInterface = NetworkInterface.getByName("wlan0");
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        if (networkInterface == null) {
            return macAddress;
        }
        byte[] macArr = new byte[]{};
        try {
            byte[] byArray = networkInterface.getHardwareAddress();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"networkInterface.hardwareAddress");
            macArr = byArray;
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        StringBuilder buf = new StringBuilder();
        for (byte b : macArr) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "%02X";
            Object[] objectArray = new Object[]{b};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            buf.append(string2);
        }
        String string = buf.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buf.toString()");
        macAddress = string;
        Log.d((String)"mac", (String)("interfaceName=" + networkInterface.getName() + ", mac=" + macAddress));
        macAddress = StringsKt.replace$default((String)macAddress, (String)":", (String)"", (boolean)false, (int)4, null);
        return macAddress;
    }

    @JvmStatic
    public static final boolean isPhone(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("phone");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.telephony.TelephonyManager");
        }
        TelephonyManager tm = (TelephonyManager)object;
        return tm.getPhoneType() != 0;
    }

    @JvmStatic
    @Nullable
    public static final String getPhoneStatus(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") != 0) {
            return null;
        }
        Object object = context.getSystemService("phone");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.telephony.TelephonyManager");
        }
        TelephonyManager tm = (TelephonyManager)object;
        String str = "";
        str = str + StringsKt.trimIndent((String)("\n            DeviceId(IMEI) = " + DeviceUtil.getDeviceIdIMEI(context) + "\n\n            "));
        str = str + StringsKt.trimIndent((String)("\n            DeviceSoftwareVersion = " + tm.getDeviceSoftwareVersion() + "\n\n            "));
        str = str + StringsKt.trimIndent((String)("\n            Line1Number = " + tm.getLine1Number() + "\n\n            "));
        str = str + StringsKt.trimIndent((String)("\n            NetworkCountryIso = " + tm.getNetworkCountryIso() + "\n\n            "));
        str = str + StringsKt.trimIndent((String)("\n            NetworkOperator = " + tm.getNetworkOperator() + "\n\n            "));
        str = str + StringsKt.trimIndent((String)("\n            NetworkOperatorName = " + tm.getNetworkOperatorName() + "\n\n            "));
        str = str + StringsKt.trimIndent((String)("\n            NetworkType = " + tm.getNetworkType() + "\n\n            "));
        str = str + StringsKt.trimIndent((String)("\n            honeType = " + tm.getPhoneType() + "\n\n            "));
        str = str + StringsKt.trimIndent((String)("\n            SimCountryIso = " + tm.getSimCountryIso() + "\n\n            "));
        str = str + StringsKt.trimIndent((String)("\n            SimOperator = " + tm.getSimOperator() + "\n\n            "));
        str = str + StringsKt.trimIndent((String)("\n            SimOperatorName = " + tm.getSimOperatorName() + "\n\n            "));
        str = str + StringsKt.trimIndent((String)("\n            SimSerialNumber = " + tm.getSimSerialNumber() + "\n\n            "));
        str = str + StringsKt.trimIndent((String)("\n            SimState = " + tm.getSimState() + "\n\n            "));
        str = str + StringsKt.trimIndent((String)("\n            SubscriberId(IMSI) = " + tm.getSubscriberId() + "\n\n            "));
        str = str + StringsKt.trimIndent((String)("\n            VoiceMailNumber = " + tm.getVoiceMailNumber() + "\n\n            "));
        return str;
    }

    @JvmStatic
    public static final void dial(@NotNull Context context, @NotNull String phoneNumber) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)phoneNumber, (String)"phoneNumber");
        context.startActivity(new Intent("android.intent.action.DIAL", Uri.parse((String)("tel:" + phoneNumber))));
    }

    @JvmStatic
    public static final void callPhone(@NotNull Context context, @NotNull String phoneNumber) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)phoneNumber, (String)"phoneNumber");
        CharSequence charSequence = phoneNumber;
        boolean bl = false;
        if (charSequence.length() > 0) {
            String $this$trim$iv = phoneNumber;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl2 = false;
                boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            String phoneNumber1 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            Intent intent = new Intent("android.intent.action.CALL", Uri.parse((String)("tel:" + phoneNumber1)));
            if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.CALL_PHONE") != 0) {
                return;
            }
            context.startActivity(intent);
        }
    }

    @JvmStatic
    public static final void sendSms(@NotNull Context context, @Nullable String phoneNumber, @Nullable String content) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CharSequence charSequence = phoneNumber;
        boolean bl = false;
        boolean bl2 = false;
        Uri uri = Uri.parse((String)("smsto:" + (charSequence == null || charSequence.length() == 0 ? "" : phoneNumber)));
        Intent intent = new Intent("android.intent.action.SENDTO", uri);
        CharSequence charSequence2 = content;
        bl2 = false;
        boolean bl3 = false;
        intent.putExtra("sms_body", charSequence2 == null || charSequence2.length() == 0 ? "" : content);
        context.startActivity(intent);
    }

    @JvmStatic
    @NotNull
    public static final List<HashMap<String, String>> getAllContactInfo(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SystemClock.sleep((long)3000L);
        ArrayList list = new ArrayList();
        ContentResolver resolver = context.getContentResolver();
        Uri raw_uri = Uri.parse((String)"content://com.android.contacts/raw_contacts");
        Uri date_uri = Uri.parse((String)"content://com.android.contacts/data");
        Cursor cursor = resolver.query(raw_uri, new String[]{"contact_id"}, null, null, null);
        while (true) {
            String contact_id;
            Cursor cursor2 = cursor;
            Intrinsics.checkNotNull((Object)cursor2);
            if (!cursor2.moveToNext()) break;
            String string = contact_id = cursor.getString(0);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"contact_id");
            CharSequence charSequence = string;
            boolean bl = false;
            if (!(charSequence.length() > 0)) continue;
            Cursor c = resolver.query(date_uri, new String[]{"data1", "mimetype"}, "raw_contact_id=?", new String[]{contact_id}, null);
            HashMap map = new HashMap();
            while (true) {
                Cursor cursor3 = c;
                Intrinsics.checkNotNull((Object)cursor3);
                if (!cursor3.moveToNext()) break;
                String data1 = c.getString(0);
                String mimetype = c.getString(1);
                if (Intrinsics.areEqual((Object)mimetype, (Object)"vnd.android.cursor.item/phone_v2")) {
                    Map map2 = map;
                    String string2 = data1;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"data1");
                    map2.put("phone", string2);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)mimetype, (Object)"vnd.android.cursor.item/name")) continue;
                Map map3 = map;
                String string3 = data1;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"data1");
                map3.put("name", string3);
            }
            list.add(map);
            c.close();
        }
        cursor.close();
        return list;
    }

    @JvmStatic
    public static final void getContantNum(@NotNull Activity context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Log.i((String)"tips", (String)"U should copy the following code.");
        Intent intent = new Intent();
        intent.setAction("android.intent.action.PICK");
        intent.setType("vnd.android.cursor.dir/phone_v2");
        context.startActivityForResult(intent, 0);
    }

    @JvmStatic
    public static final void getAllSMS(@NotNull Context context) {
        Cursor cursor;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ContentResolver resolver = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://sms");
        Cursor cursor2 = cursor = resolver.query(uri, new String[]{"address", "date", "type", "body"}, null, null, null);
        Intrinsics.checkNotNull((Object)cursor2);
        int count = cursor2.getCount();
        XmlSerializer xmlSerializer = Xml.newSerializer();
        try {
            xmlSerializer.setOutput((OutputStream)new FileOutputStream(new File("/mnt/sdcard/backupsms.xml")), "utf-8");
            xmlSerializer.startDocument("utf-8", Boolean.valueOf(true));
            xmlSerializer.startTag(null, "smss");
            while (cursor.moveToNext()) {
                SystemClock.sleep((long)1000L);
                xmlSerializer.startTag(null, "sms");
                xmlSerializer.startTag(null, "address");
                String address = cursor.getString(0);
                xmlSerializer.text(address);
                xmlSerializer.endTag(null, "address");
                xmlSerializer.startTag(null, "date");
                String date = cursor.getString(1);
                xmlSerializer.text(date);
                xmlSerializer.endTag(null, "date");
                xmlSerializer.startTag(null, "type");
                String type = cursor.getString(2);
                xmlSerializer.text(type);
                xmlSerializer.endTag(null, "type");
                xmlSerializer.startTag(null, "body");
                String body = cursor.getString(3);
                xmlSerializer.text(body);
                xmlSerializer.endTag(null, "body");
                xmlSerializer.endTag(null, "sms");
                String string = "address:" + address + "   date:" + date + "  type:" + type + "  body:" + body;
                boolean bl = false;
                System.out.println((Object)string);
            }
            xmlSerializer.endTag(null, "smss");
            xmlSerializer.endDocument();
            xmlSerializer.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @JvmStatic
    @SuppressLint(value={"SourceLockedOrientationActivity"})
    public static final void setLandscape(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        activity.setRequestedOrientation(0);
    }

    @JvmStatic
    @SuppressLint(value={"SourceLockedOrientationActivity"})
    public static final void setPortrait(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        activity.setRequestedOrientation(1);
    }

    @JvmStatic
    public static final boolean isLandscape(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"context.resources");
        return resources.getConfiguration().orientation == 2;
    }

    @JvmStatic
    public static final boolean isPortrait(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"context.resources");
        return resources.getConfiguration().orientation == 1;
    }

    @JvmStatic
    public static final int getScreenRotation(@NotNull Activity activity) {
        int n;
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        WindowManager windowManager = activity.getWindowManager();
        Intrinsics.checkNotNullExpressionValue((Object)windowManager, (String)"activity.windowManager");
        Display display = windowManager.getDefaultDisplay();
        Intrinsics.checkNotNullExpressionValue((Object)display, (String)"activity.windowManager.defaultDisplay");
        switch (display.getRotation()) {
            case 0: {
                n = 0;
                break;
            }
            case 1: {
                n = 90;
                break;
            }
            case 2: {
                n = 180;
                break;
            }
            case 3: {
                n = 270;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    @JvmStatic
    @NotNull
    public static final Bitmap captureWithStatusBar(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Window window = activity.getWindow();
        Intrinsics.checkNotNullExpressionValue((Object)window, (String)"activity.window");
        View view = window.getDecorView();
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"activity.window.decorView");
        View view2 = view;
        view2.setDrawingCacheEnabled(true);
        view2.buildDrawingCache();
        Bitmap bmp = view2.getDrawingCache();
        int width = DeviceUtil.getScreenWidth((Context)activity);
        int height = DeviceUtil.getScreenHeight((Context)activity);
        Bitmap ret = Bitmap.createBitmap((Bitmap)bmp, (int)0, (int)0, (int)width, (int)height);
        view2.destroyDrawingCache();
        Bitmap bitmap = ret;
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"ret");
        return bitmap;
    }

    @JvmStatic
    @NotNull
    public static final Bitmap captureWithoutStatusBar(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Window window = activity.getWindow();
        Intrinsics.checkNotNullExpressionValue((Object)window, (String)"activity.window");
        View view = window.getDecorView();
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"activity.window.decorView");
        View view2 = view;
        view2.setDrawingCacheEnabled(true);
        view2.buildDrawingCache();
        Bitmap bmp = view2.getDrawingCache();
        int statusBarHeight = StatusBarUtil.getStatusBarHeight((Context)activity);
        int width = DeviceUtil.getScreenWidth((Context)activity);
        int height = DeviceUtil.getScreenHeight((Context)activity);
        Bitmap ret = Bitmap.createBitmap((Bitmap)bmp, (int)0, (int)statusBarHeight, (int)width, (int)(height - statusBarHeight));
        view2.destroyDrawingCache();
        Bitmap bitmap = ret;
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"ret");
        return bitmap;
    }

    @JvmStatic
    @NotNull
    public static final DisplayMetrics getDisplayMetrics(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("window");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
        }
        WindowManager windowManager = (WindowManager)object;
        DisplayMetrics displayMetrics = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics;
    }

    @JvmStatic
    public static final boolean isScreenLock(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("keyguard");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.app.KeyguardManager");
        }
        KeyguardManager km = (KeyguardManager)object;
        return km.inKeyguardRestrictedInputMode();
    }

    @JvmStatic
    public static final void noScreenshots(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        activity.getWindow().addFlags(8192);
    }

    public final boolean isAllScreenDevice(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (Build.VERSION.SDK_INT <= 20) {
            return false;
        }
        Object object = context.getSystemService("window");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
        }
        WindowManager windowManager = (WindowManager)object;
        Display display = windowManager.getDefaultDisplay();
        Point point = new Point();
        display.getRealSize(point);
        float width = 0.0f;
        float height = 0.0f;
        if (point.x < point.y) {
            width = point.x;
            height = point.y;
        } else {
            width = point.y;
            height = point.x;
        }
        return height / width >= 1.97f;
    }

    private DeviceUtil() {
    }

    static {
        DeviceUtil deviceUtil;
        INSTANCE = deviceUtil = new DeviceUtil();
        sRealSizes = new Point[2];
    }
}

