/*
 * Decompiled with CFR 0.152.
 */
package org.simpleyaml.configuration.comments;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.simpleyaml.configuration.ConfigurationOptions;

public class KeyTree {
    private final Node root = new Node(null, 0, "");
    private final Map<String, Node> nodes = new HashMap<String, Node>();
    private final ConfigurationOptions options;

    public KeyTree(ConfigurationOptions options) {
        this.options = options;
    }

    public Node add(String path) {
        int i;
        Node parent = this.root;
        String key = path;
        if (path != null && (i = path.lastIndexOf(46)) >= 0) {
            String parentPath = path.substring(0, i);
            key = path.substring(i + 1);
            parent = this.get(parentPath);
            if (parent == null) {
                parent = this.add(parentPath);
            }
        }
        return parent.add(key);
    }

    public Node findParent(int indent) {
        return this.findParent(this.root, indent);
    }

    public Node get(String path) {
        return this.nodes.get(path);
    }

    public Set<String> keys() {
        return this.nodes.keySet();
    }

    public Set<Map.Entry<String, Node>> entries() {
        return this.nodes.entrySet();
    }

    public String toString() {
        return this.root.toString();
    }

    private Node findParent(Node parent, int indent) {
        if (parent.children.isEmpty()) {
            return parent;
        }
        Node last = (Node)parent.children.getLast();
        if (last.indent < indent) {
            return this.findParent(last, indent);
        }
        return parent;
    }

    public class Node {
        private final String name;
        private final Node parent;
        private final LinkedList<Node> children = new LinkedList();
        private final int indent;
        private String comment;
        private String sideComment;
        private String path;

        Node(Node parent, int indent, String name) {
            this.parent = parent;
            this.indent = indent;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        public String getSideComment() {
            return this.sideComment;
        }

        public void setSideComment(String sideComment) {
            this.sideComment = sideComment;
        }

        public int getIndentation() {
            return this.indent;
        }

        public String getPath() {
            if (this.path == null) {
                this.path = this.getPath(this.parent, this.name, KeyTree.this.options.pathSeparator());
            }
            return this.path;
        }

        public Node add(String key) {
            return this.add(this == KeyTree.this.root ? 0 : this.indent + KeyTree.this.options.indent(), key);
        }

        public Node add(int indent, String key) {
            return this.add(new Node(this, indent, key));
        }

        public String toString() {
            return "{indent=" + this.indent + ", name='" + this.name + '\'' + ", comment='" + this.comment + '\'' + ", side='" + this.sideComment + '\'' + ", children=" + this.children + '}';
        }

        private String getPath(Node parent, String name, char separator) {
            if (parent == null) {
                return name;
            }
            if (parent != KeyTree.this.root) {
                name = parent.name + separator + name;
            }
            return this.getPath(parent.parent, name, separator);
        }

        private Node add(Node child) {
            this.children.add(child);
            KeyTree.this.nodes.put(child.getPath(), child);
            return child;
        }
    }
}

