/*
 * Decompiled with CFR 0.152.
 */
package cn.carbs.android.gregorianlunarcalendar.library.util;

import cn.carbs.android.gregorianlunarcalendar.library.data.ChineseCalendar;
import java.util.GregorianCalendar;
import java.util.HashMap;

public class Util {
    public static final String[] lunarNumbers = new String[]{"\u96f6", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d"};
    public static final String[] lunarMonths = new String[]{"\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "\u5341", "\u5341\u4e00", "\u5341\u4e8c"};
    public static final String[] lunarDays = new String[]{"\u521d\u4e00", "\u521d\u4e8c", "\u521d\u4e09", "\u521d\u56db", "\u521d\u4e94", "\u521d\u516d", "\u521d\u4e03", "\u521d\u516b", "\u521d\u4e5d", "\u521d\u5341", "\u5341\u4e00", "\u5341\u4e8c", "\u5341\u4e09", "\u5341\u56db", "\u5341\u4e94", "\u5341\u516d", "\u5341\u4e03", "\u5341\u516b", "\u5341\u4e5d", "\u5eff\u5341", "\u5eff\u4e00", "\u5eff\u4e8c", "\u5eff\u4e09", "\u5eff\u56db", "\u5eff\u4e94", "\u5eff\u516d", "\u5eff\u4e03", "\u5eff\u516b", "\u5eff\u4e5d", "\u4e09\u5341"};
    public static HashMap<Integer, String[]> twelveMonthWithLeapCache = new HashMap();

    public static int getMonthLeapByYear(int year) {
        return ChineseCalendar.getMonthLeapByYear(year);
    }

    public static int getSumOfDayInMonth(int year, int monthSway, boolean isGregorian) {
        if (isGregorian) {
            return Util.getSumOfDayInMonthForGregorianByMonth(year, monthSway);
        }
        return Util.getSumOfDayInMonthForLunarByMonthSway(year, monthSway);
    }

    public static int getSumOfDayInMonthForGregorianByMonth(int year, int month) {
        return new GregorianCalendar(year, month, 0).get(5);
    }

    public static int getSumOfDayInMonthForLunarByMonthSway(int year, int monthSway) {
        int monthLeap = ChineseCalendar.getMonthLeapByYear(year);
        int monthLunar = Util.convertMonthSwayToMonthLunar(monthSway, monthLeap);
        return ChineseCalendar.daysInChineseMonth(year, monthLunar);
    }

    public static int getSumOfDayInMonthForLunarByMonthLunar(int year, int monthLunar) {
        return ChineseCalendar.daysInChineseMonth(year, monthLunar);
    }

    public static int getSumOfDayInMonthForLunarLeapYear(int year, int monthSway, int monthLeap) {
        int month = Util.convertMonthSwayToMonthLunar(monthSway, monthLeap);
        return ChineseCalendar.daysInChineseMonth(year, month);
    }

    public static String getLunarNameOfYear(int year) {
        StringBuilder sb = new StringBuilder();
        int divider = 10;
        int digital = 0;
        while (year > 0) {
            digital = year % divider;
            sb.insert(0, lunarNumbers[digital]);
            year /= 10;
        }
        return sb.toString();
    }

    public static String getLunarNameOfMonth(int month) {
        if (month > 0 && month < 13) {
            return lunarMonths[month - 1];
        }
        throw new IllegalArgumentException("month should be in range of [1, 12] month is " + month);
    }

    public static String getLunarNameOfDay(int day) {
        if (day > 0 && day < 31) {
            return lunarDays[day - 1];
        }
        throw new IllegalArgumentException("day should be in range of [1, 30] day is " + day);
    }

    public static String[] getLunarMonthsNamesWithLeap(int monthLeap) {
        if (monthLeap == 0) {
            return lunarMonths;
        }
        if (monthLeap < -12 || monthLeap > 0) {
            throw new IllegalArgumentException("month should be in range of [-12, 0]");
        }
        int monthLeapAbs = Math.abs(monthLeap);
        String[] monthsOut = twelveMonthWithLeapCache.get(monthLeapAbs);
        if (monthsOut != null && monthsOut.length == 13) {
            return monthsOut;
        }
        monthsOut = new String[13];
        System.arraycopy(lunarMonths, 0, monthsOut, 0, monthLeapAbs);
        monthsOut[monthLeapAbs] = "\u95f0" + Util.getLunarNameOfMonth(monthLeapAbs);
        System.arraycopy(lunarMonths, monthLeapAbs, monthsOut, monthLeapAbs + 1, lunarMonths.length - monthLeapAbs);
        twelveMonthWithLeapCache.put(monthLeapAbs, monthsOut);
        return monthsOut;
    }

    public static int convertMonthLunarToMonthSway(int monthLunar, int monthLeap) {
        if (monthLeap > 0) {
            throw new IllegalArgumentException("convertChineseMonthToMonthSway monthLeap should be in range of [-12, 0]");
        }
        if (monthLeap == 0) {
            return monthLunar;
        }
        if (monthLunar == monthLeap) {
            return -monthLunar + 1;
        }
        if (monthLunar < -monthLeap + 1) {
            return monthLunar;
        }
        return monthLunar + 1;
    }

    public static int convertMonthSwayToMonthLunar(int monthSway, int monthLeap) {
        if (monthLeap > 0) {
            throw new IllegalArgumentException("convertChineseMonthToMonthSway monthLeap should be in range of [-12, 0]");
        }
        if (monthLeap == 0) {
            return monthSway;
        }
        if (monthSway == -monthLeap + 1) {
            return monthLeap;
        }
        if (monthSway < -monthLeap + 1) {
            return monthSway;
        }
        return monthSway - 1;
    }

    public static int convertMonthSwayToMonthLunarByYear(int monthSway, int year) {
        int monthLeap = Util.getMonthLeapByYear(year);
        return Util.convertMonthSwayToMonthLunar(monthSway, monthLeap);
    }
}

