/*
 * Decompiled with CFR 0.152.
 */
package com.shuyu.gsyvideoplayer.render.effect;

import android.opengl.GLSurfaceView;
import com.shuyu.gsyvideoplayer.render.view.GSYVideoGLView;
import java.util.Date;
import java.util.Random;

public class DocumentaryEffect
implements GSYVideoGLView.ShaderInterface {
    private int mWidth;
    private int mHeight;
    private Random mRandom;

    private void initValues(GLSurfaceView mGlSurfaceView) {
        this.mWidth = mGlSurfaceView.getWidth();
        this.mHeight = mGlSurfaceView.getHeight();
        this.mRandom = new Random(new Date().getTime());
    }

    @Override
    public String getShader(GLSurfaceView mGlSurfaceView) {
        this.initValues(mGlSurfaceView);
        float[] scale = new float[2];
        if (this.mWidth > this.mHeight) {
            scale[0] = 1.0f;
            scale[1] = (float)this.mHeight / (float)this.mWidth;
        } else {
            scale[0] = (float)this.mWidth / (float)this.mHeight;
            scale[1] = 1.0f;
        }
        float max_dist = (float)Math.sqrt(scale[0] * scale[0] + scale[1] * scale[1]) * 0.5f;
        float[] seed = new float[]{this.mRandom.nextFloat(), this.mRandom.nextFloat()};
        String[] scaleString = new String[2];
        String[] seedString = new String[2];
        scaleString[0] = "scale[0] = " + scale[0] + ";\n";
        scaleString[1] = "scale[1] = " + scale[1] + ";\n";
        seedString[0] = "seed[0] = " + seed[0] + ";\n";
        seedString[1] = "seed[1] = " + seed[1] + ";\n";
        String inv_max_distString = "inv_max_dist = " + 1.0f / max_dist + ";\n";
        String stepsizeString = "stepsize = 0.003921569;\n";
        String shader = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nuniform samplerExternalOES sTexture;\n vec2 seed;\n float stepsize;\n float inv_max_dist;\n vec2 scale;\nvarying vec2 vTextureCoord;\nfloat rand(vec2 loc) {\n  float theta1 = dot(loc, vec2(0.9898, 0.233));\n  float theta2 = dot(loc, vec2(12.0, 78.0));\n  float value = cos(theta1) * sin(theta2) + sin(theta1) * cos(theta2);\n  float temp = mod(197.0 * value, 1.0) + value;\n  float part1 = mod(220.0 * temp, 1.0) + temp;\n  float part2 = value * 0.5453;\n  float part3 = cos(theta1 + theta2) * 0.43758;\n  return fract(part1 + part2 + part3);\n}\nvoid main() {\n" + scaleString[0] + scaleString[1] + seedString[0] + seedString[1] + inv_max_distString + stepsizeString + "  vec4 color = texture2D(sTexture, vTextureCoord);\n  float dither = rand(vTextureCoord + seed);\n  vec3 xform = clamp(2.0 * color.rgb, 0.0, 1.0);\n  vec3 temp = clamp(2.0 * (color.rgb + stepsize), 0.0, 1.0);\n  vec3 new_color = clamp(xform + (temp - xform) * (dither - 0.5), 0.0, 1.0);\n  float gray = dot(new_color, vec3(0.299, 0.587, 0.114));\n  new_color = vec3(gray, gray, gray);\n  vec2 coord = vTextureCoord - vec2(0.5, 0.5);\n  float dist = length(coord * scale);\n  float lumen = 0.85 / (1.0 + exp((dist * inv_max_dist - 0.83) * 20.0)) + 0.15;\n  gl_FragColor = vec4(new_color * lumen, color.a);\n}\n";
        return shader;
    }
}

