/*
 * Decompiled with CFR 0.152.
 */
package com.shuyu.gsyvideoplayer.cache;

import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import com.danikula.videocache.CacheListener;
import com.danikula.videocache.HttpProxyCacheServer;
import com.danikula.videocache.file.Md5FileNameGenerator;
import com.danikula.videocache.headers.HeaderInjector;
import com.shuyu.gsyvideoplayer.cache.ICacheManager;
import com.shuyu.gsyvideoplayer.cache.ProxyCacheUserAgentHeadersInjector;
import com.shuyu.gsyvideoplayer.utils.CommonUtil;
import com.shuyu.gsyvideoplayer.utils.FileUtils;
import com.shuyu.gsyvideoplayer.utils.StorageUtils;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import tv.danmaku.ijk.media.player.IMediaPlayer;

public class ProxyCacheManager
implements ICacheManager,
CacheListener {
    public static int DEFAULT_MAX_SIZE = 0x20000000;
    protected HttpProxyCacheServer proxy;
    protected File mCacheDir;
    protected boolean mCacheFile;
    private static ProxyCacheManager proxyCacheManager;
    private ICacheManager.ICacheAvailableListener cacheAvailableListener;
    protected ProxyCacheUserAgentHeadersInjector userAgentHeadersInjector = new ProxyCacheUserAgentHeadersInjector();

    public static synchronized ProxyCacheManager instance() {
        if (proxyCacheManager == null) {
            proxyCacheManager = new ProxyCacheManager();
        }
        return proxyCacheManager;
    }

    public void onCacheAvailable(File cacheFile, String url, int percentsAvailable) {
        if (this.cacheAvailableListener != null) {
            this.cacheAvailableListener.onCacheAvailable(cacheFile, url, percentsAvailable);
        }
    }

    public void doCacheLogic(Context context, IMediaPlayer mediaPlayer, String originUrl, Map<String, String> header, File cachePath) {
        String url = originUrl;
        ProxyCacheUserAgentHeadersInjector.mMapHeadData.clear();
        if (header != null) {
            ProxyCacheUserAgentHeadersInjector.mMapHeadData.putAll(header);
        }
        if (url.startsWith("http") && !url.contains("127.0.0.1") && !url.contains(".m3u8")) {
            HttpProxyCacheServer proxy = ProxyCacheManager.getProxy(context.getApplicationContext(), cachePath);
            if (proxy != null) {
                boolean bl = this.mCacheFile = !(url = proxy.getProxyUrl(url)).startsWith("http");
                if (!this.mCacheFile) {
                    proxy.registerCacheListener((CacheListener)this, originUrl);
                }
            }
        } else if (!(url.startsWith("http") || url.startsWith("rtmp") || url.startsWith("rtsp") || url.contains(".m3u8"))) {
            this.mCacheFile = true;
        }
        try {
            mediaPlayer.setDataSource(context, Uri.parse((String)url), header);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void clearCache(Context context, File cachePath, String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            String path = StorageUtils.getIndividualCacheDirectory(context.getApplicationContext()).getAbsolutePath();
            FileUtils.deleteFiles(new File(path));
        } else {
            Md5FileNameGenerator md5FileNameGenerator = new Md5FileNameGenerator();
            String name = md5FileNameGenerator.generate(url);
            if (cachePath != null) {
                String tmpPath = cachePath.getAbsolutePath() + File.separator + name + ".download";
                String path = cachePath.getAbsolutePath() + File.separator + name;
                CommonUtil.deleteFile(tmpPath);
                CommonUtil.deleteFile(path);
            } else {
                String pathTmp = StorageUtils.getIndividualCacheDirectory(context.getApplicationContext()).getAbsolutePath() + File.separator + name + ".download";
                String path = StorageUtils.getIndividualCacheDirectory(context.getApplicationContext()).getAbsolutePath() + File.separator + name;
                CommonUtil.deleteFile(pathTmp);
                CommonUtil.deleteFile(path);
            }
        }
    }

    public void release() {
        if (this.proxy != null) {
            try {
                this.proxy.unregisterCacheListener((CacheListener)this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean cachePreview(Context context, File cacheDir, String url) {
        HttpProxyCacheServer proxy = ProxyCacheManager.getProxy(context.getApplicationContext(), cacheDir);
        if (proxy != null) {
            url = proxy.getProxyUrl(url);
        }
        return !url.startsWith("http");
    }

    public boolean hadCached() {
        return this.mCacheFile;
    }

    public void setCacheAvailableListener(ICacheManager.ICacheAvailableListener cacheAvailableListener) {
        this.cacheAvailableListener = cacheAvailableListener;
    }

    public HttpProxyCacheServer newProxy(Context context, File file) {
        if (!file.exists()) {
            file.mkdirs();
        }
        HttpProxyCacheServer.Builder builder = new HttpProxyCacheServer.Builder(context);
        builder.cacheDirectory(file);
        builder.maxCacheSize((long)DEFAULT_MAX_SIZE);
        builder.headerInjector((HeaderInjector)this.userAgentHeadersInjector);
        this.mCacheDir = file;
        return builder.build();
    }

    public void setProxy(HttpProxyCacheServer proxy) {
        this.proxy = proxy;
    }

    public HttpProxyCacheServer newProxy(Context context) {
        return new HttpProxyCacheServer.Builder(context.getApplicationContext()).headerInjector((HeaderInjector)this.userAgentHeadersInjector).build();
    }

    protected static HttpProxyCacheServer getProxy(Context context) {
        HttpProxyCacheServer proxy = ProxyCacheManager.instance().proxy;
        return proxy == null ? (ProxyCacheManager.instance().proxy = ProxyCacheManager.instance().newProxy(context)) : proxy;
    }

    public static HttpProxyCacheServer getProxy(Context context, File file) {
        if (file == null) {
            return ProxyCacheManager.getProxy(context);
        }
        if (ProxyCacheManager.instance().mCacheDir != null && !ProxyCacheManager.instance().mCacheDir.getAbsolutePath().equals(file.getAbsolutePath())) {
            HttpProxyCacheServer proxy = ProxyCacheManager.instance().proxy;
            if (proxy != null) {
                proxy.shutdown();
            }
            ProxyCacheManager.instance().proxy = ProxyCacheManager.instance().newProxy(context, file);
            return ProxyCacheManager.instance().proxy;
        }
        HttpProxyCacheServer proxy = ProxyCacheManager.instance().proxy;
        return proxy == null ? (ProxyCacheManager.instance().proxy = ProxyCacheManager.instance().newProxy(context, file)) : proxy;
    }
}

