/*
 * Decompiled with CFR 0.152.
 */
package com.shuyu.gsyvideoplayer.video.base;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import androidx.annotation.AttrRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.shuyu.gsyvideoplayer.R;
import com.shuyu.gsyvideoplayer.listener.GSYVideoProgressListener;
import com.shuyu.gsyvideoplayer.listener.LockClickListener;
import com.shuyu.gsyvideoplayer.utils.CommonUtil;
import com.shuyu.gsyvideoplayer.utils.Debuger;
import com.shuyu.gsyvideoplayer.video.base.GSYVideoView;
import java.io.File;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public abstract class GSYVideoControlView
extends GSYVideoView
implements View.OnClickListener,
View.OnTouchListener,
SeekBar.OnSeekBarChangeListener {
    protected int mDownPosition;
    protected int mGestureDownVolume;
    protected int mThreshold = 80;
    protected int mSeekTimePosition;
    protected int mSeekEndOffset;
    protected int mShrinkImageRes = -1;
    protected int mEnlargeImageRes = -1;
    protected int mDismissControlTime = 2500;
    protected float mDownX;
    protected float mDownY;
    protected float mMoveY;
    protected float mBrightnessData = -1.0f;
    protected float mSeekRatio = 1.0f;
    protected boolean mTouchingProgressBar = false;
    protected boolean mChangeVolume = false;
    protected boolean mChangePosition = false;
    protected boolean mShowVKey = false;
    protected boolean mBrightness = false;
    protected boolean mFirstTouch = false;
    protected boolean mHideKey = true;
    protected boolean mNeedShowWifiTip = true;
    protected boolean mIsTouchWiget = true;
    protected boolean mIsTouchWigetFull = true;
    protected boolean mThumbPlay;
    protected boolean mLockCurScreen;
    protected boolean mNeedLockFull;
    protected boolean mSetUpLazy = false;
    protected boolean mHadSeekTouch = false;
    protected View mStartButton;
    protected View mThumbImageView;
    protected View mLoadingProgressBar;
    protected SeekBar mProgressBar;
    protected ImageView mFullscreenButton;
    protected ImageView mBackButton;
    protected ImageView mLockScreen;
    protected TextView mCurrentTimeTextView;
    protected TextView mTotalTimeTextView;
    protected TextView mTitleTextView;
    protected ViewGroup mTopContainer;
    protected ViewGroup mBottomContainer;
    protected RelativeLayout mThumbImageViewLayout;
    protected ProgressBar mBottomProgressBar;
    protected Timer updateProcessTimer;
    protected Timer mDismissControlViewTimer;
    protected ProgressTimerTask mProgressTimerTask;
    protected LockClickListener mLockClickListener;
    protected DismissControlViewTimerTask mDismissControlViewTimerTask;
    protected GSYVideoProgressListener mGSYVideoProgressListener;
    protected GestureDetector gestureDetector = new GestureDetector(this.getContext().getApplicationContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

        public boolean onDoubleTap(MotionEvent e) {
            GSYVideoControlView.this.touchDoubleUp();
            return super.onDoubleTap(e);
        }

        public boolean onSingleTapConfirmed(MotionEvent e) {
            if (!(GSYVideoControlView.this.mChangePosition || GSYVideoControlView.this.mChangeVolume || GSYVideoControlView.this.mBrightness)) {
                GSYVideoControlView.this.onClickUiToggle();
            }
            return super.onSingleTapConfirmed(e);
        }
    });

    public GSYVideoControlView(@NonNull Context context) {
        super(context);
    }

    public GSYVideoControlView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public GSYVideoControlView(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public GSYVideoControlView(Context context, Boolean fullFlag) {
        super(context, fullFlag);
    }

    @Override
    protected void init(Context context) {
        super.init(context);
        this.mStartButton = this.findViewById(R.id.start);
        this.mTitleTextView = (TextView)this.findViewById(R.id.title);
        this.mBackButton = (ImageView)this.findViewById(R.id.back);
        this.mFullscreenButton = (ImageView)this.findViewById(R.id.fullscreen);
        this.mProgressBar = (SeekBar)this.findViewById(R.id.progress);
        this.mCurrentTimeTextView = (TextView)this.findViewById(R.id.current);
        this.mTotalTimeTextView = (TextView)this.findViewById(R.id.total);
        this.mBottomContainer = (ViewGroup)this.findViewById(R.id.layout_bottom);
        this.mTopContainer = (ViewGroup)this.findViewById(R.id.layout_top);
        this.mBottomProgressBar = (ProgressBar)this.findViewById(R.id.bottom_progressbar);
        this.mThumbImageViewLayout = (RelativeLayout)this.findViewById(R.id.thumb);
        this.mLockScreen = (ImageView)this.findViewById(R.id.lock_screen);
        this.mLoadingProgressBar = this.findViewById(R.id.loading);
        if (this.isInEditMode()) {
            return;
        }
        if (this.mStartButton != null) {
            this.mStartButton.setOnClickListener((View.OnClickListener)this);
        }
        if (this.mFullscreenButton != null) {
            this.mFullscreenButton.setOnClickListener((View.OnClickListener)this);
            this.mFullscreenButton.setOnTouchListener((View.OnTouchListener)this);
        }
        if (this.mProgressBar != null) {
            this.mProgressBar.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)this);
        }
        if (this.mBottomContainer != null) {
            this.mBottomContainer.setOnClickListener((View.OnClickListener)this);
        }
        if (this.mTextureViewContainer != null) {
            this.mTextureViewContainer.setOnClickListener((View.OnClickListener)this);
            this.mTextureViewContainer.setOnTouchListener((View.OnTouchListener)this);
        }
        if (this.mProgressBar != null) {
            this.mProgressBar.setOnTouchListener((View.OnTouchListener)this);
        }
        if (this.mThumbImageViewLayout != null) {
            this.mThumbImageViewLayout.setVisibility(8);
            this.mThumbImageViewLayout.setOnClickListener((View.OnClickListener)this);
        }
        if (this.mThumbImageView != null && !this.mIfCurrentIsFullscreen && this.mThumbImageViewLayout != null) {
            this.mThumbImageViewLayout.removeAllViews();
            this.resolveThumbImage(this.mThumbImageView);
        }
        if (this.mBackButton != null) {
            this.mBackButton.setOnClickListener((View.OnClickListener)this);
        }
        if (this.mLockScreen != null) {
            this.mLockScreen.setVisibility(8);
            this.mLockScreen.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (GSYVideoControlView.this.mCurrentState == 6 || GSYVideoControlView.this.mCurrentState == 7) {
                        return;
                    }
                    GSYVideoControlView.this.lockTouchLogic();
                    if (GSYVideoControlView.this.mLockClickListener != null) {
                        GSYVideoControlView.this.mLockClickListener.onClick(v, GSYVideoControlView.this.mLockCurScreen);
                    }
                }
            });
        }
        if (this.getActivityContext() != null) {
            this.mSeekEndOffset = CommonUtil.dip2px(this.getActivityContext(), 50.0f);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        Debuger.printfLog(this.hashCode() + "------------------------------ dismiss onDetachedFromWindow");
        this.cancelProgressTimer();
        this.cancelDismissControlViewTimer();
    }

    @Override
    public void onAutoCompletion() {
        super.onAutoCompletion();
        if (this.mLockCurScreen) {
            this.lockTouchLogic();
            this.mLockScreen.setVisibility(8);
        }
    }

    @Override
    public void onError(int what, int extra) {
        super.onError(what, extra);
        if (this.mLockCurScreen) {
            this.lockTouchLogic();
            this.mLockScreen.setVisibility(8);
        }
    }

    @Override
    protected void setStateAndUi(int state) {
        this.mCurrentState = state;
        if (state == 0 && this.isCurrentMediaListener() || state == 6 || state == 7) {
            this.mHadPrepared = false;
        }
        switch (this.mCurrentState) {
            case 0: {
                if (this.isCurrentMediaListener()) {
                    Debuger.printfLog(this.hashCode() + "------------------------------ dismiss CURRENT_STATE_NORMAL");
                    this.cancelProgressTimer();
                    this.getGSYVideoManager().releaseMediaPlayer();
                    this.releasePauseCover();
                    this.mBufferPoint = 0;
                    this.mSaveChangeViewTIme = 0L;
                    if (this.mAudioManager != null) {
                        this.mAudioManager.abandonAudioFocus(this.onAudioFocusChangeListener);
                    }
                }
                this.releaseNetWorkState();
                break;
            }
            case 1: {
                this.resetProgressAndTime();
                break;
            }
            case 2: {
                if (!this.isCurrentMediaListener()) break;
                Debuger.printfLog(this.hashCode() + "------------------------------ CURRENT_STATE_PLAYING");
                this.startProgressTimer();
                break;
            }
            case 5: {
                Debuger.printfLog(this.hashCode() + "------------------------------ CURRENT_STATE_PAUSE");
                this.startProgressTimer();
                break;
            }
            case 7: {
                if (!this.isCurrentMediaListener()) break;
                this.getGSYVideoManager().releaseMediaPlayer();
                break;
            }
            case 6: {
                Debuger.printfLog(this.hashCode() + "------------------------------ dismiss CURRENT_STATE_AUTO_COMPLETE");
                this.cancelProgressTimer();
                if (this.mProgressBar != null) {
                    this.mProgressBar.setProgress(100);
                }
                if (this.mCurrentTimeTextView != null && this.mTotalTimeTextView != null) {
                    this.mCurrentTimeTextView.setText(this.mTotalTimeTextView.getText());
                }
                if (this.mBottomProgressBar == null) break;
                this.mBottomProgressBar.setProgress(100);
            }
        }
        this.resolveUIState(state);
    }

    @Override
    protected void setSmallVideoTextureView(View.OnTouchListener onTouchListener) {
        super.setSmallVideoTextureView(onTouchListener);
        if (this.mThumbImageViewLayout != null) {
            this.mThumbImageViewLayout.setOnTouchListener(onTouchListener);
        }
    }

    public void onClick(View v) {
        int i = v.getId();
        if (this.mHideKey && this.mIfCurrentIsFullscreen) {
            CommonUtil.hideNavKey(this.mContext);
        }
        if (i == R.id.start) {
            this.clickStartIcon();
        } else if (i == R.id.surface_container && this.mCurrentState == 7) {
            if (this.mVideoAllCallBack != null) {
                Debuger.printfLog("onClickStartError");
                this.mVideoAllCallBack.onClickStartError(this.mOriginUrl, this.mTitle, this);
            }
            this.prepareVideo();
        } else if (i == R.id.thumb) {
            if (!this.mThumbPlay) {
                return;
            }
            if (TextUtils.isEmpty((CharSequence)this.mUrl)) {
                Debuger.printfError("********" + this.getResources().getString(R.string.no_url));
                return;
            }
            if (this.mCurrentState == 0) {
                if (this.isShowNetConfirm()) {
                    this.showWifiDialog();
                    return;
                }
                this.startPlayLogic();
            } else if (this.mCurrentState == 6) {
                this.onClickUiToggle();
            }
        } else if (i == R.id.surface_container) {
            if (this.mVideoAllCallBack != null && this.isCurrentMediaListener()) {
                if (this.mIfCurrentIsFullscreen) {
                    Debuger.printfLog("onClickBlankFullscreen");
                    this.mVideoAllCallBack.onClickBlankFullscreen(this.mOriginUrl, this.mTitle, this);
                } else {
                    Debuger.printfLog("onClickBlank");
                    this.mVideoAllCallBack.onClickBlank(this.mOriginUrl, this.mTitle, this);
                }
            }
            this.startDismissControlViewTimer();
        }
    }

    public boolean onTouch(View v, MotionEvent event) {
        int id2 = v.getId();
        float x = event.getX();
        float y = event.getY();
        if (this.mIfCurrentIsFullscreen && this.mLockCurScreen && this.mNeedLockFull) {
            this.onClickUiToggle();
            this.startDismissControlViewTimer();
            return true;
        }
        if (id2 == R.id.fullscreen) {
            return false;
        }
        if (id2 == R.id.surface_container) {
            switch (event.getAction()) {
                case 0: {
                    this.touchSurfaceDown(x, y);
                    break;
                }
                case 2: {
                    float deltaX = x - this.mDownX;
                    float deltaY = y - this.mDownY;
                    float absDeltaX = Math.abs(deltaX);
                    float absDeltaY = Math.abs(deltaY);
                    if ((this.mIfCurrentIsFullscreen && this.mIsTouchWigetFull || this.mIsTouchWiget && !this.mIfCurrentIsFullscreen) && !this.mChangePosition && !this.mChangeVolume && !this.mBrightness) {
                        this.touchSurfaceMoveFullLogic(absDeltaX, absDeltaY);
                    }
                    this.touchSurfaceMove(deltaX, deltaY, y);
                    break;
                }
                case 1: {
                    this.startDismissControlViewTimer();
                    this.touchSurfaceUp();
                    Debuger.printfLog(this.hashCode() + "------------------------------ surface_container ACTION_UP");
                    this.startProgressTimer();
                    if (!this.mHideKey || !this.mShowVKey) break;
                    return true;
                }
            }
            this.gestureDetector.onTouchEvent(event);
        } else if (id2 == R.id.progress) {
            switch (event.getAction()) {
                case 0: {
                    this.cancelDismissControlViewTimer();
                }
                case 2: {
                    this.cancelProgressTimer();
                    for (ViewParent vpdown = this.getParent(); vpdown != null; vpdown = vpdown.getParent()) {
                        vpdown.requestDisallowInterceptTouchEvent(true);
                    }
                    break;
                }
                case 1: {
                    this.startDismissControlViewTimer();
                    Debuger.printfLog(this.hashCode() + "------------------------------ progress ACTION_UP");
                    this.startProgressTimer();
                    for (ViewParent vpup = this.getParent(); vpup != null; vpup = vpup.getParent()) {
                        vpup.requestDisallowInterceptTouchEvent(false);
                    }
                    this.mBrightnessData = -1.0f;
                }
            }
        }
        return false;
    }

    @Override
    public boolean setUp(String url, boolean cacheWithPlay, String title) {
        return this.setUp(url, cacheWithPlay, null, title);
    }

    @Override
    public boolean setUp(String url, boolean cacheWithPlay, File cachePath, String title) {
        if (super.setUp(url, cacheWithPlay, cachePath, title)) {
            if (title != null && this.mTitleTextView != null) {
                this.mTitleTextView.setText((CharSequence)title);
            }
            if (this.mIfCurrentIsFullscreen) {
                if (this.mFullscreenButton != null) {
                    this.mFullscreenButton.setImageResource(this.getShrinkImageRes());
                }
            } else if (this.mFullscreenButton != null) {
                this.mFullscreenButton.setImageResource(this.getEnlargeImageRes());
            }
            return true;
        }
        return false;
    }

    public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
    }

    public void onStartTrackingTouch(SeekBar seekBar) {
        this.mHadSeekTouch = true;
    }

    public void onStopTrackingTouch(SeekBar seekBar) {
        if (this.mVideoAllCallBack != null && this.isCurrentMediaListener()) {
            if (this.isIfCurrentIsFullscreen()) {
                Debuger.printfLog("onClickSeekbarFullscreen");
                this.mVideoAllCallBack.onClickSeekbarFullscreen(this.mOriginUrl, this.mTitle, this);
            } else {
                Debuger.printfLog("onClickSeekbar");
                this.mVideoAllCallBack.onClickSeekbar(this.mOriginUrl, this.mTitle, this);
            }
        }
        if (this.getGSYVideoManager() != null && this.mHadPlay) {
            try {
                int time = seekBar.getProgress() * this.getDuration() / 100;
                this.getGSYVideoManager().seekTo(time);
            }
            catch (Exception e) {
                Debuger.printfWarning(e.toString());
            }
        }
        this.mHadSeekTouch = false;
    }

    @Override
    public void onPrepared() {
        super.onPrepared();
        if (this.mCurrentState != 1) {
            return;
        }
        this.startProgressTimer();
        Debuger.printfLog(this.hashCode() + "------------------------------ surface_container onPrepared");
    }

    @Override
    public void onBufferingUpdate(final int percent) {
        this.post(new Runnable(){

            @Override
            public void run() {
                if (GSYVideoControlView.this.mCurrentState != 0 && GSYVideoControlView.this.mCurrentState != 1) {
                    if (percent != 0) {
                        GSYVideoControlView.this.setTextAndProgress(percent);
                        GSYVideoControlView.this.mBufferPoint = percent;
                        Debuger.printfLog("Net speed: " + GSYVideoControlView.this.getNetSpeedText() + " percent " + percent);
                    }
                    if (GSYVideoControlView.this.mProgressBar == null) {
                        return;
                    }
                    if (GSYVideoControlView.this.mLooping && GSYVideoControlView.this.mHadPlay && percent == 0 && GSYVideoControlView.this.mProgressBar.getProgress() >= GSYVideoControlView.this.mProgressBar.getMax() - 1) {
                        GSYVideoControlView.this.loopSetProgressAndTime();
                    }
                }
            }
        });
    }

    @Override
    protected void prepareVideo() {
        if (this.mSetUpLazy) {
            super.setUp(this.mOriginUrl, this.mCache, this.mCachePath, this.mMapHeadData, this.mTitle);
        }
        super.prepareVideo();
    }

    protected void touchSurfaceDown(float x, float y) {
        this.mTouchingProgressBar = true;
        this.mDownX = x;
        this.mDownY = y;
        this.mMoveY = 0.0f;
        this.mChangeVolume = false;
        this.mChangePosition = false;
        this.mShowVKey = false;
        this.mBrightness = false;
        this.mFirstTouch = true;
    }

    protected void touchSurfaceMove(float deltaX, float deltaY, float y) {
        int curWidth = 0;
        int curHeight = 0;
        if (this.getActivityContext() != null) {
            curWidth = CommonUtil.getCurrentScreenLand((Activity)this.getActivityContext()) ? this.mScreenHeight : this.mScreenWidth;
            int n = curHeight = CommonUtil.getCurrentScreenLand((Activity)this.getActivityContext()) ? this.mScreenWidth : this.mScreenHeight;
        }
        if (this.mChangePosition) {
            int totalTimeDuration = this.getDuration();
            this.mSeekTimePosition = (int)((float)this.mDownPosition + deltaX * (float)totalTimeDuration / (float)curWidth / this.mSeekRatio);
            if (this.mSeekTimePosition > totalTimeDuration) {
                this.mSeekTimePosition = totalTimeDuration;
            }
            String seekTime = CommonUtil.stringForTime(this.mSeekTimePosition);
            String totalTime = CommonUtil.stringForTime(totalTimeDuration);
            this.showProgressDialog(deltaX, seekTime, this.mSeekTimePosition, totalTime, totalTimeDuration);
        } else if (this.mChangeVolume) {
            deltaY = -deltaY;
            int max = this.mAudioManager.getStreamMaxVolume(3);
            int deltaV = (int)((float)max * deltaY * 3.0f / (float)curHeight);
            this.mAudioManager.setStreamVolume(3, this.mGestureDownVolume + deltaV, 0);
            int volumePercent = (int)((float)(this.mGestureDownVolume * 100 / max) + deltaY * 3.0f * 100.0f / (float)curHeight);
            this.showVolumeDialog(-deltaY, volumePercent);
        } else if (!this.mChangePosition && this.mBrightness && Math.abs(deltaY) > (float)this.mThreshold) {
            float percent = -deltaY / (float)curHeight;
            this.onBrightnessSlide(percent);
            this.mDownY = y;
        }
    }

    protected void touchSurfaceMoveFullLogic(float absDeltaX, float absDeltaY) {
        int curWidth = 0;
        if (this.getActivityContext() != null) {
            int n = curWidth = CommonUtil.getCurrentScreenLand((Activity)this.getActivityContext()) ? this.mScreenHeight : this.mScreenWidth;
        }
        if (absDeltaX > (float)this.mThreshold || absDeltaY > (float)this.mThreshold) {
            this.cancelProgressTimer();
            if (absDeltaX >= (float)this.mThreshold) {
                int screenWidth = CommonUtil.getScreenWidth(this.getContext());
                if (Math.abs((float)screenWidth - this.mDownX) > (float)this.mSeekEndOffset) {
                    this.mChangePosition = true;
                    this.mDownPosition = this.getCurrentPositionWhenPlaying();
                } else {
                    this.mShowVKey = true;
                }
            } else {
                boolean noEnd;
                int screenHeight = CommonUtil.getScreenHeight(this.getContext());
                boolean bl = noEnd = Math.abs((float)screenHeight - this.mDownY) > (float)this.mSeekEndOffset;
                if (this.mFirstTouch) {
                    this.mBrightness = this.mDownX < (float)curWidth * 0.5f && noEnd;
                    this.mFirstTouch = false;
                }
                if (!this.mBrightness) {
                    this.mChangeVolume = noEnd;
                    this.mGestureDownVolume = this.mAudioManager.getStreamVolume(3);
                }
                this.mShowVKey = !noEnd;
            }
        }
    }

    protected void touchSurfaceUp() {
        int progress;
        if (this.mChangePosition) {
            int duration = this.getDuration();
            progress = this.mSeekTimePosition * 100 / (duration == 0 ? 1 : duration);
            if (this.mBottomProgressBar != null) {
                this.mBottomProgressBar.setProgress(progress);
            }
        }
        this.mTouchingProgressBar = false;
        this.dismissProgressDialog();
        this.dismissVolumeDialog();
        this.dismissBrightnessDialog();
        if (this.mChangePosition && this.getGSYVideoManager() != null && (this.mCurrentState == 2 || this.mCurrentState == 5)) {
            try {
                this.getGSYVideoManager().seekTo(this.mSeekTimePosition);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            int duration = this.getDuration();
            progress = this.mSeekTimePosition * 100 / (duration == 0 ? 1 : duration);
            if (this.mProgressBar != null) {
                this.mProgressBar.setProgress(progress);
            }
            if (this.mVideoAllCallBack != null && this.isCurrentMediaListener()) {
                Debuger.printfLog("onTouchScreenSeekPosition");
                this.mVideoAllCallBack.onTouchScreenSeekPosition(this.mOriginUrl, this.mTitle, this);
            }
        } else if (this.mBrightness) {
            if (this.mVideoAllCallBack != null && this.isCurrentMediaListener()) {
                Debuger.printfLog("onTouchScreenSeekLight");
                this.mVideoAllCallBack.onTouchScreenSeekLight(this.mOriginUrl, this.mTitle, this);
            }
        } else if (this.mChangeVolume && this.mVideoAllCallBack != null && this.isCurrentMediaListener()) {
            Debuger.printfLog("onTouchScreenSeekVolume");
            this.mVideoAllCallBack.onTouchScreenSeekVolume(this.mOriginUrl, this.mTitle, this);
        }
    }

    protected void touchDoubleUp() {
        if (!this.mHadPlay) {
            return;
        }
        this.clickStartIcon();
    }

    protected void resolveUIState(int state) {
        switch (state) {
            case 0: {
                this.changeUiToNormal();
                this.cancelDismissControlViewTimer();
                break;
            }
            case 1: {
                this.changeUiToPreparingShow();
                this.startDismissControlViewTimer();
                break;
            }
            case 2: {
                this.changeUiToPlayingShow();
                this.startDismissControlViewTimer();
                break;
            }
            case 5: {
                this.changeUiToPauseShow();
                this.cancelDismissControlViewTimer();
                break;
            }
            case 7: {
                this.changeUiToError();
                break;
            }
            case 6: {
                this.changeUiToCompleteShow();
                this.cancelDismissControlViewTimer();
                break;
            }
            case 3: {
                this.changeUiToPlayingBufferingShow();
            }
        }
    }

    protected void clickStartIcon() {
        if (TextUtils.isEmpty((CharSequence)this.mUrl)) {
            Debuger.printfError("********" + this.getResources().getString(R.string.no_url));
            return;
        }
        if (this.mCurrentState == 0 || this.mCurrentState == 7) {
            if (this.isShowNetConfirm()) {
                this.showWifiDialog();
                return;
            }
            this.startButtonLogic();
        } else if (this.mCurrentState == 2) {
            try {
                this.onVideoPause();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.setStateAndUi(5);
            if (this.mVideoAllCallBack != null && this.isCurrentMediaListener()) {
                if (this.mIfCurrentIsFullscreen) {
                    Debuger.printfLog("onClickStopFullscreen");
                    this.mVideoAllCallBack.onClickStopFullscreen(this.mOriginUrl, this.mTitle, this);
                } else {
                    Debuger.printfLog("onClickStop");
                    this.mVideoAllCallBack.onClickStop(this.mOriginUrl, this.mTitle, this);
                }
            }
        } else if (this.mCurrentState == 5) {
            if (this.mVideoAllCallBack != null && this.isCurrentMediaListener()) {
                if (this.mIfCurrentIsFullscreen) {
                    Debuger.printfLog("onClickResumeFullscreen");
                    this.mVideoAllCallBack.onClickResumeFullscreen(this.mOriginUrl, this.mTitle, this);
                } else {
                    Debuger.printfLog("onClickResume");
                    this.mVideoAllCallBack.onClickResume(this.mOriginUrl, this.mTitle, this);
                }
            }
            if (!this.mHadPlay && !this.mStartAfterPrepared) {
                this.startAfterPrepared();
            }
            try {
                this.getGSYVideoManager().start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.setStateAndUi(2);
        } else if (this.mCurrentState == 6) {
            this.startButtonLogic();
        }
    }

    protected void lockTouchLogic() {
        if (this.mLockCurScreen) {
            this.mLockScreen.setImageResource(R.drawable.unlock);
            this.mLockCurScreen = false;
        } else {
            this.mLockScreen.setImageResource(R.drawable.lock);
            this.mLockCurScreen = true;
            this.hideAllWidget();
        }
    }

    protected void startProgressTimer() {
        this.cancelProgressTimer();
        this.updateProcessTimer = new Timer();
        this.mProgressTimerTask = new ProgressTimerTask();
        this.updateProcessTimer.schedule((TimerTask)this.mProgressTimerTask, 0L, 300L);
    }

    protected void cancelProgressTimer() {
        if (this.updateProcessTimer != null) {
            this.updateProcessTimer.cancel();
            this.updateProcessTimer = null;
        }
        if (this.mProgressTimerTask != null) {
            this.mProgressTimerTask.cancel();
            this.mProgressTimerTask = null;
        }
    }

    protected void setTextAndProgress(int secProgress) {
        int position = this.getCurrentPositionWhenPlaying();
        int duration = this.getDuration();
        int progress = position * 100 / (duration == 0 ? 1 : duration);
        this.setProgressAndTime(progress, secProgress, position, duration);
        this.setProgressAndTime(progress, secProgress, position, duration);
    }

    protected void setProgressAndTime(int progress, int secProgress, int currentTime, int totalTime) {
        if (this.mGSYVideoProgressListener != null && this.mCurrentState == 2) {
            this.mGSYVideoProgressListener.onProgress(progress, secProgress, currentTime, totalTime);
        }
        if (this.mProgressBar == null || this.mTotalTimeTextView == null || this.mCurrentTimeTextView == null) {
            return;
        }
        if (this.mHadSeekTouch) {
            return;
        }
        if (!this.mTouchingProgressBar && progress != 0) {
            this.mProgressBar.setProgress(progress);
        }
        if (this.getGSYVideoManager().getBufferedPercentage() > 0) {
            secProgress = this.getGSYVideoManager().getBufferedPercentage();
        }
        if (secProgress > 94) {
            secProgress = 100;
        }
        this.setSecondaryProgress(secProgress);
        this.mTotalTimeTextView.setText((CharSequence)CommonUtil.stringForTime(totalTime));
        if (currentTime > 0) {
            this.mCurrentTimeTextView.setText((CharSequence)CommonUtil.stringForTime(currentTime));
        }
        if (this.mBottomProgressBar != null) {
            if (progress != 0) {
                this.mBottomProgressBar.setProgress(progress);
            }
            this.setSecondaryProgress(secProgress);
        }
    }

    protected void setSecondaryProgress(int secProgress) {
        if (this.mProgressBar != null && secProgress != 0 && !this.getGSYVideoManager().isCacheFile()) {
            this.mProgressBar.setSecondaryProgress(secProgress);
        }
        if (this.mBottomProgressBar != null && secProgress != 0 && !this.getGSYVideoManager().isCacheFile()) {
            this.mBottomProgressBar.setSecondaryProgress(secProgress);
        }
    }

    protected void resetProgressAndTime() {
        if (this.mProgressBar == null || this.mTotalTimeTextView == null || this.mCurrentTimeTextView == null) {
            return;
        }
        this.mProgressBar.setProgress(0);
        this.mProgressBar.setSecondaryProgress(0);
        this.mCurrentTimeTextView.setText((CharSequence)CommonUtil.stringForTime(0));
        this.mTotalTimeTextView.setText((CharSequence)CommonUtil.stringForTime(0));
        if (this.mBottomProgressBar != null) {
            this.mBottomProgressBar.setProgress(0);
            this.mBottomProgressBar.setSecondaryProgress(0);
        }
    }

    protected void loopSetProgressAndTime() {
        if (this.mProgressBar == null || this.mTotalTimeTextView == null || this.mCurrentTimeTextView == null) {
            return;
        }
        this.mProgressBar.setProgress(0);
        this.mProgressBar.setSecondaryProgress(0);
        this.mCurrentTimeTextView.setText((CharSequence)CommonUtil.stringForTime(0));
        if (this.mBottomProgressBar != null) {
            this.mBottomProgressBar.setProgress(0);
        }
    }

    protected void startDismissControlViewTimer() {
        this.cancelDismissControlViewTimer();
        this.mDismissControlViewTimer = new Timer();
        this.mDismissControlViewTimerTask = new DismissControlViewTimerTask();
        this.mDismissControlViewTimer.schedule((TimerTask)this.mDismissControlViewTimerTask, this.mDismissControlTime);
    }

    protected void cancelDismissControlViewTimer() {
        if (this.mDismissControlViewTimer != null) {
            this.mDismissControlViewTimer.cancel();
            this.mDismissControlViewTimer = null;
        }
        if (this.mDismissControlViewTimerTask != null) {
            this.mDismissControlViewTimerTask.cancel();
            this.mDismissControlViewTimerTask = null;
        }
    }

    protected void resolveThumbImage(View thumb) {
        if (this.mThumbImageViewLayout != null) {
            this.mThumbImageViewLayout.removeAllViews();
            this.mThumbImageViewLayout.addView(thumb);
            ViewGroup.LayoutParams layoutParams = thumb.getLayoutParams();
            layoutParams.height = -1;
            layoutParams.width = -1;
            thumb.setLayoutParams(layoutParams);
        }
    }

    protected void setViewShowState(View view, int visibility) {
        if (view != null) {
            view.setVisibility(visibility);
        }
    }

    protected void onBrightnessSlide(float percent) {
        this.mBrightnessData = ((Activity)this.mContext).getWindow().getAttributes().screenBrightness;
        if (this.mBrightnessData <= 0.0f) {
            this.mBrightnessData = 0.5f;
        } else if (this.mBrightnessData < 0.01f) {
            this.mBrightnessData = 0.01f;
        }
        WindowManager.LayoutParams lpa = ((Activity)this.mContext).getWindow().getAttributes();
        lpa.screenBrightness = this.mBrightnessData + percent;
        if (lpa.screenBrightness > 1.0f) {
            lpa.screenBrightness = 1.0f;
        } else if (lpa.screenBrightness < 0.01f) {
            lpa.screenBrightness = 0.01f;
        }
        this.showBrightnessDialog(lpa.screenBrightness);
        ((Activity)this.mContext).getWindow().setAttributes(lpa);
    }

    protected boolean isShowNetConfirm() {
        return !this.mOriginUrl.startsWith("file") && !this.mOriginUrl.startsWith("android.resource") && !CommonUtil.isWifiConnected(this.getContext()) && this.mNeedShowWifiTip && !this.getGSYVideoManager().cachePreview(this.mContext.getApplicationContext(), this.mCachePath, this.mOriginUrl);
    }

    protected abstract void showWifiDialog();

    protected abstract void showProgressDialog(float var1, String var2, int var3, String var4, int var5);

    protected abstract void dismissProgressDialog();

    protected abstract void showVolumeDialog(float var1, int var2);

    protected abstract void dismissVolumeDialog();

    protected abstract void showBrightnessDialog(float var1);

    protected abstract void dismissBrightnessDialog();

    protected abstract void onClickUiToggle();

    protected abstract void hideAllWidget();

    protected abstract void changeUiToNormal();

    protected abstract void changeUiToPreparingShow();

    protected abstract void changeUiToPlayingShow();

    protected abstract void changeUiToPauseShow();

    protected abstract void changeUiToError();

    protected abstract void changeUiToCompleteShow();

    protected abstract void changeUiToPlayingBufferingShow();

    public boolean setUpLazy(String url, boolean cacheWithPlay, File cachePath, Map<String, String> mapHeadData, String title) {
        this.mOriginUrl = url;
        this.mCache = cacheWithPlay;
        this.mCachePath = cachePath;
        this.mSetUpLazy = true;
        this.mTitle = title;
        this.mMapHeadData = mapHeadData;
        if (this.isCurrentMediaListener() && System.currentTimeMillis() - this.mSaveChangeViewTIme < 2000L) {
            return false;
        }
        this.mUrl = "waiting";
        this.mCurrentState = 0;
        return true;
    }

    public void initUIState() {
        this.setStateAndUi(0);
    }

    public RelativeLayout getThumbImageViewLayout() {
        return this.mThumbImageViewLayout;
    }

    public void setThumbImageView(View view) {
        if (this.mThumbImageViewLayout != null) {
            this.mThumbImageView = view;
            this.resolveThumbImage(view);
        }
    }

    public void clearThumbImageView() {
        if (this.mThumbImageViewLayout != null) {
            this.mThumbImageViewLayout.removeAllViews();
        }
    }

    public View getThumbImageView() {
        return this.mThumbImageView;
    }

    public TextView getTitleTextView() {
        return this.mTitleTextView;
    }

    public View getStartButton() {
        return this.mStartButton;
    }

    public ImageView getFullscreenButton() {
        return this.mFullscreenButton;
    }

    public ImageView getBackButton() {
        return this.mBackButton;
    }

    public int getEnlargeImageRes() {
        if (this.mEnlargeImageRes == -1) {
            return R.drawable.video_enlarge;
        }
        return this.mEnlargeImageRes;
    }

    public void setEnlargeImageRes(int mEnlargeImageRes) {
        this.mEnlargeImageRes = mEnlargeImageRes;
    }

    public int getShrinkImageRes() {
        if (this.mShrinkImageRes == -1) {
            return R.drawable.video_shrink;
        }
        return this.mShrinkImageRes;
    }

    public void setShrinkImageRes(int mShrinkImageRes) {
        this.mShrinkImageRes = mShrinkImageRes;
    }

    public void setIsTouchWigetFull(boolean isTouchWigetFull) {
        this.mIsTouchWigetFull = isTouchWigetFull;
    }

    public void setThumbPlay(boolean thumbPlay) {
        this.mThumbPlay = thumbPlay;
    }

    public boolean isHideKey() {
        return this.mHideKey;
    }

    public void setHideKey(boolean hideKey) {
        this.mHideKey = hideKey;
    }

    public boolean isNeedShowWifiTip() {
        return this.mNeedShowWifiTip;
    }

    public boolean isTouchWiget() {
        return this.mIsTouchWiget;
    }

    public void setIsTouchWiget(boolean isTouchWiget) {
        this.mIsTouchWiget = isTouchWiget;
    }

    public boolean isTouchWigetFull() {
        return this.mIsTouchWigetFull;
    }

    public void setNeedShowWifiTip(boolean needShowWifiTip) {
        this.mNeedShowWifiTip = needShowWifiTip;
    }

    public void setSeekRatio(float seekRatio) {
        if (seekRatio < 0.0f) {
            return;
        }
        this.mSeekRatio = seekRatio;
    }

    public float getSeekRatio() {
        return this.mSeekRatio;
    }

    public boolean isNeedLockFull() {
        return this.mNeedLockFull;
    }

    public void setNeedLockFull(boolean needLoadFull) {
        this.mNeedLockFull = needLoadFull;
    }

    public void setLockClickListener(LockClickListener lockClickListener) {
        this.mLockClickListener = lockClickListener;
    }

    public void setDismissControlTime(int dismissControlTime) {
        this.mDismissControlTime = dismissControlTime;
    }

    public int getDismissControlTime() {
        return this.mDismissControlTime;
    }

    public void setGSYVideoProgressListener(GSYVideoProgressListener videoProgressListener) {
        this.mGSYVideoProgressListener = videoProgressListener;
    }

    private class DismissControlViewTimerTask
    extends TimerTask {
        private DismissControlViewTimerTask() {
        }

        @Override
        public void run() {
            if (GSYVideoControlView.this.mCurrentState != 0 && GSYVideoControlView.this.mCurrentState != 7 && GSYVideoControlView.this.mCurrentState != 6 && GSYVideoControlView.this.getActivityContext() != null) {
                new Handler(Looper.getMainLooper()).post(new Runnable(){

                    @Override
                    public void run() {
                        GSYVideoControlView.this.hideAllWidget();
                        GSYVideoControlView.this.setViewShowState((View)GSYVideoControlView.this.mLockScreen, 8);
                        if (GSYVideoControlView.this.mHideKey && GSYVideoControlView.this.mIfCurrentIsFullscreen && GSYVideoControlView.this.mShowVKey) {
                            CommonUtil.hideNavKey(GSYVideoControlView.this.mContext);
                        }
                    }
                });
            }
        }
    }

    private class ProgressTimerTask
    extends TimerTask {
        private ProgressTimerTask() {
        }

        @Override
        public void run() {
            if (GSYVideoControlView.this.mCurrentState == 2 || GSYVideoControlView.this.mCurrentState == 5) {
                new Handler(Looper.getMainLooper()).post(new Runnable(){

                    @Override
                    public void run() {
                        GSYVideoControlView.this.setTextAndProgress(0);
                    }
                });
            }
        }
    }
}

