/*
 * Decompiled with CFR 0.152.
 */
package com.shuyu.gsyvideoplayer.effect;

import android.opengl.GLSurfaceView;
import com.shuyu.gsyvideoplayer.GSYVideoGLView;

public class VignetteEffect
implements GSYVideoGLView.ShaderInterface {
    private int mWidth = 0;
    private int mHeight = 0;
    private float mScale = 0.0f;
    private final float mShade = 0.85f;

    public VignetteEffect(float scale) {
        if (scale < 0.0f) {
            scale = 0.0f;
        }
        if (scale > 1.0f) {
            scale = 1.0f;
        }
        this.mScale = scale;
    }

    private void initValues(GLSurfaceView mGlSurfaceView) {
        this.mWidth = mGlSurfaceView.getWidth();
        this.mHeight = mGlSurfaceView.getHeight();
    }

    @Override
    public String getShader(GLSurfaceView mGlSurfaceView) {
        this.initValues(mGlSurfaceView);
        float[] scale = new float[2];
        if (this.mWidth > this.mHeight) {
            scale[0] = 1.0f;
            scale[1] = (float)this.mHeight / (float)this.mWidth;
        } else {
            scale[0] = (float)this.mWidth / (float)this.mHeight;
            scale[1] = 1.0f;
        }
        float max_dist = (float)Math.sqrt(scale[0] * scale[0] + scale[1] * scale[1]) * 0.5f;
        String[] scaleString = new String[]{"scale[0] = " + scale[0] + ";\n", "scale[1] = " + scale[1] + ";\n"};
        String inv_max_distString = "inv_max_dist = " + 1.0f / max_dist + ";\n";
        String shadeString = "shade = 0.85;\n";
        String rangeString = "range = " + (1.3f - (float)Math.sqrt(this.mScale) * 0.7f) + ";\n";
        String shader = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nuniform samplerExternalOES sTexture;\n float range;\n float inv_max_dist;\n float shade;\n vec2 scale;\nvarying vec2 vTextureCoord;\nvoid main() {\n" + scaleString[0] + scaleString[1] + inv_max_distString + shadeString + rangeString + "  const float slope = 20.0;\n  vec2 coord = vTextureCoord - vec2(0.5, 0.5);\n  float dist = length(coord * scale);\n  float lumen = shade / (1.0 + exp((dist * inv_max_dist - range) * slope)) + (1.0 - shade);\n  vec4 color = texture2D(sTexture, vTextureCoord);\n  gl_FragColor = vec4(color.rgb * lumen, color.a);\n}\n";
        return shader;
    }
}

