/*
 * Decompiled with CFR 0.152.
 */
package com.shuyu.waveview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewTreeObserver;
import com.BaseRecorder;
import com.shuyu.waveview.R;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;

public class AudioWaveView
extends View {
    public static final String MAX = "max_volume";
    public static final String MIN = "min_volume";
    protected final Object mLock = new Object();
    private Context mContext;
    private Bitmap mBitmap;
    private Bitmap mBackgroundBitmap;
    private Paint mPaint;
    private Paint mViewPaint;
    private Canvas mCanvas = new Canvas();
    private Canvas mBackCanVans = new Canvas();
    private final ArrayList<Short> mRecDataList = new ArrayList();
    protected final Object mLockRecDataList = new Object();
    private drawThread mInnerThread;
    private BaseRecorder mBaseRecorder;
    private int mWidthSpecSize;
    private int mHeightSpecSize;
    private int mScale = 1;
    private int mBaseLine;
    private int mOffset = -11;
    private boolean mAlphaByVolume;
    private boolean mIsDraw = true;
    private boolean mDrawBase = true;
    private boolean mDrawReverse = false;
    private boolean mDataReverse = false;
    private boolean mPause = false;
    private int mWaveCount = 2;
    private int mWaveColor = -1;
    private int mColorPoint = 1;
    private int mPreFFtCurrentFrequency;
    private int mColorChangeFlag;
    private int mColor1 = Color.argb((int)250, (int)111, (int)255, (int)129);
    private int mColor2 = Color.argb((int)250, (int)255, (int)255, (int)255);
    private int mColor3 = Color.argb((int)250, (int)66, (int)255, (int)255);
    private int mDrawStartOffset = 0;
    Handler handler = new Handler(){

        public void handleMessage(Message msg) {
            AudioWaveView.this.invalidate();
        }
    };

    public AudioWaveView(Context context) {
        super(context);
        this.init(context, null);
    }

    public AudioWaveView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public AudioWaveView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mIsDraw = false;
        if (this.mBitmap != null && !this.mBitmap.isRecycled()) {
            this.mBitmap.recycle();
        }
        if (this.mBackgroundBitmap != null && !this.mBackgroundBitmap.isRecycled()) {
            this.mBackgroundBitmap.recycle();
        }
    }

    public void init(Context context, AttributeSet attrs) {
        this.mContext = context;
        if (this.isInEditMode()) {
            return;
        }
        if (attrs != null) {
            TypedArray ta = this.getContext().obtainStyledAttributes(attrs, R.styleable.waveView);
            this.mOffset = ta.getInt(R.styleable.waveView_gsyWaveOffset, this.dip2px(context, -11.0f));
            this.mWaveColor = ta.getColor(R.styleable.waveView_gsyWaveColor, -1);
            this.mWaveCount = ta.getInt(R.styleable.waveView_gsyWaveCount, 2);
            ta.recycle();
        }
        if (this.mOffset == this.dip2px(context, -11.0f)) {
            this.mOffset = this.dip2px(context, 1.0f);
        }
        if (this.mWaveCount < 1) {
            this.mWaveCount = 1;
        } else if (this.mWaveCount > 2) {
            this.mWaveCount = 2;
        }
        this.mPaint = new Paint();
        this.mViewPaint = new Paint();
        this.mPaint.setColor(this.mWaveColor);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.creatBackGroundBitmap();
    }

    protected void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (visibility == 0 && this.mBackgroundBitmap == null) {
            this.creatBackGroundBitmap();
        }
    }

    private void creatBackGroundBitmap() {
        ViewTreeObserver vto = this.getViewTreeObserver();
        vto.addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

            public boolean onPreDraw() {
                if (AudioWaveView.this.getWidth() > 0 && AudioWaveView.this.getHeight() > 0) {
                    AudioWaveView.this.mWidthSpecSize = AudioWaveView.this.getWidth();
                    AudioWaveView.this.mHeightSpecSize = AudioWaveView.this.getHeight();
                    AudioWaveView.this.mBaseLine = AudioWaveView.this.mHeightSpecSize / 2;
                    AudioWaveView.this.mBackgroundBitmap = Bitmap.createBitmap((int)AudioWaveView.this.mWidthSpecSize, (int)AudioWaveView.this.mHeightSpecSize, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    AudioWaveView.this.mBitmap = Bitmap.createBitmap((int)AudioWaveView.this.mWidthSpecSize, (int)AudioWaveView.this.mHeightSpecSize, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    AudioWaveView.this.mBackCanVans.setBitmap(AudioWaveView.this.mBackgroundBitmap);
                    AudioWaveView.this.mCanvas.setBitmap(AudioWaveView.this.mBitmap);
                    ViewTreeObserver vto = AudioWaveView.this.getViewTreeObserver();
                    vto.removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                }
                return true;
            }
        });
    }

    private void drawNow(Short sh, int j) {
        if (sh != null) {
            short max = (short)(this.mBaseLine - sh / this.mScale);
            short min = this.mWaveCount == 2 ? (short)(sh / this.mScale + this.mBaseLine) : (short)this.mBaseLine;
            this.mBackCanVans.drawLine((float)j, (float)this.mBaseLine, (float)j, (float)max, this.mPaint);
            this.mBackCanVans.drawLine((float)j, (float)min, (float)j, (float)this.mBaseLine, this.mPaint);
        }
    }

    public List deepCopy(List src) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(byteOut);
        out.writeObject(src);
        ByteArrayInputStream byteIn = new ByteArrayInputStream(byteOut.toByteArray());
        ObjectInputStream in = new ObjectInputStream(byteIn);
        List dest = (List)in.readObject();
        return dest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onDraw(Canvas c) {
        super.onDraw(c);
        if (this.mIsDraw && this.mBitmap != null) {
            Object object = this.mLock;
            synchronized (object) {
                c.drawBitmap(this.mBitmap, 0.0f, 0.0f, this.mViewPaint);
            }
        }
    }

    private void resolveToWaveData(ArrayList<Short> list) {
        short allMax = 0;
        for (int i = 0; i < list.size(); ++i) {
            Short sh = list.get(i);
            if (sh == null || sh <= allMax) continue;
            allMax = sh;
        }
        int curScale = allMax / this.mBaseLine;
        if (curScale > this.mScale) {
            this.mScale = curScale == 0 ? 1 : curScale;
        }
    }

    public void startView() {
        if (this.mInnerThread != null && this.mInnerThread.isAlive()) {
            this.mIsDraw = false;
            while (this.mInnerThread.isAlive()) {
            }
            this.mBackCanVans.drawColor(0, PorterDuff.Mode.CLEAR);
            this.mCanvas.drawColor(0, PorterDuff.Mode.CLEAR);
        }
        this.mIsDraw = true;
        this.mInnerThread = new drawThread();
        this.mInnerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopView(boolean cleanView) {
        this.mIsDraw = false;
        if (this.mInnerThread != null) {
            while (this.mInnerThread.isAlive()) {
            }
        }
        Object object = this.mLockRecDataList;
        synchronized (object) {
            this.mRecDataList.clear();
        }
        if (cleanView) {
            this.mRecDataList.clear();
            this.mBackCanVans.drawColor(0, PorterDuff.Mode.CLEAR);
            this.mCanvas.drawColor(0, PorterDuff.Mode.CLEAR);
        }
    }

    public void stopView() {
        this.stopView(true);
    }

    private void updateColor() {
        if (this.mBaseRecorder == null) {
            return;
        }
        int volume = this.mBaseRecorder.getRealVolume();
        int scale = volume / 100;
        if (scale < 5) {
            this.mPreFFtCurrentFrequency = scale;
            return;
        }
        int fftScale = 0;
        if (this.mPreFFtCurrentFrequency != 0) {
            fftScale = scale / this.mPreFFtCurrentFrequency;
        }
        if (this.mColorChangeFlag == 4 || fftScale > 10) {
            this.mColorChangeFlag = 0;
        }
        if (this.mColorChangeFlag == 0) {
            if (this.mColorPoint == 1) {
                this.mColorPoint = 2;
            } else if (this.mColorPoint == 2) {
                this.mColorPoint = 3;
            } else if (this.mColorPoint == 3) {
                this.mColorPoint = 1;
            }
            int color = this.mColorPoint == 1 ? Color.argb((int)(this.mAlphaByVolume ? 50 * scale : 255), (int)Color.red((int)this.mColor1), (int)Color.green((int)this.mColor1), (int)Color.blue((int)this.mColor1)) : (this.mColorPoint == 2 ? Color.argb((int)(this.mAlphaByVolume ? 50 * scale : 255), (int)Color.red((int)this.mColor2), (int)Color.green((int)this.mColor2), (int)Color.blue((int)this.mColor2)) : Color.argb((int)(this.mAlphaByVolume ? 50 * scale : 255), (int)Color.red((int)this.mColor3), (int)Color.green((int)this.mColor3), (int)Color.blue((int)this.mColor3)));
            this.mPaint.setColor(color);
        }
        ++this.mColorChangeFlag;
        if (scale != 0) {
            this.mPreFFtCurrentFrequency = scale;
        }
    }

    public boolean isPause() {
        return this.mPause;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPause(boolean pause) {
        ArrayList<Short> arrayList = this.mRecDataList;
        synchronized (arrayList) {
            this.mPause = pause;
        }
    }

    public void setChangeColor(int color1, int color2, int color3) {
        this.mColor1 = color1;
        this.mColor2 = color2;
        this.mColor3 = color3;
    }

    public boolean isAlphaByVolume() {
        return this.mAlphaByVolume;
    }

    public void setAlphaByVolume(boolean alphaByVolume) {
        this.mAlphaByVolume = alphaByVolume;
    }

    public void setBaseRecorder(BaseRecorder baseRecorder) {
        this.mBaseRecorder = baseRecorder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Short> getRecList() {
        Object object = this.mLockRecDataList;
        synchronized (object) {
            return this.mRecDataList;
        }
    }

    public void setOffset(int offset) {
        this.mOffset = offset;
    }

    public int getWaveColor() {
        return this.mWaveColor;
    }

    public void setWaveColor(int waveColor) {
        this.mWaveColor = waveColor;
        if (this.mPaint != null) {
            this.mPaint.setColor(this.mWaveColor);
        }
    }

    public void setLinePaint(Paint paint) {
        if (paint != null) {
            this.mPaint = paint;
        }
    }

    public void setWaveCount(int waveCount) {
        this.mWaveCount = waveCount;
        if (this.mWaveCount < 1) {
            this.mWaveCount = 1;
        } else if (this.mWaveCount > 2) {
            this.mWaveCount = 2;
        }
    }

    private int dip2px(Context context, float dipValue) {
        float fontScale = context.getResources().getDisplayMetrics().density;
        return (int)(dipValue * fontScale + 0.5f);
    }

    public void setDrawBase(boolean drawBase) {
        this.mDrawBase = drawBase;
    }

    public void setDrawReverse(boolean drawReverse) {
        this.mDrawReverse = drawReverse;
    }

    public void setDataReverse(boolean dataReverse) {
        this.mDataReverse = dataReverse;
    }

    public void setDrawStartOffset(int drawStartOffset) {
        this.mDrawStartOffset = drawStartOffset;
    }

    private class drawThread
    extends Thread {
        private drawThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (AudioWaveView.this.mIsDraw) {
                ArrayList dataList = new ArrayList();
                Object object = AudioWaveView.this.mLockRecDataList;
                synchronized (object) {
                    if (AudioWaveView.this.mRecDataList.size() != 0) {
                        try {
                            dataList = (ArrayList)AudioWaveView.this.deepCopy(AudioWaveView.this.mRecDataList);
                        }
                        catch (Exception e) {
                            continue;
                        }
                    }
                }
                if (AudioWaveView.this.mBackgroundBitmap == null) continue;
                if (!AudioWaveView.this.mPause) {
                    AudioWaveView.this.resolveToWaveData(dataList);
                    if (dataList.size() > 0) {
                        AudioWaveView.this.updateColor();
                    }
                    if (AudioWaveView.this.mBackCanVans != null) {
                        Short sh;
                        int j;
                        int i2;
                        int jOffset;
                        AudioWaveView.this.mBackCanVans.drawColor(0, PorterDuff.Mode.CLEAR);
                        int drawBufsize = dataList.size();
                        int startPosition = AudioWaveView.this.mDrawReverse ? AudioWaveView.this.mWidthSpecSize - AudioWaveView.this.mDrawStartOffset : AudioWaveView.this.mDrawStartOffset;
                        int n = jOffset = AudioWaveView.this.mDrawReverse ? -AudioWaveView.this.mOffset : AudioWaveView.this.mOffset;
                        if (AudioWaveView.this.mDrawBase) {
                            if (AudioWaveView.this.mDataReverse) {
                                AudioWaveView.this.mBackCanVans.drawLine((float)startPosition, (float)AudioWaveView.this.mBaseLine, 0.0f, (float)AudioWaveView.this.mBaseLine, AudioWaveView.this.mPaint);
                            } else {
                                AudioWaveView.this.mBackCanVans.drawLine((float)startPosition, (float)AudioWaveView.this.mBaseLine, (float)AudioWaveView.this.mWidthSpecSize, (float)AudioWaveView.this.mBaseLine, AudioWaveView.this.mPaint);
                            }
                        }
                        if (AudioWaveView.this.mDataReverse) {
                            i2 = drawBufsize - 1;
                            j = startPosition;
                            while (i2 >= 0) {
                                sh = (Short)dataList.get(i2);
                                AudioWaveView.this.drawNow(sh, j);
                                --i2;
                                j += jOffset;
                            }
                        } else {
                            i2 = 0;
                            j = startPosition;
                            while (i2 < drawBufsize) {
                                sh = (Short)dataList.get(i2);
                                AudioWaveView.this.drawNow(sh, j);
                                ++i2;
                                j += jOffset;
                            }
                        }
                        Object i2 = AudioWaveView.this.mLock;
                        synchronized (i2) {
                            AudioWaveView.this.mCanvas.drawColor(0, PorterDuff.Mode.CLEAR);
                            AudioWaveView.this.mCanvas.drawBitmap(AudioWaveView.this.mBackgroundBitmap, 0.0f, 0.0f, AudioWaveView.this.mPaint);
                        }
                        Message msg = new Message();
                        msg.what = 0;
                        AudioWaveView.this.handler.sendMessage(msg);
                    }
                }
                try {
                    Thread.sleep(30L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

