/*
 * Decompiled with CFR 0.152.
 */
package com.czt.mp3recorder;

import android.media.AudioRecord;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import com.czt.mp3recorder.MP3Recorder;
import com.czt.mp3recorder.util.LameUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DataEncodeThread
extends HandlerThread
implements AudioRecord.OnRecordPositionUpdateListener {
    private StopHandler mHandler;
    private static final int PROCESS_STOP = 1;
    private static final int PROCESS_ERROR = 2;
    private byte[] mMp3Buffer;
    private FileOutputStream mFileOutputStream;
    private String path;
    private List<Task> mTasks = Collections.synchronizedList(new ArrayList());

    public DataEncodeThread(File file, int bufferSize) throws FileNotFoundException {
        super("DataEncodeThread");
        this.mFileOutputStream = new FileOutputStream(file);
        this.path = file.getAbsolutePath();
        this.mMp3Buffer = new byte[(int)(7200.0 + (double)(bufferSize * 2) * 1.25)];
    }

    public synchronized void start() {
        super.start();
        this.mHandler = new StopHandler(this.getLooper(), this);
    }

    private void check() {
        if (this.mHandler == null) {
            throw new IllegalStateException();
        }
    }

    public void sendStopMessage() {
        this.check();
        this.mHandler.sendEmptyMessage(1);
    }

    public void sendErrorMessage() {
        this.check();
        this.mHandler.sendEmptyMessage(2);
    }

    public Handler getHandler() {
        this.check();
        return this.mHandler;
    }

    public void onMarkerReached(AudioRecord recorder) {
    }

    public void onPeriodicNotification(AudioRecord recorder) {
        this.processData();
    }

    private int processData() {
        if (this.mTasks.size() > 0) {
            int readSize;
            Task task = this.mTasks.remove(0);
            short[] buffer = task.getData();
            int encodedSize = LameUtil.encode(buffer, buffer, readSize = task.getReadSize(), this.mMp3Buffer);
            if (encodedSize > 0) {
                try {
                    this.mFileOutputStream.write(this.mMp3Buffer, 0, encodedSize);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return readSize;
        }
        return 0;
    }

    private void flushAndRelease() {
        int flushResult = LameUtil.flush(this.mMp3Buffer);
        if (flushResult > 0) {
            try {
                this.mFileOutputStream.write(this.mMp3Buffer, 0, flushResult);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (this.mFileOutputStream != null) {
                    try {
                        this.mFileOutputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                LameUtil.close();
            }
        }
    }

    public void addTask(short[] rawData, int readSize) {
        this.mTasks.add(new Task(rawData, readSize));
    }

    private static class StopHandler
    extends Handler {
        private DataEncodeThread encodeThread;

        public StopHandler(Looper looper, DataEncodeThread encodeThread) {
            super(looper);
            this.encodeThread = encodeThread;
        }

        public void handleMessage(Message msg) {
            if (msg.what == 1) {
                while (this.encodeThread.processData() > 0) {
                }
                this.removeCallbacksAndMessages(null);
                this.encodeThread.flushAndRelease();
                this.getLooper().quit();
            } else if (msg.what == 2) {
                while (this.encodeThread.processData() > 0) {
                }
                this.removeCallbacksAndMessages(null);
                this.encodeThread.flushAndRelease();
                this.getLooper().quit();
                MP3Recorder.deleteFile(this.encodeThread.path);
            }
        }
    }

    private class Task {
        private short[] rawData;
        private int readSize;

        public Task(short[] rawData, int readSize) {
            this.rawData = (short[])rawData.clone();
            this.readSize = readSize;
        }

        public short[] getData() {
            return this.rawData;
        }

        public int getReadSize() {
            return this.readSize;
        }
    }
}

