/*
 * Decompiled with CFR 0.152.
 */
package com.bytehamster.lib.preferencesearch.ui;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ArgbEvaluator;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.View;
import android.view.ViewAnimationUtils;
import androidx.interpolator.view.animation.FastOutSlowInInterpolator;
import com.bytehamster.lib.preferencesearch.ui.RevealAnimationSetting;

public class AnimationUtils {
    public static void registerCircularRevealAnimation(final Context context, final View view, final RevealAnimationSetting revealSettings) {
        final int startColor = revealSettings.getColorAccent();
        final int endColor = AnimationUtils.getBackgroundColor(view);
        if (Build.VERSION.SDK_INT >= 21) {
            view.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

                @TargetApi(value=21)
                public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                    v.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this);
                    view.setVisibility(0);
                    int cx = revealSettings.getCenterX();
                    int cy = revealSettings.getCenterY();
                    int width = revealSettings.getWidth();
                    int height = revealSettings.getHeight();
                    int duration = context.getResources().getInteger(17694722);
                    float finalRadius = (float)Math.sqrt(width * width + height * height);
                    Animator anim = ViewAnimationUtils.createCircularReveal((View)v, (int)cx, (int)cy, (float)0.0f, (float)finalRadius).setDuration((long)duration);
                    anim.setInterpolator((TimeInterpolator)new FastOutSlowInInterpolator());
                    anim.start();
                    AnimationUtils.startColorAnimation(view, startColor, endColor, duration);
                }
            });
        }
    }

    private static void startColorAnimation(final View view, int startColor, int endColor, int duration) {
        ValueAnimator anim = new ValueAnimator();
        anim.setIntValues(new int[]{startColor, endColor});
        anim.setEvaluator((TypeEvaluator)new ArgbEvaluator());
        anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                view.setBackgroundColor(((Integer)valueAnimator.getAnimatedValue()).intValue());
            }
        });
        anim.setDuration((long)duration);
        anim.start();
    }

    public static void startCircularExitAnimation(Context context, final View view, RevealAnimationSetting revealSettings, final OnDismissedListener listener) {
        int startColor = AnimationUtils.getBackgroundColor(view);
        int endColor = revealSettings.getColorAccent();
        if (Build.VERSION.SDK_INT >= 21) {
            int cx = revealSettings.getCenterX();
            int cy = revealSettings.getCenterY();
            int width = revealSettings.getWidth();
            int height = revealSettings.getHeight();
            int duration = context.getResources().getInteger(17694722);
            float initRadius = (float)Math.sqrt(width * width + height * height);
            Animator anim = ViewAnimationUtils.createCircularReveal((View)view, (int)cx, (int)cy, (float)initRadius, (float)0.0f);
            anim.setDuration((long)duration);
            anim.setInterpolator((TimeInterpolator)new FastOutSlowInInterpolator());
            anim.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    view.setVisibility(4);
                    listener.onDismissed();
                }
            });
            anim.start();
            AnimationUtils.startColorAnimation(view, startColor, endColor, duration);
        } else {
            listener.onDismissed();
        }
    }

    private static int getBackgroundColor(View view) {
        int color = 0;
        Drawable background = view.getBackground();
        if (background instanceof ColorDrawable) {
            color = ((ColorDrawable)background).getColor();
        }
        return color;
    }

    public static interface OnDismissedListener {
        public void onDismissed();
    }
}

