/*
 * Decompiled with CFR 0.152.
 */
package com.bytehamster.lib.preferencesearch;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.SearchView;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import com.bytehamster.lib.preferencesearch.SearchConfiguration;
import com.bytehamster.lib.preferencesearch.SearchPreferenceFragment;

public class SearchPreferenceActionView
extends SearchView {
    private SearchPreferenceFragment searchFragment;
    private SearchConfiguration searchConfiguration = new SearchConfiguration();
    private AppCompatActivity activity;

    public SearchPreferenceActionView(Context context) {
        super(context);
        this.initView();
    }

    public SearchPreferenceActionView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public SearchPreferenceActionView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
    }

    private void initView() {
        this.searchConfiguration.setSearchBarEnabled(false);
        this.setOnQueryTextListener(new SearchView.OnQueryTextListener(){

            public boolean onQueryTextSubmit(String query) {
                return false;
            }

            public boolean onQueryTextChange(String newText) {
                if (SearchPreferenceActionView.this.searchFragment != null) {
                    SearchPreferenceActionView.this.searchFragment.setSearchTerm(newText);
                }
                return true;
            }
        });
        this.setOnQueryTextFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (hasFocus && (SearchPreferenceActionView.this.searchFragment == null || !SearchPreferenceActionView.this.searchFragment.isVisible())) {
                    SearchPreferenceActionView.this.searchFragment = SearchPreferenceActionView.this.searchConfiguration.showSearchFragment();
                    SearchPreferenceActionView.this.searchFragment.setHistoryClickListener(new SearchPreferenceFragment.HistoryClickListener(){

                        @Override
                        public void onHistoryEntryClicked(String entry) {
                            SearchPreferenceActionView.this.setQuery(entry, false);
                        }
                    });
                }
            }
        });
    }

    public SearchConfiguration getSearchConfiguration() {
        return this.searchConfiguration;
    }

    public boolean cancelSearch() {
        this.setQuery("", false);
        boolean didSomething = false;
        if (!this.isIconified()) {
            this.setIconified(true);
            didSomething = true;
        }
        if (this.searchFragment != null && this.searchFragment.isVisible()) {
            this.removeFragment();
            didSomething = true;
        }
        return didSomething;
    }

    private void removeFragment() {
        if (this.searchFragment.isVisible()) {
            FragmentManager fm = this.activity.getSupportFragmentManager();
            fm.beginTransaction().remove((Fragment)this.searchFragment).commit();
            fm.popBackStack("SearchPreferenceFragment", 1);
        }
    }

    public void setActivity(AppCompatActivity activity) {
        this.searchConfiguration.setActivity(activity);
        this.activity = activity;
    }
}

