/*
 * Decompiled with CFR 0.152.
 */
package com.bytehamster.lib.preferencesearch;

import android.text.TextUtils;
import com.bytehamster.lib.preferencesearch.ListItem;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.text.similarity.FuzzyScore;

class PreferenceItem
extends ListItem {
    static final int TYPE = 2;
    private static FuzzyScore fuzzyScore = new FuzzyScore(Locale.getDefault());
    String title;
    String summary;
    String key;
    String entries;
    String breadcrumbs;
    String keywords;
    ArrayList<String> keyBreadcrumbs = new ArrayList();
    int resId;
    private float lastScore = 0.0f;
    private String lastKeyword = null;

    PreferenceItem() {
    }

    boolean hasData() {
        return this.title != null || this.summary != null;
    }

    boolean matchesFuzzy(String keyword) {
        return (double)this.getScore(keyword) > 0.3;
    }

    boolean matches(String keyword) {
        return this.getInfo().contains(keyword);
    }

    float getScore(String keyword) {
        if (TextUtils.isEmpty((CharSequence)keyword)) {
            return 0.0f;
        }
        if (TextUtils.equals((CharSequence)this.lastKeyword, (CharSequence)keyword)) {
            return this.lastScore;
        }
        String info = this.getInfo();
        float score = fuzzyScore.fuzzyScore((CharSequence)info, (CharSequence)("\u00f8" + keyword)).intValue();
        float maxScore = (keyword.length() + 1) * 3 - 2;
        this.lastScore = score / maxScore;
        this.lastKeyword = keyword;
        return this.lastScore;
    }

    private String getInfo() {
        StringBuilder infoBuilder = new StringBuilder();
        if (!TextUtils.isEmpty((CharSequence)this.title)) {
            infoBuilder.append("\u00f8").append(this.title);
        }
        if (!TextUtils.isEmpty((CharSequence)this.summary)) {
            infoBuilder.append("\u00f8").append(this.summary);
        }
        if (!TextUtils.isEmpty((CharSequence)this.entries)) {
            infoBuilder.append("\u00f8").append(this.entries);
        }
        if (!TextUtils.isEmpty((CharSequence)this.breadcrumbs)) {
            infoBuilder.append("\u00f8").append(this.breadcrumbs);
        }
        if (!TextUtils.isEmpty((CharSequence)this.keywords)) {
            infoBuilder.append("\u00f8").append(this.keywords);
        }
        return infoBuilder.toString();
    }

    public String toString() {
        return "PreferenceItem: " + this.title + " " + this.summary + " " + this.key;
    }

    @Override
    public int getType() {
        return 2;
    }
}

