/*
 * Decompiled with CFR 0.152.
 */
package io.github.wax911.library.persisted.query;

import io.github.wax911.library.annotation.processor.contract.AbstractGraphProcessor;
import io.github.wax911.library.logger.core.AbstractLogger;
import io.github.wax911.library.persisted.contract.IAutomaticPersistedQuery;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007H\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/github/wax911/library/persisted/query/AutomaticPersistedQueryCalculator;", "Lio/github/wax911/library/persisted/contract/IAutomaticPersistedQuery;", "processor", "Lio/github/wax911/library/annotation/processor/contract/AbstractGraphProcessor;", "(Lio/github/wax911/library/annotation/processor/contract/AbstractGraphProcessor;)V", "apqHashes", "", "", "createAndStoreHash", "queryName", "fileKey", "getOrCreateAPQHash", "hashOfQuery", "query", "Companion", "library_release"})
public final class AutomaticPersistedQueryCalculator
implements IAutomaticPersistedQuery {
    private final Map<String, String> apqHashes;
    private final AbstractGraphProcessor processor;
    private static final String TAG;
    private static final String sha256Algorithm = "SHA-256";
    public static final Companion Companion;

    private final String hashOfQuery(String query) {
        MessageDigest md = MessageDigest.getInstance(sha256Algorithm);
        String string = query;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        md.update(byArray);
        byte[] digest = md.digest();
        charset = StringCompanionObject.INSTANCE;
        String string3 = "%064x";
        Object[] objectArray = new Object[]{new BigInteger(1, digest)};
        boolean bl2 = false;
        String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(format, *args)");
        return string4;
    }

    private final String createAndStoreHash(String queryName, String fileKey) {
        String string;
        AbstractLogger logger = this.processor.getLogger$library_release();
        String string2 = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
        AbstractLogger.d$default(logger, string2, "Creating APQ hash for " + queryName, null, 4, null);
        if (this.processor.getGraphFiles().containsKey(fileKey)) {
            String hashOfQuery = this.hashOfQuery((String)MapsKt.getValue(this.processor.getGraphFiles(), (Object)fileKey));
            String string3 = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"TAG");
            AbstractLogger.v$default(logger, string3, "Created hash for query " + fileKey + " -> " + hashOfQuery, null, 4, null);
            this.apqHashes.put(fileKey, hashOfQuery);
            string = hashOfQuery;
        } else {
            String string4 = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"TAG");
            logger.e(string4, "Current size of discovered graphql files -> " + this.processor.getGraphFiles().size(), new Throwable("The request query " + fileKey + " could not be found!"));
            string = null;
        }
        return string;
    }

    @Override
    @Nullable
    public String getOrCreateAPQHash(@NotNull String queryName) {
        Intrinsics.checkNotNullParameter((Object)queryName, (String)"queryName");
        String fileKey = queryName + this.processor.getDefaultExtension$library_release();
        return this.apqHashes.containsKey(fileKey) ? this.apqHashes.get(fileKey) : this.createAndStoreHash(queryName, fileKey);
    }

    public AutomaticPersistedQueryCalculator(@NotNull AbstractGraphProcessor processor) {
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        this.processor = processor;
        this.apqHashes = new HashMap();
    }

    static {
        Companion = new Companion(null);
        TAG = AutomaticPersistedQueryCalculator.class.getSimpleName();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/github/wax911/library/persisted/query/AutomaticPersistedQueryCalculator$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "sha256Algorithm", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

