package com.amity.socialcloud.sdk.socket.util

import android.net.Uri
import com.google.gson.*
import java.lang.reflect.Type

class UriTypeConverter : JsonDeserializer<Uri>, JsonSerializer<Uri> {

    override fun deserialize(json: JsonElement?, typeOfT: Type?, context: JsonDeserializationContext?): Uri {
        return json?.takeIf { json.isJsonPrimitive }?.asJsonPrimitive?.asString?.let { Uri.parse(it) } ?: Uri.EMPTY
    }

    override fun serialize(src: Uri?, typeOfSrc: Type?, context: JsonSerializationContext?): JsonElement {
        return src?.let { JsonPrimitive(src.toString()) } ?: JsonNull.INSTANCE
    }
}