package com.ekoapp.ekosdk.internal.paging

import androidx.paging.ExperimentalPagingApi
import androidx.paging.PagingConfig
import androidx.paging.PagingData
import androidx.paging.PagingSource
import com.amity.socialcloud.sdk.common.ModelMapper
import com.ekoapp.ekosdk.ReactorObject
import com.ekoapp.ekosdk.internal.mediator.DynamicQueryStreamMediator
import io.reactivex.Flowable
import io.reactivex.disposables.CompositeDisposable

@ExperimentalPagingApi
open class DynamicQueryStreamPagerCreator<Entity : Any, ResponseDto : Any,
        AmityModel : Any, ReactorModel : ReactorObject>(
    pagingConfig: PagingConfig,
    initialKey: Int? = null,
    dynamicQueryStreamMediator: DynamicQueryStreamMediator<Entity, ResponseDto, ReactorModel>,
    pagingSourceFactory: () -> PagingSource<Int, Entity>,
    modelMapper: ModelMapper<Entity, AmityModel>
) : QueryStreamPagerCreator<Entity, ResponseDto, AmityModel>(
    pagingConfig,
    initialKey,
    dynamicQueryStreamMediator,
    pagingSourceFactory,
    modelMapper
) {

    private val reactorDisposable = CompositeDisposable()

    init {
        dynamicQueryStreamMediator.setup(reactorDisposable)
    }

    override fun create(): Flowable<PagingData<AmityModel>> {
        return super.create()
            .doOnTerminate {
                if (reactorDisposable.size() > 0 && !reactorDisposable.isDisposed) {
                    reactorDisposable.dispose()
                    reactorDisposable.clear()
                }
            }
    }
}